/*
 * Decompiled with CFR 0.152.
 */
package com.kloudless.models;

import com.google.gson.JsonObject;
import com.kloudless.exceptions.ApiException;
import com.kloudless.models.Resource;
import com.kloudless.models.ResponseBase;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class ResourceList
extends ResponseBase {
    private List<Resource> resources;
    private String page;
    private String cursor;
    private String nextPageCursor;
    private JsonObject data;

    public ResourceList(String url, Map<String, Object> defaultHeaders, List<Resource> resources, JsonObject data) {
        this.url = this.storeAndRemoveQueryString(url);
        this.defaultHeaders = defaultHeaders;
        this.resources = resources;
        this.page = data.get("page") == null || data.get("page").isJsonNull() ? null : data.get("page").getAsString();
        String string = this.cursor = data.get("cursor") == null || data.get("cursor").isJsonNull() ? null : data.get("cursor").getAsString();
        this.nextPageCursor = data.get("next_page") != null && !data.get("next_page").isJsonNull() ? data.get("next_page").getAsString() : (data.get("next_page") != null && data.get("next_page").isJsonNull() ? "" : (this.cursor != null ? (this.resources.size() == 0 ? "" : this.cursor) : null));
        this.data = data;
    }

    private int toInt(String pageString) {
        int pageInt;
        try {
            pageInt = Integer.parseInt(this.page);
        }
        catch (NumberFormatException e) {
            pageInt = -1;
        }
        return pageInt;
    }

    private ResourceList tryNextPage(String cursor, String nextCursor) throws ApiException {
        String url = cursor != null ? "?cursor=" + nextCursor : "?page=" + nextCursor;
        return (ResourceList)super.get(url);
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public String getPage() {
        return this.page;
    }

    public String getCursor() {
        return this.cursor;
    }

    public String getNextPageCursor() {
        if (this.nextPageCursor != null && !this.nextPageCursor.isEmpty()) {
            return this.nextPageCursor;
        }
        if (this.nextPageCursor != null && this.nextPageCursor.isEmpty()) {
            return null;
        }
        if (this.page != null && this.toInt(this.page) > 0) {
            try {
                ResourceList nextPage = this.tryNextPage(this.cursor, String.valueOf(this.toInt(this.page) + 1));
                if (nextPage.getResources().size() > 0) {
                    return String.valueOf(this.toInt(this.page) + 1);
                }
                return null;
            }
            catch (ApiException e) {
                return null;
            }
        }
        return null;
    }

    public JsonObject getData() {
        return this.data;
    }

    public boolean hasNextPage() throws ApiException {
        return this.getNextPageCursor() != null;
    }

    public ResourceList getNextPage() throws ApiException {
        try {
            if (!this.hasNextPage()) {
                throw new ApiException("There is no next page.", null);
            }
            return this.tryNextPage(this.cursor, this.getNextPageCursor());
        }
        catch (ApiException e) {
            throw new ApiException("Failed to retrieve next page.", e);
        }
    }

    public void refresh() throws ApiException {
        ResourceList newResourceList = (ResourceList)super.get("");
        this.data = newResourceList.getData();
        this.page = newResourceList.getPage();
        this.cursor = newResourceList.getCursor();
        this.nextPageCursor = newResourceList.getNextPageCursor();
    }

    public Iterator<Resource> getPageIterator() {
        return this.getPageIterator(Long.MAX_VALUE);
    }

    public Iterator<Resource> getPageIterator(final Long maxGet) {
        return new Iterator<Resource>(){
            private int index = 0;
            private List<Resource> localResources = ResourceList.access$000(ResourceList.this);
            private String curPage = ResourceList.access$100(ResourceList.this);
            private String localCursor = ResourceList.access$200(ResourceList.this);
            private String localNextPageCursor = ResourceList.this.getNextPageCursor();
            private String localUrl;
            private long maxResource;
            private long curTotal;
            {
                this.localUrl = ResourceList.this.url;
                this.maxResource = maxGet;
                this.curTotal = 0L;
            }

            @Override
            public boolean hasNext() {
                return (this.index < this.localResources.size() || this.localNextPageCursor != null) && this.curTotal < this.maxResource;
            }

            @Override
            public Resource next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this.curTotal;
                if (this.index < this.localResources.size()) {
                    Resource resource = this.localResources.get(this.index);
                    ++this.index;
                    return resource;
                }
                try {
                    ResourceList tempResourceList = this.getNextPageData();
                    this.curPage = tempResourceList.getPage();
                    this.localNextPageCursor = tempResourceList.getNextPageCursor();
                    this.localResources = tempResourceList.getResources();
                    this.localUrl = tempResourceList.getUrl();
                    this.localCursor = tempResourceList.getCursor();
                    this.index = 0;
                    Resource resource = this.localResources.get(this.index);
                    ++this.index;
                    return resource;
                }
                catch (ApiException | IndexOutOfBoundsException | URISyntaxException e) {
                    throw new NoSuchElementException(String.format("Get next failed, curTotal %s, page %s, index %s, url %s, reason %s", this.curTotal, this.curPage, this.index, this.localUrl, e.getMessage()));
                }
            }

            private ResourceList getNextPageData() throws URISyntaxException, ApiException {
                if (!this.hasNext()) {
                    throw new ApiException("There is no next page.", null);
                }
                return ResourceList.this.tryNextPage(this.localCursor, this.localNextPageCursor);
            }
        };
    }

    static /* synthetic */ List access$000(ResourceList x0) {
        return x0.resources;
    }

    static /* synthetic */ String access$100(ResourceList x0) {
        return x0.page;
    }

    static /* synthetic */ String access$200(ResourceList x0) {
        return x0.cursor;
    }
}

