/*
 * Decompiled with CFR 0.152.
 */
package com.kubedb.client.util;

import com.kubedb.client.ApiClient;
import com.kubedb.client.ApiException;
import com.kubedb.client.Pair;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.squareup.okhttp.ws.WebSocket;
import com.squareup.okhttp.ws.WebSocketCall;
import com.squareup.okhttp.ws.WebSocketListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okio.Buffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSockets {
    private static final Logger log = LoggerFactory.getLogger(WebSockets.class);
    public static final String V4_STREAM_PROTOCOL = "v4.channel.k8s.io";
    public static final String STREAM_PROTOCOL_HEADER = "Sec-WebSocket-Protocol";
    public static final String SPDY_3_1 = "SPDY/3.1";

    public static void stream(String path, String method, ApiClient client, SocketListener listener) throws ApiException, IOException {
        WebSockets.stream(path, method, new ArrayList<Pair>(), client, listener);
    }

    public static void stream(String path, String method, List<Pair> queryParams, ApiClient client, SocketListener listener) throws ApiException, IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(STREAM_PROTOCOL_HEADER, V4_STREAM_PROTOCOL);
        headers.put("Connection", "Upgrade");
        headers.put("Upgrade", SPDY_3_1);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        Request request = client.buildRequest(path, method, queryParams, new ArrayList(), null, headers, new HashMap(), localVarAuthNames, null);
        WebSockets.streamRequest(request, client, listener);
    }

    private static void streamRequest(Request request, ApiClient client, SocketListener listener) {
        WebSocketCall.create((OkHttpClient)client.getHttpClient(), (Request)request).enqueue((WebSocketListener)new Listener(listener));
    }

    public static class Listener
    implements WebSocketListener {
        private SocketListener listener;

        public Listener(SocketListener listener) {
            this.listener = listener;
        }

        public void onOpen(WebSocket webSocket, Response response) {
            String protocol = response.header(WebSockets.STREAM_PROTOCOL_HEADER, "missing");
            this.listener.open(protocol, webSocket);
        }

        public void onMessage(ResponseBody body) throws IOException {
            if (body.contentType() == WebSocket.TEXT) {
                this.listener.textMessage(body.charStream());
            } else if (body.contentType() == WebSocket.BINARY) {
                this.listener.bytesMessage(body.byteStream());
            }
            body.close();
        }

        public void onPong(Buffer payload) {
        }

        public void onClose(int code, String reason) {
            this.listener.close();
        }

        public void onFailure(IOException e, Response res) {
            e.printStackTrace();
            this.listener.close();
        }
    }

    public static interface SocketListener {
        public void open(String var1, WebSocket var2);

        public void bytesMessage(InputStream var1);

        public void textMessage(Reader var1);

        public void close();
    }
}

