/*
 * Decompiled with CFR 0.152.
 */
package com.labstack;

import com.labstack.APIInterceptor;
import com.labstack.Log;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;

public class Client {
    private OkHttpClient okHttp;
    private String appId;
    private String appName;
    public static final String API_URL = "https://api.labstack.com";
    public static final MediaType MEDIA_TYPE_JSON = MediaType.parse((String)"application/json; charset=utf-8");

    public Client(String apiKey) {
        this.okHttp = new OkHttpClient.Builder().addInterceptor((Interceptor)new APIInterceptor(apiKey)).build();
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public Log Log() {
        Log log = new Log();
        log.okHttp = this.okHttp;
        log.setAppId(this.appId);
        log.setAppName(this.appName);
        log.setLevel(Log.Level.INFO);
        log.setBatchSize(60);
        log.setDispatchInterval(60);
        return log;
    }
}

