/*
 * Decompiled with CFR 0.152.
 */
package com.labstack;

import com.labstack.Client;
import com.labstack.LogEntry;
import com.labstack.LogException;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public final class Log {
    protected OkHttpClient okHttp;
    private Moshi moshi = new Moshi.Builder().build();
    private JsonAdapter<List<LogEntry>> entriesJsonAdapter = this.moshi.adapter((Type)Types.newParameterizedType(List.class, (Type[])new Type[]{LogEntry.class}));
    private JsonAdapter<LogException> exceptionJsonAdapter = this.moshi.adapter(LogException.class);
    private Timer timer;
    private List<LogEntry> entries = Collections.synchronizedList(new ArrayList());
    private String appId;
    private String appName;
    private String[] tags;
    private Level level;
    private int batchSize;
    private int dispatchInterval;

    protected Log() {
    }

    private void dispatch() throws LogException {
        if (this.entries.size() == 0) {
            return;
        }
        String json = this.entriesJsonAdapter.toJson(this.entries);
        Request request = new Request.Builder().url("https://api.labstack.com/log").post(RequestBody.create((MediaType)Client.MEDIA_TYPE_JSON, (String)json)).build();
        try {
            Response response = this.okHttp.newCall(request).execute();
            if (!response.isSuccessful()) {
                throw (LogException)this.exceptionJsonAdapter.fromJson(response.body().source());
            }
        }
        catch (IOException e) {
            throw new LogException(0, e.getMessage());
        }
        this.entries.clear();
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setTags(String[] tags) {
        this.tags = tags;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setDispatchInterval(int dispatchInterval) {
        this.dispatchInterval = dispatchInterval;
    }

    public void debug(String format, Object ... args) {
        this.log(Level.DEBUG, format, args);
    }

    public void info(String format, Object ... args) {
        this.log(Level.INFO, format, args);
    }

    public void warn(String format, Object ... args) {
        this.log(Level.WARN, format, args);
    }

    public void error(String format, Object ... args) {
        this.log(Level.ERROR, format, args);
    }

    public void fatal(String format, Object ... args) {
        this.log(Level.FATAL, format, args);
    }

    public void log(Level level, String format, Object ... args) {
        if (level.compareTo(this.level) < 0) {
            return;
        }
        if (this.timer == null) {
            this.timer = new Timer();
            this.timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    try {
                        Log.this.dispatch();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }, 0L, TimeUnit.SECONDS.toMillis(this.dispatchInterval));
        }
        String message = String.format(format, args);
        LogEntry entry = new LogEntry(this.appId, this.appName, this.tags, level, message);
        this.entries.add(entry);
        if (this.entries.size() >= this.batchSize) {
            try {
                this.dispatch();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static enum Level {
        DEBUG,
        INFO,
        WARN,
        ERROR,
        FATAL,
        OFF;

    }
}

