/*
 * Decompiled with CFR 0.152.
 */
package com.labstack;

import com.labstack.Client;
import com.labstack.EmailException;
import com.labstack.EmailMessage;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Rfc3339DateJsonAdapter;
import java.io.IOException;
import java.util.Date;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class Email {
    protected OkHttpClient okHttp;
    private Moshi moshi = new Moshi.Builder().add(Date.class, new Rfc3339DateJsonAdapter().nullSafe()).build();
    private JsonAdapter<EmailMessage> messageJsonAdapter = this.moshi.adapter(EmailMessage.class);
    private JsonAdapter<EmailException> exceptionJsonAdapter = this.moshi.adapter(EmailException.class);

    public EmailMessage send(EmailMessage message) throws EmailException {
        try {
            message.addInlines();
            message.addAttachments();
            String json = this.messageJsonAdapter.toJson((Object)message);
            Request request = new Request.Builder().url("https://api.labstack.com/email").post(RequestBody.create((MediaType)Client.MEDIA_TYPE_JSON, (String)json)).build();
            Response response = this.okHttp.newCall(request).execute();
            if (response.isSuccessful()) {
                return (EmailMessage)this.messageJsonAdapter.fromJson(response.body().source());
            }
            throw (EmailException)this.exceptionJsonAdapter.fromJson(response.body().source());
        }
        catch (IOException e) {
            throw new EmailException(0, e.getMessage());
        }
    }
}

