/*
 * Decompiled with CFR 0.152.
 */
package com.labstack;

import com.labstack.MqttException;
import com.labstack.MqttMessageHandler;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class Mqtt {
    private String accountId;
    private MqttMessageHandler handler;
    private IMqttAsyncClient client;

    protected Mqtt(String accountId, String apiKey, String clientId, IMqttAsyncClient client) throws org.eclipse.paho.client.mqttv3.MqttException {
        this.accountId = accountId;
        this.client = client;
        MqttConnectOptions options = new MqttConnectOptions();
        options.setAutomaticReconnect(true);
        options.setCleanSession(true);
        options.setUserName(accountId);
        options.setPassword(apiKey.toCharArray());
        client.setCallback((MqttCallback)new MqttCallbackExtended(){

            public void connectionLost(Throwable cause) {
            }

            public void messageArrived(String topic, MqttMessage message) throws Exception {
                topic = topic.replace(Mqtt.this.accountId + "/", "");
                Mqtt.this.handler.handle(topic, message.getPayload());
            }

            public void deliveryComplete(IMqttDeliveryToken token) {
            }

            public void connectComplete(boolean reconnect, String serverURI) {
            }
        });
        IMqttToken token = client.connect(options);
        token.waitForCompletion();
    }

    public void publish(String topic, byte[] payload) throws MqttException {
        try {
            topic = String.format("%s/%s", this.accountId, topic);
            if (this.client.isConnected()) {
                this.client.publish(topic, new MqttMessage(payload));
            }
        }
        catch (org.eclipse.paho.client.mqttv3.MqttException e) {
            throw new MqttException(e.getReasonCode(), e.getMessage());
        }
    }

    public void subscribe(String topic) {
        topic = String.format("%s/%s", this.accountId, topic);
        try {
            this.client.subscribe(topic, 0);
        }
        catch (org.eclipse.paho.client.mqttv3.MqttException e) {
            throw new MqttException(e.getReasonCode(), e.getMessage());
        }
    }

    public void onMessage(MqttMessageHandler handler) {
        this.handler = handler;
    }

    public void disconnect() throws MqttException {
        try {
            this.client.disconnect();
        }
        catch (org.eclipse.paho.client.mqttv3.MqttException e) {
            throw new MqttException(e.getReasonCode(), e.getMessage());
        }
    }
}

