/*
 * Decompiled with CFR 0.152.
 */
package com.lib16.java.arrays;

import java.util.Random;

public final class Arrays2D {
    private Arrays2D() {
    }

    public static <T> void swap(T[][] array, int x1, int y1, int x2, int y2) {
        T object = array[y1][x1];
        array[y1][x1] = array[y2][x2];
        array[y2][x2] = object;
    }

    public static <T> void reverseX(T[][] array) {
        Arrays2D.reverseX(array, 0, 0, array[0].length, array.length);
    }

    public static <T> void reverseX(T[][] array, int startX, int startY, int stopX, int stopY) {
        int last = stopX - 1;
        int stop = (stopX - startX) / 2 + startX;
        int y = startY;
        while (y < stopY) {
            int x1 = startX;
            int x2 = last;
            while (x1 < stop) {
                Arrays2D.swap(array, x1, y, x2, y);
                ++x1;
                --x2;
            }
            ++y;
        }
    }

    public static <T> void reverseY(T[][] array) {
        Arrays2D.reverseY(array, 0, 0, array[0].length, array.length);
    }

    public static <T> void reverseY(T[][] array, int startX, int startY, int stopX, int stopY) {
        int last = stopY - 1;
        int stop = (stopY - startY) / 2 + startY;
        int x = startX;
        while (x < stopX) {
            int y1 = startY;
            int y2 = last;
            while (y1 < stop) {
                Arrays2D.swap(array, x, y1, x, y2);
                ++y1;
                --y2;
            }
            ++x;
        }
    }

    public static <T> void rotateX(T[][] array, int distance) {
        Arrays2D.rotateX(array, distance, 0, 0, array[0].length, array.length);
    }

    public static <T> void rotateX(T[][] array, int distance, int startX, int startY, int stopX, int stopY) {
        boolean rotateLeft = distance > 0;
        distance = Math.abs(distance) % (stopX - startX);
        int x = rotateLeft ? startX + distance : stopX - distance;
        Arrays2D.reverseX(array, startX, startY, x, stopY);
        Arrays2D.reverseX(array, x, startY, stopX, stopY);
        Arrays2D.reverseX(array, startX, startY, stopX, stopY);
    }

    public static <T> void rotateY(T[][] array, int distance) {
        Arrays2D.rotateY(array, distance, 0, 0, array[0].length, array.length);
    }

    public static <T> void rotateY(T[][] array, int distance, int startX, int startY, int stopX, int stopY) {
        boolean rotateUp = distance > 0;
        distance = Math.abs(distance) % (stopY - startY);
        int y = rotateUp ? startY + distance : stopY - distance;
        Arrays2D.reverseY(array, startX, startY, stopY, y);
        Arrays2D.reverseY(array, startX, y, stopX, stopY);
        Arrays2D.reverseY(array, startX, startY, stopX, stopY);
    }

    public static <T> void shuffle(T[][] array, Random random) {
        Arrays2D.shuffle(array, random, 0, array[0].length, 0, array.length);
    }

    public static <T> void shuffle(T[][] array, Random random, int startX, int startY, int stopX, int stopY) {
        int countX = stopX - startX;
        int countY = stopY - startY;
        int y = startY;
        while (y < stopY) {
            int x = startX;
            while (x < stopX) {
                Arrays2D.swap(array, x, y, random.nextInt(countX) + startX, random.nextInt(countY) + startY);
                ++x;
            }
            ++y;
        }
    }

    public static <T> void copy(T[][] src, T[][] dst) {
        Arrays2D.copy(src, dst, 0, 0, src[0].length, src.length);
    }

    public static <T> void copy(T[][] src, T[][] dst, int startX, int startY, int stopX, int stopY) {
        int count = stopX - startX;
        int y = startY;
        while (y < stopY) {
            System.arraycopy(src[y], startX, dst[y], startX, count);
            ++y;
        }
    }
}

