/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.db;

import com.jfinal.kit.Kv;
import com.litongjava.map.SyncWriteMap;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableInput
extends HashMap {
    private static final Map<String, DateTimeFormatter> formaters = new SyncWriteMap<String, DateTimeFormatter>();
    private static final String datePattern = "yyyy-MM-dd";
    private static final int dateLen = "yyyy-MM-dd".length();
    private static final String dateTimeWithoutSecondPattern = "yyyy-MM-dd HH:mm";
    private static final int dateTimeWithoutSecondLen = "yyyy-MM-dd HH:mm".length();
    private static final String dateTimePattern = "yyyy-MM-dd HH:mm:ss";
    private static final long serialVersionUID = -808251639784763326L;
    public static final String pageNo = "page_no";
    public static final String pageSize = "page_size";
    public static final String columns = "columns";
    public static final String jsonFields = "json_fields";
    public static final String orderBy = "order_by";
    public static final String isAsc = "is_asc";
    public static final String groupBy = "group_by";
    public static final String table_name = "table_name";
    public static final String search_key = "search_key";
    private static final ThreadLocal<HashMap<String, SimpleDateFormat>> TL = ThreadLocal.withInitial(() -> new HashMap());

    public static TableInput of(Object key, Object value) {
        return new TableInput().set(key, value);
    }

    public static TableInput by(Object key, Object value) {
        return new TableInput().set(key, value);
    }

    public static TableInput create() {
        return new TableInput();
    }

    public TableInput set(Object key, Object value) {
        super.put(key, value);
        return this;
    }

    public TableInput setIfNotBlank(Object key, String value) {
        if (this.notBlank(value)) {
            this.set(key, value);
        }
        return this;
    }

    public TableInput setIfNotNull(Object key, Object value) {
        if (value != null) {
            this.set(key, value);
        }
        return this;
    }

    public TableInput set(Map map) {
        super.putAll(map);
        return this;
    }

    public TableInput set(Kv kv) {
        super.putAll(kv);
        return this;
    }

    public TableInput set(TableInput kv) {
        super.putAll(kv);
        return this;
    }

    public TableInput delete(Object key) {
        super.remove(key);
        return this;
    }

    public <T> T getAs(Object key) {
        return (T)this.get(key);
    }

    public <T> T getAs(Object key, T defaultValue) {
        Object ret = this.get(key);
        return (T)(ret != null ? ret : defaultValue);
    }

    public String getStr(Object key) {
        Object s = this.get(key);
        return s != null ? s.toString() : null;
    }

    public Integer getInt(Object key) {
        return TableInput.toInt(this.get(key));
    }

    public Long getLong(Object key) {
        return TableInput.toLong(this.get(key));
    }

    public BigDecimal getBigDecimal(Object key) {
        return TableInput.toBigDecimal(this.get(key));
    }

    public Double getDouble(Object key) {
        return TableInput.toDouble(this.get(key));
    }

    public Float getFloat(Object key) {
        return TableInput.toFloat(this.get(key));
    }

    public Number getNumber(Object key) {
        return TableInput.toNumber(this.get(key));
    }

    public Boolean getBoolean(Object key) {
        return TableInput.toBoolean(this.get(key));
    }

    public java.util.Date getDate(Object key) {
        return TableInput.toDate(this.get(key));
    }

    public LocalDateTime getLocalDateTime(Object key) {
        return TableInput.toLocalDateTime(this.get(key));
    }

    public boolean notNull(Object key) {
        return this.get(key) != null;
    }

    public boolean isNull(Object key) {
        return this.get(key) == null;
    }

    public boolean isTrue(Object key) {
        Object value = this.get(key);
        return value != null && TableInput.toBoolean(value) != false;
    }

    public boolean isFalse(Object key) {
        Object value = this.get(key);
        return value != null && TableInput.toBoolean(value) == false;
    }

    @Override
    public boolean equals(Object kv) {
        return kv instanceof Kv && super.equals(kv);
    }

    public TableInput keep(String ... keys) {
        if (keys != null && keys.length > 0) {
            Kv newKv = Kv.create();
            for (String k : keys) {
                if (!this.containsKey(k)) continue;
                newKv.put((Object)k, this.get(k));
            }
            this.clear();
            this.putAll(newKv);
        } else {
            this.clear();
        }
        return this;
    }

    public <K, V> Map<K, V> toMap() {
        return this;
    }

    public TableInput setFrom(String from) {
        this.set(table_name, from);
        return this;
    }

    public String getFrom() {
        return this.getStr(table_name);
    }

    public TableInput from(String from) {
        this.set(table_name, from);
        return this;
    }

    public String from() {
        return this.getStr(table_name);
    }

    public TableInput setColumns(String inputColumns) {
        this.set(columns, inputColumns);
        return this;
    }

    public TableInput columns(String inputColumns) {
        this.set(columns, inputColumns);
        return this;
    }

    public String getColumns() {
        return this.getStr(columns);
    }

    public TableInput setJsonFields(String[] inputJsonFields) {
        this.set(jsonFields, inputJsonFields);
        return this;
    }

    public String[] getJsonFields() {
        return (String[])this.getAs(jsonFields);
    }

    public TableInput setOrderBy(String inputOrderBy) {
        this.set(orderBy, inputOrderBy);
        return this;
    }

    public TableInput orderBy(String inputOrderBy) {
        this.set(orderBy, inputOrderBy);
        return this;
    }

    public String getOrderBy() {
        return this.getStr(orderBy);
    }

    public TableInput setGroupBy(String inputGroupBy) {
        this.set(orderBy, inputGroupBy);
        return this;
    }

    public String getGroupBy() {
        return this.getStr(groupBy);
    }

    public TableInput setPageNo(Integer inputPageNo) {
        return this.set(pageNo, inputPageNo);
    }

    public TableInput pageNo(int inputPageNo) {
        return this.set(pageNo, inputPageNo);
    }

    public Integer getPageNo() {
        return this.getInt(pageNo);
    }

    public TableInput setPageSize(Integer inputPageSize) {
        return this.set(pageSize, inputPageSize);
    }

    public TableInput pageSize(Integer inputPageSize) {
        return this.set(pageSize, inputPageSize);
    }

    public Integer getPageSize() {
        return this.getInt(pageSize);
    }

    public TableInput setAsc(Boolean inputIsAsc) {
        return this.set(isAsc, inputIsAsc);
    }

    public TableInput asc(boolean inputIsAsc) {
        return this.set(isAsc, inputIsAsc);
    }

    public Boolean isAsc() {
        return this.getBoolean(isAsc);
    }

    public TableInput setSearchKey(String input) {
        return this.setIfNotNull(search_key, input);
    }

    public String getSearchKey() {
        return this.getStr(search_key);
    }

    public TableInput searchKey(String input) {
        return this.setIfNotNull(search_key, input);
    }

    public String searchKey() {
        return this.getStr(search_key);
    }

    public TableInput addJsonField(String jsonField) {
        Object object = this.get(jsonFields);
        if (object != null && object instanceof List) {
            List lists = (List)object;
            lists.add(jsonField);
        } else {
            ArrayList<String> list = new ArrayList<String>();
            list.add(jsonField);
            this.put(jsonFields, list);
        }
        return this;
    }

    public TableInput setJsonFieldString(String jsonFieldString) {
        this.put(jsonFields, jsonFieldString);
        return this;
    }

    public TableInput setOp(String field, String value) {
        return this.set(field + "_op", value);
    }

    public static String toStr(Object s) {
        return s != null ? s.toString() : null;
    }

    public static Integer toInt(Object n) {
        if (n instanceof Integer) {
            return (Integer)n;
        }
        if (n instanceof Number) {
            return ((Number)n).intValue();
        }
        return n != null ? Integer.valueOf(Integer.parseInt(n.toString())) : null;
    }

    public static Long toLong(Object n) {
        if (n instanceof Long) {
            return (Long)n;
        }
        if (n instanceof Number) {
            return ((Number)n).longValue();
        }
        return n != null ? Long.valueOf(Long.parseLong(n.toString())) : null;
    }

    public static Double toDouble(Object n) {
        if (n instanceof Double) {
            return (Double)n;
        }
        if (n instanceof Number) {
            return ((Number)n).doubleValue();
        }
        return n != null ? Double.valueOf(Double.parseDouble(n.toString())) : null;
    }

    public static BigDecimal toBigDecimal(Object n) {
        if (n instanceof BigDecimal) {
            return (BigDecimal)n;
        }
        if (n != null) {
            return new BigDecimal(n.toString());
        }
        return null;
    }

    public static Float toFloat(Object n) {
        if (n instanceof Float) {
            return (Float)n;
        }
        if (n instanceof Number) {
            return Float.valueOf(((Number)n).floatValue());
        }
        return n != null ? Float.valueOf(Float.parseFloat(n.toString())) : null;
    }

    public static Short toShort(Object n) {
        if (n instanceof Short) {
            return (Short)n;
        }
        if (n instanceof Number) {
            return ((Number)n).shortValue();
        }
        return n != null ? Short.valueOf(Short.parseShort(n.toString())) : null;
    }

    public static Byte toByte(Object n) {
        if (n instanceof Byte) {
            return (Byte)n;
        }
        if (n instanceof Number) {
            return ((Number)n).byteValue();
        }
        return n != null ? Byte.valueOf(Byte.parseByte(n.toString())) : null;
    }

    public static Boolean toBoolean(Object b) {
        if (b instanceof Boolean) {
            return (Boolean)b;
        }
        if (b == null) {
            return null;
        }
        if (b instanceof Number) {
            if (b instanceof Integer || b instanceof Long || b instanceof BigInteger || b instanceof Byte || b instanceof Short) {
                int n = ((Number)b).intValue();
                if (n == 1) {
                    return Boolean.TRUE;
                }
                if (n == 0) {
                    return Boolean.FALSE;
                }
            }
            return (Boolean)b;
        }
        if (b instanceof String) {
            String s = b.toString();
            if ("true".equalsIgnoreCase(s) || "1".equals(s)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(s) || "0".equals(s)) {
                return Boolean.FALSE;
            }
        }
        return (Boolean)b;
    }

    public static Number toNumber(Object n) {
        if (n instanceof Number) {
            return (Number)n;
        }
        if (n == null) {
            return null;
        }
        String s = n.toString();
        return s.indexOf(46) != -1 ? Double.parseDouble(s) : (double)Long.parseLong(s);
    }

    public static java.util.Date toDate(Object d) {
        if (d instanceof java.util.Date) {
            return (java.util.Date)d;
        }
        if (d instanceof Temporal) {
            if (d instanceof LocalDateTime) {
                return TableInput.toDate((LocalDateTime)d);
            }
            if (d instanceof LocalDate) {
                return TableInput.toDate((LocalDate)d);
            }
            if (d instanceof LocalTime) {
                return TableInput.toDate((LocalTime)d);
            }
        }
        if (d instanceof String) {
            String s = (String)d;
            if (s.length() <= dateLen) {
                return TableInput.parse(s, datePattern);
            }
            if (s.length() > dateTimeWithoutSecondLen) {
                return TableInput.parse(s, dateTimePattern);
            }
            int index = s.indexOf(58);
            if (index != -1) {
                if (index != s.lastIndexOf(58)) {
                    return TableInput.parse(s, dateTimePattern);
                }
                return TableInput.parse(s, dateTimeWithoutSecondPattern);
            }
        }
        return (java.util.Date)d;
    }

    public static LocalDateTime toLocalDateTime(Object ldt) {
        if (ldt instanceof LocalDateTime) {
            return (LocalDateTime)ldt;
        }
        if (ldt instanceof java.util.Date) {
            return TableInput.toLocalDateTime((java.util.Date)ldt);
        }
        if (ldt instanceof LocalDate) {
            return ((LocalDate)ldt).atStartOfDay();
        }
        if (ldt instanceof LocalTime) {
            return LocalDateTime.of(LocalDate.now(), (LocalTime)ldt);
        }
        if (ldt instanceof String) {
            String s = (String)ldt;
            if (s.length() <= dateLen) {
                return TableInput.parseLocalDateTime(s, datePattern);
            }
            if (s.length() > dateTimeWithoutSecondLen) {
                return TableInput.parseLocalDateTime(s, dateTimePattern);
            }
            int index = s.indexOf(58);
            if (index != -1) {
                if (index != s.lastIndexOf(58)) {
                    return TableInput.parseLocalDateTime(s, dateTimePattern);
                }
                return TableInput.parseLocalDateTime(s, dateTimeWithoutSecondPattern);
            }
        }
        return (LocalDateTime)ldt;
    }

    public boolean notBlank(String value) {
        return value != null && value.length() != 0;
    }

    public static DateTimeFormatter getDateTimeFormatter(String pattern) {
        DateTimeFormatter ret = formaters.get(pattern);
        if (ret == null) {
            ret = DateTimeFormatter.ofPattern(pattern);
            formaters.put(pattern, ret);
        }
        return ret;
    }

    public static SimpleDateFormat getSimpleDateFormat(String pattern) {
        SimpleDateFormat ret = TL.get().get(pattern);
        if (ret == null) {
            ret = new SimpleDateFormat(pattern);
            TL.get().put(pattern, ret);
        }
        return ret;
    }

    public static String now(String pattern) {
        return LocalDateTime.now().format(TableInput.getDateTimeFormatter(pattern));
    }

    public static String format(LocalDateTime localDateTime, String pattern) {
        return localDateTime.format(TableInput.getDateTimeFormatter(pattern));
    }

    public static String format(LocalDateTime localDateTime) {
        return TableInput.format(localDateTime, dateTimePattern);
    }

    public static String format(LocalDate localDate, String pattern) {
        return localDate.format(TableInput.getDateTimeFormatter(pattern));
    }

    public static String format(LocalTime localTime, String pattern) {
        return localTime.format(TableInput.getDateTimeFormatter(pattern));
    }

    public static String format(java.util.Date date, String pattern) {
        return TableInput.getSimpleDateFormat(pattern).format(date);
    }

    public static String format(java.util.Date date) {
        return TableInput.format(date, dateTimePattern);
    }

    public static java.util.Date parse(String dateString, String pattern) {
        try {
            return TableInput.getSimpleDateFormat(pattern).parse(dateString);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static LocalDateTime parseLocalDateTime(String localDateTimeString, String pattern) {
        return LocalDateTime.parse(localDateTimeString, TableInput.getDateTimeFormatter(pattern));
    }

    public static LocalDate parseLocalDate(String localDateString, String pattern) {
        return LocalDate.parse(localDateString, TableInput.getDateTimeFormatter(pattern));
    }

    public static LocalTime parseLocalTime(String localTimeString, String pattern) {
        return LocalTime.parse(localTimeString, TableInput.getDateTimeFormatter(pattern));
    }

    public static boolean isAfter(ChronoLocalDateTime<?> self, ChronoLocalDateTime<?> other) {
        return self.isAfter(other);
    }

    public static boolean isBefore(ChronoLocalDateTime<?> self, ChronoLocalDateTime<?> other) {
        return self.isBefore(other);
    }

    public static boolean isEqual(ChronoLocalDateTime<?> self, ChronoLocalDateTime<?> other) {
        return self.isEqual(other);
    }

    public static LocalDateTime toLocalDateTime(java.util.Date date) {
        if (date instanceof Date) {
            date = new java.util.Date(date.getTime());
        }
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        return LocalDateTime.ofInstant(instant, zone);
    }

    public static LocalDate toLocalDate(java.util.Date date) {
        if (date instanceof Date) {
            date = new java.util.Date(date.getTime());
        }
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
        return localDateTime.toLocalDate();
    }

    public static LocalTime toLocalTime(java.util.Date date) {
        if (date instanceof Date) {
            date = new java.util.Date(date.getTime());
        }
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
        return localDateTime.toLocalTime();
    }

    public static java.util.Date toDate(LocalDateTime localDateTime) {
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDateTime.atZone(zone).toInstant();
        return java.util.Date.from(instant);
    }

    public static java.util.Date toDate(LocalDate localDate) {
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDate.atStartOfDay().atZone(zone).toInstant();
        return java.util.Date.from(instant);
    }

    public static java.util.Date toDate(LocalTime localTime) {
        LocalDate localDate = LocalDate.now();
        LocalDateTime localDateTime = LocalDateTime.of(localDate, localTime);
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDateTime.atZone(zone).toInstant();
        return java.util.Date.from(instant);
    }

    public static java.util.Date toDate(LocalDate localDate, LocalTime localTime) {
        LocalDateTime localDateTime = LocalDateTime.of(localDate, localTime);
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDateTime.atZone(zone).toInstant();
        return java.util.Date.from(instant);
    }
}

