/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.db;

import java.io.Serializable;

public class TableResult<T>
implements Serializable {
    private static final long serialVersionUID = 3937468350139608391L;
    private int code = 1;
    private String msg;
    private T data;

    public TableResult(T data) {
        this.data = data;
    }

    public TableResult(int code) {
        this.code = code;
    }

    public TableResult(String msg) {
        this.msg = msg;
    }

    public TableResult(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public static <T> TableResult<T> fail() {
        return new TableResult<T>(-1, "fail");
    }

    public static <T> TableResult<T> fail(int code) {
        return new TableResult<T>(code, "fail");
    }

    public static <T> TableResult<T> fail(String message) {
        return new TableResult<T>(-1, message);
    }

    public static <T> TableResult<T> fail(T data) {
        return new TableResult<T>(-1, "fail", data);
    }

    public static <T> TableResult<T> fail(int code, String msg) {
        return new TableResult<T>(code, msg);
    }

    public static <T> TableResult<T> ok() {
        return new TableResult<T>();
    }

    public static <T> TableResult<T> ok(T kv) {
        return new TableResult<T>(kv);
    }

    public boolean isOk() {
        return this.code == 1;
    }

    public TableResult() {
    }

    public TableResult(int code, String msg, T data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }
}

