/*
 * Decompiled with CFR 0.152.
 */
package com.loadcoder.statics;

import com.loadcoder.result.Logs;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogbackLogging
extends Logs {
    private static DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd_HHmmss");

    public static void setDateTimeFormatter(DateTimeFormatter dateTimeFormatter) {
        format = dateTimeFormatter;
    }

    public static void setResultDirectory(String sharedDirForLogsPath) {
        LogbackLogging.setResultDestination(new File(sharedDirForLogsPath));
    }

    public static void setResultDestination(File sharedDirForLogs) {
        Logger initiateLogging = LoggerFactory.getLogger(LogbackLogging.class);
        try {
            Logs.changeToSharedDir((File)sharedDirForLogs);
            initiateLogging.info("New Result destination:{}", (Object)sharedDirForLogs.getAbsolutePath());
        }
        catch (IOException ioe) {
            throw new RuntimeException(String.format("Could not use the file %s in dir as a result destination", sharedDirForLogs), ioe);
        }
    }

    public static File getNewLogDir(String rootDirPathForAllLogs, String nameOfTheTest) {
        return LogbackLogging.getNewLogDir(rootDirPathForAllLogs + "/" + nameOfTheTest);
    }

    public static File getNewLogDir(String dirForAllLogs) {
        LocalDateTime timePoint = LocalDateTime.now();
        String dateTime = timePoint.format(format);
        File logDir = new File(dirForAllLogs + "/" + dateTime);
        int uniqueIterator = 2;
        while (logDir.exists()) {
            logDir = new File(dirForAllLogs + "/" + dateTime + "_" + uniqueIterator);
            ++uniqueIterator;
        }
        return logDir;
    }
}

