/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.api.staticimage.v1;

import com.mapbox.services.Constants;
import com.mapbox.services.api.MapboxBuilder;
import com.mapbox.services.api.ServicesException;
import com.mapbox.services.api.staticimage.v1.models.StaticMarkerAnnotation;
import com.mapbox.services.api.staticimage.v1.models.StaticPolylineAnnotation;
import com.mapbox.services.commons.geojson.GeoJSON;
import com.mapbox.services.commons.models.Position;
import com.mapbox.services.commons.utils.TextUtils;
import java.util.ArrayList;
import java.util.Locale;
import okhttp3.HttpUrl;

public class MapboxStaticImage {
    private HttpUrl url;

    public MapboxStaticImage(Builder builder) {
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)builder.getBaseUrl()).newBuilder().addPathSegment("styles").addPathSegment("v1").addPathSegment(builder.getUsername()).addPathSegment(builder.getStyleId()).addPathSegment("static").addQueryParameter("access_token", builder.getAccessToken());
        if (builder.getOverlays() != null) {
            urlBuilder.addEncodedPathSegment(builder.getOverlays());
        }
        if (builder.isAuto()) {
            urlBuilder.addPathSegment("auto");
        } else {
            urlBuilder.addPathSegment(builder.getLocationPathSegment());
        }
        urlBuilder.addPathSegment(builder.getSizePathSegment());
        if (builder.beforeLayer != null) {
            urlBuilder.addQueryParameter("before_layer", builder.beforeLayer);
        }
        if (!builder.isAttribution()) {
            urlBuilder.addQueryParameter("attribution", "false");
        }
        if (!builder.isLogo()) {
            urlBuilder.addQueryParameter("logo", "false");
        }
        this.url = urlBuilder.build();
    }

    public HttpUrl getUrl() {
        return this.url;
    }

    public static class Builder
    extends MapboxBuilder {
        private String accessToken;
        private String username = "mapbox";
        private String styleId;
        private Double lon;
        private Double lat;
        private Double zoom;
        private double bearing = 0.0;
        private double pitch = 0.0;
        private boolean auto;
        private String beforeLayer;
        private Integer width;
        private Integer height;
        private boolean retina = false;
        private boolean attribution = true;
        private boolean logo = true;
        private StaticMarkerAnnotation[] staticMarkerAnnotations;
        private StaticPolylineAnnotation[] staticPolylineAnnotations;
        private String geoJson;
        private int precision = -1;

        public String getGeoJson() {
            return this.geoJson;
        }

        public Builder setGeoJson(GeoJSON geoJson) {
            this.geoJson = String.format(Constants.DEFAULT_LOCALE, "geojson(%s)", geoJson.toJson());
            return this;
        }

        @Override
        public Builder setAccessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public Builder setUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder setStyleId(String styleId) {
            this.styleId = styleId;
            return this;
        }

        public Builder setLon(double lon) {
            this.lon = lon;
            return this;
        }

        public Builder setLat(double lat) {
            this.lat = lat;
            return this;
        }

        @Deprecated
        public Builder setLocation(Position position) {
            this.lat = position.getLatitude();
            this.lon = position.getLongitude();
            return this;
        }

        public Builder setPosition(Position position) {
            this.lat = position.getLatitude();
            this.lon = position.getLongitude();
            return this;
        }

        public Builder setZoom(double zoom) {
            this.zoom = zoom;
            return this;
        }

        public Builder setBearing(double bearing) {
            this.bearing = bearing;
            return this;
        }

        public Builder setPitch(double pitch) {
            this.pitch = pitch;
            return this;
        }

        public Builder setAuto(boolean auto) {
            this.auto = auto;
            return this;
        }

        public boolean isAuto() {
            return this.auto;
        }

        public Builder setWidth(int width) {
            this.width = width;
            return this;
        }

        public Builder setHeight(int height) {
            this.height = height;
            return this;
        }

        public Builder setRetina(boolean retina) {
            this.retina = retina;
            return this;
        }

        public Builder setAttribution(boolean attribution) {
            this.attribution = attribution;
            return this;
        }

        public Builder setLogo(boolean logo) {
            this.logo = logo;
            return this;
        }

        public Builder setPrecision(int precision) {
            this.precision = precision;
            return this;
        }

        public Builder setBeforeLayer(String beforeLayer) {
            this.beforeLayer = beforeLayer;
            return this;
        }

        public String getBeforeLayer() {
            return this.beforeLayer;
        }

        @Override
        public String getAccessToken() {
            return this.accessToken;
        }

        public String getUsername() {
            return this.username;
        }

        public String getStyleId() {
            return this.styleId;
        }

        public String getLocationPathSegment() {
            if (this.precision > 0) {
                return String.format(Locale.US, "%s,%s,%s,%s,%s", TextUtils.formatCoordinate((double)this.lon, (int)this.precision), TextUtils.formatCoordinate((double)this.lat, (int)this.precision), TextUtils.formatCoordinate((double)this.zoom, (int)this.precision), TextUtils.formatCoordinate((double)this.bearing, (int)this.precision), TextUtils.formatCoordinate((double)this.pitch, (int)this.precision));
            }
            return String.format(Locale.US, "%f,%f,%f,%f,%f", this.lon, this.lat, this.zoom, this.bearing, this.pitch);
        }

        public String getSizePathSegment() {
            String retinaPath = this.retina ? "@2x" : "";
            return String.format(Locale.US, "%dx%d%s", this.width, this.height, retinaPath);
        }

        public Builder setStaticMarkerAnnotations(StaticMarkerAnnotation ... staticMarkerAnnotations) {
            this.staticMarkerAnnotations = staticMarkerAnnotations;
            return this;
        }

        public Builder setStaticPolylineAnnotations(StaticPolylineAnnotation ... staticPolylineAnnotations) {
            this.staticPolylineAnnotations = staticPolylineAnnotations;
            return this;
        }

        public String getOverlays() {
            ArrayList<String> formattedOverlays = new ArrayList<String>();
            if (this.staticMarkerAnnotations != null) {
                for (StaticMarkerAnnotation staticMarkerAnnotation : this.staticMarkerAnnotations) {
                    formattedOverlays.add(staticMarkerAnnotation.getMarker());
                }
            }
            if (this.staticPolylineAnnotations != null) {
                for (StaticPolylineAnnotation staticPolylineAnnotation : this.staticPolylineAnnotations) {
                    formattedOverlays.add(staticPolylineAnnotation.getPath());
                }
            }
            if (this.geoJson != null) {
                formattedOverlays.add(this.geoJson);
            }
            return TextUtils.join((CharSequence)",", (Object[])formattedOverlays.toArray());
        }

        public boolean isAttribution() {
            return this.attribution;
        }

        public boolean isLogo() {
            return this.logo;
        }

        public int getPrecision() {
            return this.precision;
        }

        public Builder setClientAppName(String appName) {
            this.clientAppName = appName;
            return this;
        }

        public MapboxBuilder setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        @Override
        public MapboxStaticImage build() throws ServicesException {
            this.validateAccessToken(this.accessToken);
            if (this.styleId == null || this.styleId.isEmpty()) {
                throw new ServicesException("You need to set a map style.");
            }
            if (!(this.lon != null && this.lat != null || this.auto)) {
                throw new ServicesException("You need to set the map lon/lat coordinates or set auto to true.");
            }
            if (this.zoom != null && (this.zoom < 0.0 || this.zoom > 20.0)) {
                throw new ServicesException("The zoom level provided must be a value between 0 and 20.");
            }
            if (this.width == null || this.width < 1 || this.width > 1280) {
                throw new ServicesException("You need to set a valid image width (between 1 and 1280).");
            }
            if (this.height == null || this.height < 1 || this.height > 1280) {
                throw new ServicesException("You need to set a valid image height (between 1 and 1280).");
            }
            return new MapboxStaticImage(this);
        }
    }
}

