/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.api.staticimage.v1.models;

import com.mapbox.services.Constants;
import com.mapbox.services.api.ServicesException;
import com.mapbox.services.commons.models.Position;
import com.mapbox.services.commons.utils.TextUtils;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StaticMarkerAnnotation {
    private String marker;

    public StaticMarkerAnnotation(Builder builder) {
        if (builder.getPrecision() > 0) {
            String pattern = "0." + new String(new char[builder.getPrecision()]).replace("\u0000", "0");
            DecimalFormat df = (DecimalFormat)DecimalFormat.getInstance(Locale.US);
            df.applyPattern(pattern);
            df.setRoundingMode(RoundingMode.FLOOR);
            this.marker = builder.getUrl() != null ? String.format(Constants.DEFAULT_LOCALE, "url-%s(%s,%s)", builder.getUrl(), TextUtils.formatCoordinate((double)builder.getLon(), (int)builder.getPrecision()), TextUtils.formatCoordinate((double)builder.getLat(), (int)builder.getPrecision())) : String.format(Constants.DEFAULT_LOCALE, "%s%s%s(%s,%s)", builder.getName(), builder.getLabel(), builder.getColor(), TextUtils.formatCoordinate((double)builder.getLon(), (int)builder.getPrecision()), TextUtils.formatCoordinate((double)builder.getLat(), (int)builder.getPrecision()));
        } else {
            this.marker = builder.getUrl() != null ? String.format(Constants.DEFAULT_LOCALE, "url-%s(%s,%s)", builder.getUrl(), builder.getLon(), builder.getLat()) : String.format(Constants.DEFAULT_LOCALE, "%s%s%s(%f,%f)", builder.getName(), builder.getLabel(), builder.getColor(), builder.getLon(), builder.getLat());
        }
    }

    public String getMarker() {
        return this.marker;
    }

    public static class Builder {
        private static final String EMPTY = "";
        private static final String HYPHEN_CHAR = "-";
        private static final String PLUS_CHAR = "+";
        private static final String NUMERIC_FROM_ZERO_TO_NINETYNINE_REGEX = "^(0|[1-9][0-9]{0,1})$";
        private static final String ONE_ALPHABET_LETTER_REGEX = "^([a-zA-Z])$";
        private String name;
        private String label = "";
        private String color = "";
        private Double lat;
        private Double lon;
        private String url;
        private int precision = -1;

        public String getUrl() {
            return this.url;
        }

        public Builder setUrl(String url) {
            this.url = url;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public String getLabel() {
            if (this.label.isEmpty()) {
                return EMPTY;
            }
            return HYPHEN_CHAR.concat(this.label).toLowerCase();
        }

        public Builder setLabel(String label) {
            this.label = label;
            return this;
        }

        public String getColor() {
            if (this.color.isEmpty()) {
                return EMPTY;
            }
            return PLUS_CHAR.concat(this.color);
        }

        public Builder setColor(String color) {
            this.color = color;
            return this;
        }

        public Position getPosition() {
            return Position.fromCoordinates((double)this.lon, (double)this.lat);
        }

        public Builder setPosition(Position position) {
            this.lat = position.getLatitude();
            this.lon = position.getLongitude();
            return this;
        }

        public Double getLat() {
            return this.lat;
        }

        public Builder setLat(Double lat) {
            this.lat = lat;
            return this;
        }

        public Double getLon() {
            return this.lon;
        }

        public Builder setLon(Double lon) {
            this.lon = lon;
            return this;
        }

        public Builder setPrecision(int precision) {
            this.precision = precision;
            return this;
        }

        public int getPrecision() {
            return this.precision;
        }

        public StaticMarkerAnnotation build() throws ServicesException {
            String hexPattern;
            Pattern pattern;
            Matcher matcher;
            if (this.url == null && (this.name == null || this.name.isEmpty() || !this.name.equals("pin-s") && !this.name.equals("pin-m") && !this.name.equals("pin-l"))) {
                throw new ServicesException("You need to set a marker name using one of the three Mapbox Service Constant names.");
            }
            if (this.lat == null || this.lon == null) {
                throw new ServicesException("You need to give the marker either lon/lat coordinates or a Position object.");
            }
            if (!this.color.isEmpty() && !(matcher = (pattern = Pattern.compile(hexPattern = "^([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$")).matcher(this.color)).matches()) {
                throw new ServicesException("You need to pass 3- or 6-digit hexadecimal color code.");
            }
            if (!this.label.isEmpty()) {
                boolean isANumber = true;
                try {
                    Integer.parseInt(this.label);
                }
                catch (NumberFormatException notANumber) {
                    isANumber = false;
                }
                if (isANumber) {
                    pattern = Pattern.compile(NUMERIC_FROM_ZERO_TO_NINETYNINE_REGEX);
                    matcher = pattern.matcher(this.label);
                    if (!matcher.matches()) {
                        throw new ServicesException("You need to pass an alphanumeric label [0-99] code.");
                    }
                } else if (this.label.length() < 3 && !(matcher = (pattern = Pattern.compile(ONE_ALPHABET_LETTER_REGEX)).matcher(this.label)).matches()) {
                    throw new ServicesException("You need to pass an alphanumeric label [a-zA-Z] code.");
                }
            }
            return new StaticMarkerAnnotation(this);
        }
    }
}

