/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.api.staticimage.v1.models;

import com.mapbox.services.api.ServicesException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StaticPolylineAnnotation {
    private String path;

    public StaticPolylineAnnotation(Builder builder) {
        StringBuilder sb = new StringBuilder();
        sb.append("path");
        if (builder.getStrokeWidth() != null) {
            sb.append("-").append(builder.getStrokeWidth());
        }
        if (builder.getStrokeColor() != null) {
            sb.append("+").append(builder.getStrokeColor());
        }
        if (builder.getStrokeOpacity() != null) {
            sb.append("-").append(builder.getStrokeOpacity());
        }
        if (builder.getFillColor() != null) {
            sb.append("+").append(builder.getFillColor());
        }
        if (builder.getFillOpacity() != null) {
            sb.append("-").append(builder.getFillOpacity());
        }
        sb.append("(").append(builder.getPolyline()).append(")");
        this.path = sb.toString();
    }

    public String getPath() {
        return this.path;
    }

    public static class Builder {
        private Double strokeWidth;
        private String strokeColor;
        private Float strokeOpacity;
        private String fillColor;
        private Float fillOpacity;
        private String polyline;

        public Double getStrokeWidth() {
            return this.strokeWidth;
        }

        public Builder setStrokeWidth(double strokeWidth) {
            this.strokeWidth = strokeWidth;
            return this;
        }

        public String getStrokeColor() {
            return this.strokeColor;
        }

        public Builder setStrokeColor(String strokeColor) {
            this.strokeColor = strokeColor;
            return this;
        }

        public Float getStrokeOpacity() {
            return this.strokeOpacity;
        }

        public Builder setStrokeOpacity(float strokeOpacity) {
            this.strokeOpacity = Float.valueOf(strokeOpacity);
            return this;
        }

        public String getFillColor() {
            return this.fillColor;
        }

        public Builder setFillColor(String fillColor) {
            this.fillColor = fillColor;
            return this;
        }

        public Float getFillOpacity() {
            return this.fillOpacity;
        }

        public Builder setFillOpacity(float fillOpacity) {
            this.fillOpacity = Float.valueOf(fillOpacity);
            return this;
        }

        public String getPolyline() {
            return this.polyline;
        }

        public Builder setPolyline(String polyline) {
            this.polyline = polyline;
            return this;
        }

        public StaticPolylineAnnotation build() throws ServicesException {
            String hexPattern;
            Pattern pattern;
            Matcher matcher;
            if (this.polyline == null) {
                throw new ServicesException("Creating a path overlay requires a valid polyline string.");
            }
            if (this.strokeWidth != null && this.strokeWidth < 0.0) {
                throw new ServicesException("The stroke width must be a positive number.");
            }
            if (this.strokeOpacity != null && (this.strokeOpacity.floatValue() < 0.0f || this.strokeOpacity.floatValue() > 1.0f)) {
                throw new ServicesException("Stroke opacity can only be a float value between 0 and 1.");
            }
            if (this.fillOpacity != null && (this.fillOpacity.floatValue() < 0.0f || this.fillOpacity.floatValue() > 1.0f)) {
                throw new ServicesException("Fill opacity can only be a float value between 0 and 1.");
            }
            if (this.strokeColor != null && !(matcher = (pattern = Pattern.compile(hexPattern = "^([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$")).matcher(this.strokeColor)).matches()) {
                throw new ServicesException("You need to pass 3- or 6-digit hexadecimal color code.");
            }
            if (this.fillColor != null && !(matcher = (pattern = Pattern.compile(hexPattern = "^([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$")).matcher(this.fillColor)).matches()) {
                throw new ServicesException("You need to pass 3- or 6-digit hexadecimal color code.");
            }
            return new StaticPolylineAnnotation(this);
        }
    }
}

