/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.api.utils.turf;

import com.mapbox.services.api.utils.turf.TurfException;
import com.mapbox.services.api.utils.turf.TurfInvariant;
import com.mapbox.services.commons.geojson.MultiPolygon;
import com.mapbox.services.commons.geojson.Point;
import com.mapbox.services.commons.geojson.Polygon;
import com.mapbox.services.commons.models.Position;
import java.util.ArrayList;
import java.util.List;

public class TurfJoins {
    public static boolean inside(Position point, List<Position> polygon) throws TurfException {
        ArrayList<List<Position>> polygons = new ArrayList<List<Position>>();
        polygons.add(polygon);
        return TurfJoins.inside(Point.fromCoordinates((Position)point), Polygon.fromCoordinates(polygons));
    }

    public static boolean inside(Point point, Polygon polygon) throws TurfException {
        List coordinates = polygon.getCoordinates();
        ArrayList<List> multiCoordinates = new ArrayList<List>();
        multiCoordinates.add(coordinates);
        return TurfJoins.inside(point, MultiPolygon.fromCoordinates(multiCoordinates));
    }

    public static boolean inside(Point point, MultiPolygon polygon) throws TurfException {
        Position pt = TurfInvariant.getCoord(point);
        List polys = polygon.getCoordinates();
        boolean insidePoly = false;
        for (int i = 0; i < polys.size() && !insidePoly; ++i) {
            if (!TurfJoins.inRing(pt, (List)((List)polys.get(i)).get(0))) continue;
            boolean inHole = false;
            for (int k = 1; k < ((List)polys.get(i)).size() && !inHole; ++k) {
                if (!TurfJoins.inRing(pt, (List)((List)polys.get(i)).get(k))) continue;
                inHole = true;
            }
            if (inHole) continue;
            insidePoly = true;
        }
        return insidePoly;
    }

    private static boolean inRing(Position pt, List<Position> ring) {
        boolean isInside = false;
        int i = 0;
        int j = ring.size() - 1;
        while (i < ring.size()) {
            boolean intersect;
            double xi = ring.get(i).getLongitude();
            double yi = ring.get(i).getLatitude();
            double xj = ring.get(j).getLongitude();
            double yj = ring.get(j).getLatitude();
            boolean bl = intersect = yi > pt.getLatitude() != yj > pt.getLatitude() && pt.getLongitude() < (xj - xi) * (pt.getLatitude() - yi) / (yj - yi) + xi;
            if (intersect) {
                isInside = !isInside;
            }
            j = i++;
        }
        return isInside;
    }
}

