/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.api.utils.turf;

import com.mapbox.services.api.utils.turf.TurfException;
import com.mapbox.services.api.utils.turf.TurfMeasurement;
import com.mapbox.services.api.utils.turf.models.LineIntersectsResult;
import com.mapbox.services.commons.geojson.Feature;
import com.mapbox.services.commons.geojson.Geometry;
import com.mapbox.services.commons.geojson.LineString;
import com.mapbox.services.commons.geojson.Point;
import com.mapbox.services.commons.models.Position;
import java.util.ArrayList;
import java.util.List;

public class TurfMisc {
    public static LineString lineSlice(Point startPt, Point stopPt, Feature line) throws TurfException {
        if (!line.getGeometry().getType().equals("LineString")) {
            throw new TurfException("input must be a LineString Feature or Geometry");
        }
        return TurfMisc.lineSlice(startPt, stopPt, (LineString)line.getGeometry());
    }

    public static LineString lineSlice(Point startPt, Point stopPt, LineString line) throws TurfException {
        List coords = line.getCoordinates();
        if (coords.size() < 2) {
            throw new TurfException("Turf lineSlice requires a LineString made up of at least 2 coordinates.");
        }
        if (startPt.equals((Object)stopPt)) {
            throw new TurfException("Start and stop points in Turf lineSlice cannot equal each other.");
        }
        Feature startVertex = TurfMisc.pointOnLine(startPt, coords);
        Feature stopVertex = TurfMisc.pointOnLine(stopPt, coords);
        ArrayList<Feature> ends = new ArrayList<Feature>();
        if ((Integer)startVertex.getNumberProperty("index") <= (Integer)stopVertex.getNumberProperty("index")) {
            ends.add(startVertex);
            ends.add(stopVertex);
        } else {
            ends.add(stopVertex);
            ends.add(startVertex);
        }
        ArrayList<Position> positions = new ArrayList<Position>();
        positions.add(((Point)((Feature)ends.get(0)).getGeometry()).getCoordinates());
        LineString clipLine = LineString.fromCoordinates(positions);
        for (int i = (Integer)((Feature)ends.get(0)).getNumberProperty("index") + 1; i < (Integer)((Feature)ends.get(1)).getNumberProperty("index") + 1; ++i) {
            List coordinates = clipLine.getCoordinates();
            coordinates.add(coords.get(i));
            clipLine.setCoordinates(coordinates);
        }
        List coordinates = clipLine.getCoordinates();
        coordinates.add(((Point)((Feature)ends.get(1)).getGeometry()).getCoordinates());
        clipLine.setCoordinates(coordinates);
        return clipLine;
    }

    public static Feature pointOnLine(Point pt, List<Position> coords) throws TurfException {
        String units = "miles";
        Feature closestPt = Feature.fromGeometry((Geometry)Point.fromCoordinates((Position)Position.fromCoordinates((double)Double.POSITIVE_INFINITY, (double)Double.POSITIVE_INFINITY)));
        closestPt.addNumberProperty("dist", (Number)Double.POSITIVE_INFINITY);
        for (int i = 0; i < coords.size() - 1; ++i) {
            Feature start = Feature.fromGeometry((Geometry)Point.fromCoordinates((Position)coords.get(i)));
            Feature stop = Feature.fromGeometry((Geometry)Point.fromCoordinates((Position)coords.get(i + 1)));
            start.addNumberProperty("dist", (Number)TurfMeasurement.distance(pt, (Point)start.getGeometry(), units));
            stop.addNumberProperty("dist", (Number)TurfMeasurement.distance(pt, (Point)stop.getGeometry(), units));
            double heightDistance = Math.max(start.getProperties().get("dist").getAsDouble(), stop.getProperties().get("dist").getAsDouble());
            double direction = TurfMeasurement.bearing((Point)start.getGeometry(), (Point)stop.getGeometry());
            Feature perpendicularPt1 = Feature.fromGeometry((Geometry)TurfMeasurement.destination(pt, heightDistance, direction + 90.0, units));
            Feature perpendicularPt2 = Feature.fromGeometry((Geometry)TurfMeasurement.destination(pt, heightDistance, direction - 90.0, units));
            LineIntersectsResult intersect = TurfMisc.lineIntersects(((Point)perpendicularPt1.getGeometry()).getCoordinates().getLongitude(), ((Point)perpendicularPt1.getGeometry()).getCoordinates().getLatitude(), ((Point)perpendicularPt2.getGeometry()).getCoordinates().getLongitude(), ((Point)perpendicularPt2.getGeometry()).getCoordinates().getLatitude(), ((Point)start.getGeometry()).getCoordinates().getLongitude(), ((Point)start.getGeometry()).getCoordinates().getLatitude(), ((Point)stop.getGeometry()).getCoordinates().getLongitude(), ((Point)stop.getGeometry()).getCoordinates().getLatitude());
            Feature intersectPt = null;
            if (intersect != null) {
                intersectPt = Feature.fromGeometry((Geometry)Point.fromCoordinates((Position)Position.fromCoordinates((double)intersect.getX(), (double)intersect.getY())));
                intersectPt.addNumberProperty("dist", (Number)TurfMeasurement.distance(pt, (Point)intersectPt.getGeometry(), units));
            }
            if ((Double)start.getNumberProperty("dist") < (Double)closestPt.getNumberProperty("dist")) {
                closestPt = start;
                closestPt.addNumberProperty("index", (Number)i);
            }
            if ((Double)stop.getNumberProperty("dist") < (Double)closestPt.getNumberProperty("dist")) {
                closestPt = stop;
                closestPt.addNumberProperty("index", (Number)i);
            }
            if (intersectPt == null || !((Double)intersectPt.getNumberProperty("dist") < (Double)closestPt.getNumberProperty("dist"))) continue;
            closestPt = intersectPt;
            closestPt.addNumberProperty("index", (Number)i);
        }
        return closestPt;
    }

    private static LineIntersectsResult lineIntersects(double line1StartX, double line1StartY, double line1EndX, double line1EndY, double line2StartX, double line2StartY, double line2EndX, double line2EndY) {
        LineIntersectsResult result = new LineIntersectsResult();
        double denominator = (line2EndY - line2StartY) * (line1EndX - line1StartX) - (line2EndX - line2StartX) * (line1EndY - line1StartY);
        if (denominator == 0.0) {
            if (result.getX() != null && result.getY() != null) {
                return result;
            }
            return null;
        }
        double a = line1StartY - line2StartY;
        double b = line1StartX - line2StartX;
        double numerator1 = (line2EndX - line2StartX) * a - (line2EndY - line2StartY) * b;
        double numerator2 = (line1EndX - line1StartX) * a - (line1EndY - line1StartY) * b;
        a = numerator1 / denominator;
        b = numerator2 / denominator;
        result.setX(line1StartX + a * (line1EndX - line1StartX));
        result.setY(line1StartY + a * (line1EndY - line1StartY));
        if (a > 0.0 && a < 1.0) {
            result.setOnLine1(true);
        }
        if (b > 0.0 && b < 1.0) {
            result.setOnLine2(true);
        }
        if (result.isOnLine1() && result.isOnLine2()) {
            return result;
        }
        return null;
    }
}

