/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.document;

import com.marklogic.client.FailedRequestException;
import com.marklogic.client.ForbiddenUserException;
import com.marklogic.client.ResourceNotFoundException;
import com.marklogic.client.Transaction;
import com.marklogic.client.document.DocumentDescriptor;
import com.marklogic.client.document.DocumentMetadataPatchBuilder;
import com.marklogic.client.document.DocumentUriTemplate;
import com.marklogic.client.document.ServerTransform;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.marker.AbstractReadHandle;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import com.marklogic.client.io.marker.DocumentMetadataReadHandle;
import com.marklogic.client.io.marker.DocumentMetadataWriteHandle;
import com.marklogic.client.io.marker.DocumentPatchHandle;
import com.marklogic.client.util.RequestLogger;
import java.util.Set;

public interface DocumentManager<R extends AbstractReadHandle, W extends AbstractWriteHandle> {
    public DocumentDescriptor newDescriptor(String var1);

    public DocumentUriTemplate newDocumentUriTemplate(String var1);

    public DocumentMetadataPatchBuilder newPatchBuilder(Format var1);

    public DocumentDescriptor exists(String var1) throws ForbiddenUserException, FailedRequestException;

    public DocumentDescriptor exists(String var1, Transaction var2) throws ForbiddenUserException, FailedRequestException;

    public <T> T readAs(String var1, Class<T> var2) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public <T> T readAs(String var1, Class<T> var2, ServerTransform var3) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public <T> T readAs(String var1, DocumentMetadataReadHandle var2, Class<T> var3) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public <T> T readAs(String var1, DocumentMetadataReadHandle var2, Class<T> var3, ServerTransform var4) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public <T extends R> T read(String var1, T var2) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public <T extends R> T read(String var1, T var2, ServerTransform var3) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public <T extends R> T read(DocumentDescriptor var1, T var2) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public <T extends R> T read(DocumentDescriptor var1, T var2, ServerTransform var3) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public <T extends R> T read(String var1, DocumentMetadataReadHandle var2, T var3) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public <T extends R> T read(String var1, DocumentMetadataReadHandle var2, T var3, ServerTransform var4) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public <T extends R> T read(DocumentDescriptor var1, DocumentMetadataReadHandle var2, T var3) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public <T extends R> T read(DocumentDescriptor var1, DocumentMetadataReadHandle var2, T var3, ServerTransform var4) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public <T extends R> T read(String var1, T var2, Transaction var3) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public <T extends R> T read(String var1, T var2, ServerTransform var3, Transaction var4) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public <T extends R> T read(DocumentDescriptor var1, T var2, Transaction var3) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public <T extends R> T read(DocumentDescriptor var1, T var2, ServerTransform var3, Transaction var4) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public <T extends R> T read(String var1, DocumentMetadataReadHandle var2, T var3, Transaction var4) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public <T extends R> T read(String var1, DocumentMetadataReadHandle var2, T var3, ServerTransform var4, Transaction var5) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public <T extends R> T read(DocumentDescriptor var1, DocumentMetadataReadHandle var2, T var3, Transaction var4) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public <T extends R> T read(DocumentDescriptor var1, DocumentMetadataReadHandle var2, T var3, ServerTransform var4, Transaction var5) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public void writeAs(String var1, Object var2) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public void writeAs(String var1, Object var2, ServerTransform var3) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public void writeAs(String var1, DocumentMetadataWriteHandle var2, Object var3) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public void writeAs(String var1, DocumentMetadataWriteHandle var2, Object var3, ServerTransform var4) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public void write(String var1, W var2) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public void write(String var1, W var2, ServerTransform var3) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public void write(DocumentDescriptor var1, W var2) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public void write(DocumentDescriptor var1, W var2, ServerTransform var3) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public void write(String var1, DocumentMetadataWriteHandle var2, W var3) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public void write(String var1, DocumentMetadataWriteHandle var2, W var3, ServerTransform var4) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public void write(DocumentDescriptor var1, DocumentMetadataWriteHandle var2, W var3) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public void write(DocumentDescriptor var1, DocumentMetadataWriteHandle var2, W var3, ServerTransform var4) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public void write(String var1, W var2, Transaction var3) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public void write(String var1, W var2, ServerTransform var3, Transaction var4) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public void write(DocumentDescriptor var1, W var2, Transaction var3) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public void write(DocumentDescriptor var1, W var2, ServerTransform var3, Transaction var4) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public void write(String var1, DocumentMetadataWriteHandle var2, W var3, Transaction var4) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public void write(String var1, DocumentMetadataWriteHandle var2, W var3, ServerTransform var4, Transaction var5) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public void write(DocumentDescriptor var1, DocumentMetadataWriteHandle var2, W var3, Transaction var4) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public void write(DocumentDescriptor var1, DocumentMetadataWriteHandle var2, W var3, ServerTransform var4, Transaction var5) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public void delete(String var1) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public void delete(String var1, Transaction var2) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public void delete(DocumentDescriptor var1) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public void delete(DocumentDescriptor var1, Transaction var2) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public DocumentDescriptor createAs(DocumentUriTemplate var1, Object var2) throws ForbiddenUserException, FailedRequestException;

    public DocumentDescriptor createAs(DocumentUriTemplate var1, Object var2, ServerTransform var3) throws ForbiddenUserException, FailedRequestException;

    public DocumentDescriptor createAs(DocumentUriTemplate var1, DocumentMetadataWriteHandle var2, Object var3) throws ForbiddenUserException, FailedRequestException;

    public DocumentDescriptor createAs(DocumentUriTemplate var1, DocumentMetadataWriteHandle var2, Object var3, ServerTransform var4) throws ForbiddenUserException, FailedRequestException;

    public DocumentDescriptor create(DocumentUriTemplate var1, W var2) throws ForbiddenUserException, FailedRequestException;

    public DocumentDescriptor create(DocumentUriTemplate var1, W var2, ServerTransform var3) throws ForbiddenUserException, FailedRequestException;

    public DocumentDescriptor create(DocumentUriTemplate var1, W var2, Transaction var3) throws ForbiddenUserException, FailedRequestException;

    public DocumentDescriptor create(DocumentUriTemplate var1, W var2, ServerTransform var3, Transaction var4) throws ForbiddenUserException, FailedRequestException;

    public DocumentDescriptor create(DocumentUriTemplate var1, DocumentMetadataWriteHandle var2, W var3) throws ForbiddenUserException, FailedRequestException;

    public DocumentDescriptor create(DocumentUriTemplate var1, DocumentMetadataWriteHandle var2, W var3, ServerTransform var4) throws ForbiddenUserException, FailedRequestException;

    public DocumentDescriptor create(DocumentUriTemplate var1, DocumentMetadataWriteHandle var2, W var3, Transaction var4) throws ForbiddenUserException, FailedRequestException;

    public DocumentDescriptor create(DocumentUriTemplate var1, DocumentMetadataWriteHandle var2, W var3, ServerTransform var4, Transaction var5) throws ForbiddenUserException, FailedRequestException;

    public void patchAs(String var1, Object var2) throws ForbiddenUserException, FailedRequestException;

    public void patch(String var1, DocumentPatchHandle var2);

    public void patch(String var1, DocumentPatchHandle var2, Transaction var3);

    public void patch(DocumentDescriptor var1, DocumentPatchHandle var2);

    public void patch(DocumentDescriptor var1, DocumentPatchHandle var2, Transaction var3);

    public <T extends DocumentMetadataReadHandle> T readMetadata(String var1, T var2) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public <T extends DocumentMetadataReadHandle> T readMetadata(String var1, T var2, Transaction var3) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public void writeMetadata(String var1, DocumentMetadataWriteHandle var2) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public void writeMetadata(String var1, DocumentMetadataWriteHandle var2, Transaction var3) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public void writeDefaultMetadata(String var1) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public void writeDefaultMetadata(String var1, Transaction var2) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException;

    public Format getContentFormat();

    public Set<Metadata> getMetadataCategories();

    public void setMetadataCategories(Set<Metadata> var1);

    public void setMetadataCategories(Metadata ... var1);

    public void clearMetadataCategories();

    public ServerTransform getReadTransform();

    public void setReadTransform(ServerTransform var1);

    public ServerTransform getWriteTransform();

    public void setWriteTransform(ServerTransform var1);

    public String getForestName();

    public void setForestName(String var1);

    public void startLogging(RequestLogger var1);

    public void stopLogging();

    public static enum Metadata {
        ALL,
        COLLECTIONS,
        PERMISSIONS,
        PROPERTIES,
        QUALITY;

    }
}

