/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.client.FailedRequestException;
import com.marklogic.client.ForbiddenUserException;
import com.marklogic.client.MarkLogicInternalException;
import com.marklogic.client.ResourceNotFoundException;
import com.marklogic.client.ResourceNotResendableException;
import com.marklogic.client.admin.ExtensionLibrariesManager;
import com.marklogic.client.admin.NamespacesManager;
import com.marklogic.client.admin.QueryOptionsManager;
import com.marklogic.client.admin.ResourceExtensionsManager;
import com.marklogic.client.admin.ServerConfigurationManager;
import com.marklogic.client.admin.TransformExtensionsManager;
import com.marklogic.client.impl.ExtensionLibrariesManagerImpl;
import com.marklogic.client.impl.NamespacesManagerImpl;
import com.marklogic.client.impl.QueryOptionsManagerImpl;
import com.marklogic.client.impl.RESTServices;
import com.marklogic.client.impl.ResourceExtensionsImpl;
import com.marklogic.client.impl.TransformExtensionsImpl;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.OutputStreamHandle;
import com.marklogic.client.io.OutputStreamSender;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServerConfigurationManagerImpl
implements ServerConfigurationManager,
OutputStreamSender {
    private static final Logger logger = LoggerFactory.getLogger(ServerConfigurationManagerImpl.class);
    private static final String REST_API_NS = "http://marklogic.com/rest-api";
    private Boolean validatingQueries;
    private Boolean validatingQueryOptions;
    private String defaultDocumentReadTransform;
    private Boolean defaultDocumentReadTransformAll;
    private Boolean serverRequestLogging;
    private ServerConfigurationManager.Policy contentVersions;
    private ServerConfigurationManager.UpdatePolicy updatePolicy;
    private Format errorFormat;
    private RESTServices services;
    private DatabaseClientFactory.HandleFactoryRegistry handleRegistry;

    public ServerConfigurationManagerImpl(RESTServices services) {
        this.services = services;
    }

    DatabaseClientFactory.HandleFactoryRegistry getHandleRegistry() {
        return this.handleRegistry;
    }

    void setHandleRegistry(DatabaseClientFactory.HandleFactoryRegistry handleRegistry) {
        this.handleRegistry = handleRegistry;
    }

    @Override
    public void readConfiguration() throws ForbiddenUserException, FailedRequestException {
        try {
            InputStream stream;
            if (logger.isInfoEnabled()) {
                logger.info("Reading server configuration");
            }
            if ((stream = this.services.getValues(null, "config/properties", "application/xml", InputStream.class)) == null) {
                return;
            }
            XMLInputFactory factory = XMLInputFactory.newFactory();
            factory.setProperty("javax.xml.stream.isNamespaceAware", true);
            factory.setProperty("javax.xml.stream.isValidating", false);
            XMLStreamReader reader = factory.createXMLStreamReader(stream);
            this.validatingQueries = null;
            this.validatingQueryOptions = null;
            this.defaultDocumentReadTransform = null;
            this.defaultDocumentReadTransformAll = null;
            this.serverRequestLogging = null;
            this.contentVersions = null;
            this.updatePolicy = null;
            while (reader.hasNext()) {
                if (reader.next() != 1) continue;
                String localName = reader.getLocalName();
                if ("validate-queries".equals(localName)) {
                    this.validatingQueries = Boolean.valueOf(reader.getElementText());
                    continue;
                }
                if ("validate-options".equals(localName)) {
                    this.validatingQueryOptions = Boolean.valueOf(reader.getElementText());
                    continue;
                }
                if ("document-transform-out".equals(localName)) {
                    this.defaultDocumentReadTransform = reader.getElementText();
                    continue;
                }
                if ("document-transform-all".equals(localName)) {
                    this.defaultDocumentReadTransformAll = Boolean.valueOf(reader.getElementText());
                    continue;
                }
                if ("debug".equals(localName)) {
                    this.serverRequestLogging = Boolean.valueOf(reader.getElementText());
                    continue;
                }
                if ("content-versions".equals(localName)) {
                    this.contentVersions = Enum.valueOf(ServerConfigurationManager.Policy.class, reader.getElementText().toUpperCase());
                    continue;
                }
                if ("update-policy".equals(localName)) {
                    this.updatePolicy = Enum.valueOf(ServerConfigurationManager.UpdatePolicy.class, reader.getElementText().toUpperCase().replace("-", "_"));
                    continue;
                }
                if (!"error-format".equals(localName)) continue;
                this.errorFormat = Format.valueOf(reader.getElementText().toUpperCase());
            }
            reader.close();
            if (this.contentVersions == null) {
                this.updatePolicyToContentVersion();
            } else if (this.updatePolicy == null) {
                this.contentVersionToUpdatePolicy();
            }
        }
        catch (XMLStreamException e) {
            logger.error("Failed to read server configuration stream", (Throwable)e);
            throw new MarkLogicInternalException(e);
        }
    }

    @Override
    public void writeConfiguration() throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        if (logger.isInfoEnabled()) {
            logger.info("Writing server configuration");
        }
        OutputStreamHandle handle = new OutputStreamHandle(this);
        handle.setResendable(true);
        this.services.putValue(null, "config/properties", null, "application/xml", handle);
    }

    @Override
    public void write(OutputStream out) throws IOException {
        try {
            XMLOutputFactory factory = XMLOutputFactory.newFactory();
            factory.setProperty("javax.xml.stream.isRepairingNamespaces", true);
            XMLStreamWriter serializer = factory.createXMLStreamWriter(out, "utf-8");
            serializer.writeStartElement(REST_API_NS, "properties");
            if (this.validatingQueries != null) {
                serializer.writeStartElement(REST_API_NS, "validate-queries");
                serializer.writeCharacters(this.validatingQueries.toString());
                serializer.writeEndElement();
            }
            if (this.validatingQueryOptions != null) {
                serializer.writeStartElement(REST_API_NS, "validate-options");
                serializer.writeCharacters(this.validatingQueryOptions.toString());
                serializer.writeEndElement();
            }
            if (this.defaultDocumentReadTransform != null) {
                serializer.writeStartElement(REST_API_NS, "document-transform-out");
                serializer.writeCharacters(this.defaultDocumentReadTransform);
                serializer.writeEndElement();
            }
            if (this.defaultDocumentReadTransformAll != null) {
                serializer.writeStartElement(REST_API_NS, "document-transform-all");
                serializer.writeCharacters(this.defaultDocumentReadTransformAll.toString());
                serializer.writeEndElement();
            }
            if (this.serverRequestLogging != null) {
                serializer.writeStartElement(REST_API_NS, "debug");
                serializer.writeCharacters(this.serverRequestLogging.toString());
                serializer.writeEndElement();
            }
            if (this.contentVersions != null) {
                serializer.writeStartElement(REST_API_NS, "content-versions");
                serializer.writeCharacters(this.contentVersions.name().toLowerCase());
                serializer.writeEndElement();
            }
            if (this.updatePolicy != null) {
                serializer.writeStartElement(REST_API_NS, "update-policy");
                serializer.writeCharacters(this.updatePolicy.name().toLowerCase().replace("_", "-"));
                serializer.writeEndElement();
            }
            if (this.errorFormat != null) {
                serializer.writeStartElement(REST_API_NS, "error-format");
                serializer.writeCharacters(this.errorFormat.name().toLowerCase());
                serializer.writeEndElement();
            }
            serializer.writeEndDocument();
        }
        catch (XMLStreamException e) {
            logger.error("Failed to write server configuration stream", (Throwable)e);
            throw new MarkLogicInternalException(e);
        }
    }

    @Override
    public Boolean getQueryOptionValidation() {
        return this.validatingQueryOptions;
    }

    @Override
    public void setQueryOptionValidation(Boolean on) {
        this.validatingQueryOptions = on;
    }

    @Override
    public Boolean getQueryValidation() {
        return this.validatingQueries;
    }

    @Override
    public void setQueryValidation(Boolean on) {
        this.validatingQueries = on;
    }

    @Override
    public String getDefaultDocumentReadTransform() {
        return this.defaultDocumentReadTransform;
    }

    @Override
    public void setDefaultDocumentReadTransform(String name) {
        this.defaultDocumentReadTransform = name;
    }

    @Override
    public Boolean getDefaultDocumentReadTransformAll() {
        return this.defaultDocumentReadTransformAll;
    }

    @Override
    public void setDefaultDocumentReadTransformAll(Boolean on) {
        this.defaultDocumentReadTransformAll = on;
    }

    @Override
    public Boolean getServerRequestLogging() {
        return this.serverRequestLogging;
    }

    @Override
    public void setServerRequestLogging(Boolean on) {
        this.serverRequestLogging = on;
    }

    @Override
    public ServerConfigurationManager.UpdatePolicy getUpdatePolicy() {
        return this.updatePolicy;
    }

    @Override
    public void setUpdatePolicy(ServerConfigurationManager.UpdatePolicy updatePolicy) {
        this.updatePolicy = updatePolicy;
        this.updatePolicyToContentVersion();
    }

    private void updatePolicyToContentVersion() {
        if (this.updatePolicy == null) {
            return;
        }
        switch (this.updatePolicy) {
            case VERSION_REQUIRED: {
                this.contentVersions = ServerConfigurationManager.Policy.REQUIRED;
                break;
            }
            case VERSION_OPTIONAL: {
                this.contentVersions = ServerConfigurationManager.Policy.OPTIONAL;
                break;
            }
            case MERGE_METADATA: {
                this.contentVersions = ServerConfigurationManager.Policy.NONE;
            }
        }
    }

    @Override
    public ServerConfigurationManager.Policy getContentVersionRequests() {
        return this.contentVersions;
    }

    @Override
    public void setContentVersionRequests(ServerConfigurationManager.Policy policy) {
        this.contentVersions = policy;
        this.contentVersionToUpdatePolicy();
    }

    private void contentVersionToUpdatePolicy() {
        if (this.contentVersions == null) {
            return;
        }
        switch (this.contentVersions) {
            case REQUIRED: {
                this.updatePolicy = ServerConfigurationManager.UpdatePolicy.VERSION_REQUIRED;
                break;
            }
            case OPTIONAL: {
                this.updatePolicy = ServerConfigurationManager.UpdatePolicy.VERSION_OPTIONAL;
                break;
            }
            case NONE: {
                this.updatePolicy = ServerConfigurationManager.UpdatePolicy.MERGE_METADATA;
            }
        }
    }

    @Override
    public ExtensionLibrariesManager newExtensionLibrariesManager() {
        ExtensionLibrariesManagerImpl extensionMgr = new ExtensionLibrariesManagerImpl(this.services);
        extensionMgr.setHandleRegistry(this.getHandleRegistry());
        return extensionMgr;
    }

    @Override
    public NamespacesManager newNamespacesManager() {
        return new NamespacesManagerImpl(this.services);
    }

    @Override
    public QueryOptionsManager newQueryOptionsManager() {
        QueryOptionsManagerImpl optMgr = new QueryOptionsManagerImpl(this.services);
        optMgr.setHandleRegistry(this.getHandleRegistry());
        return optMgr;
    }

    @Override
    public ResourceExtensionsManager newResourceExtensionsManager() {
        ResourceExtensionsImpl resourceExtensionMgr = new ResourceExtensionsImpl(this.services);
        resourceExtensionMgr.setHandleRegistry(this.getHandleRegistry());
        return resourceExtensionMgr;
    }

    @Override
    public TransformExtensionsManager newTransformExtensionsManager() {
        TransformExtensionsImpl transformExtensionMgr = new TransformExtensionsImpl(this.services);
        transformExtensionMgr.setHandleRegistry(this.getHandleRegistry());
        return transformExtensionMgr;
    }

    @Override
    public Format getErrorFormat() {
        return this.errorFormat;
    }

    @Override
    public void setErrorFormat(Format errorFormat) {
        if (errorFormat != Format.JSON && errorFormat != Format.XML) {
            throw new IllegalArgumentException("The only supported values for error format are JSON and XML.");
        }
        this.errorFormat = errorFormat;
    }
}

