/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.io;

import com.marklogic.client.MarkLogicBindingException;
import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.admin.config.QueryOptions;
import com.marklogic.client.admin.config.support.Annotatable;
import com.marklogic.client.admin.config.support.QueryOptionsConfiguration;
import com.marklogic.client.impl.QueryOptionsTransformExtractNS;
import com.marklogic.client.impl.QueryOptionsTransformInjectNS;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.OutputStreamSender;
import com.marklogic.client.io.marker.BufferableHandle;
import com.marklogic.client.io.marker.QueryOptionsReadHandle;
import com.marklogic.client.io.marker.QueryOptionsWriteHandle;
import com.marklogic.client.util.EditableNamespaceContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

@Deprecated
public final class QueryOptionsHandle
extends BaseHandle<InputStream, OutputStreamSender>
implements OutputStreamSender,
BufferableHandle,
QueryOptionsReadHandle,
QueryOptionsWriteHandle,
Annotatable<QueryOptionsHandle> {
    private static final Logger logger = LoggerFactory.getLogger(QueryOptionsHandle.class);
    private static SAXParserFactory pfactory = SAXParserFactory.newInstance();
    private static TransformerFactory tfactory = TransformerFactory.newInstance();
    private JAXBContext jc;
    private Marshaller marshaller;
    private QueryOptions optionsHolder;
    private Unmarshaller unmarshaller;

    public QueryOptionsHandle() {
        super.setFormat(Format.XML);
        this.setResendable(true);
        this.optionsHolder = new QueryOptions();
        try {
            SAXParser parser = pfactory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            QueryOptionsTransformExtractNS transform = new QueryOptionsTransformExtractNS();
            transform.setParent(reader);
            this.jc = JAXBContext.newInstance((Class[])new Class[]{QueryOptions.class});
            this.marshaller = this.jc.createMarshaller();
            this.marshaller.setProperty("jaxb.formatted.output", (Object)true);
            this.unmarshaller = this.jc.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new MarkLogicBindingException((Exception)((Object)e));
        }
        catch (SAXException e) {
            throw new MarkLogicBindingException(e);
        }
        catch (ParserConfigurationException e) {
            throw new MarkLogicBindingException(e);
        }
    }

    @Override
    public QueryOptionsHandle annotate(String queryAnnotation) {
        this.optionsHolder.annotate(queryAnnotation);
        return this;
    }

    public void addConstraint(QueryOptions.QueryConstraint constraint) {
        this.optionsHolder.getQueryConstraints().add(constraint);
    }

    public void addForest(long forest) {
        this.optionsHolder.getForests().add(forest);
    }

    public void addOperator(QueryOptions.QueryOperator operator) {
        this.optionsHolder.getQueryOperators().add(operator);
    }

    public void addSearchOption(String searchOption) {
        this.optionsHolder.getSearchOptions().add(searchOption);
    }

    public void addSuggestionSource(QueryOptions.QuerySuggestionSource suggestionSource) {
        this.optionsHolder.getSuggestionSources().add(suggestionSource);
    }

    public void addValues(QueryOptions.QueryValues values) {
        this.optionsHolder.getQueryValues().add(values);
    }

    public Element getAdditionalQuery() {
        return this.optionsHolder.getAdditionalQuery();
    }

    public int getConcurrencyLevel() {
        return this.optionsHolder.getConcurrencyLevel();
    }

    public QueryOptions.QueryConstraint getConstraint(String constraintName) {
        for (QueryOptions.QueryConstraint constraintOption : this.getConstraints()) {
            if (!constraintOption.getName().equals(constraintName)) continue;
            return constraintOption;
        }
        return null;
    }

    public List<QueryOptions.QueryConstraint> getConstraints() {
        return this.optionsHolder.getQueryConstraints();
    }

    @Override
    public List<QueryOptions.QueryAnnotation> getAnnotations() {
        return this.optionsHolder.getAnnotations();
    }

    public Boolean getDebug() {
        return this.returnWithDefault(this.optionsHolder.getDebug(), false);
    }

    public QueryOptions.QueryDefaultSuggestionSource getDefaultSuggestionSource() {
        return this.optionsHolder.getDefaultSuggestionSource();
    }

    public List<Long> getForests() {
        return this.optionsHolder.getForests();
    }

    @Override
    public Format getFormat() {
        return Format.XML;
    }

    public QueryOptions.FragmentScope getFragmentScope() {
        return QueryOptions.FragmentScope.valueOf(this.optionsHolder.getFragmentScope().toUpperCase());
    }

    public QueryOptions.QueryGrammar getGrammar() {
        return this.optionsHolder.getGrammar();
    }

    public List<QueryOptions.QueryOperator> getOperators() {
        return this.optionsHolder.getQueryOperators();
    }

    public QueryOptions getOptions() {
        return this.optionsHolder;
    }

    public long getPageLength() {
        return this.optionsHolder.getPageLength();
    }

    public double getQualityWeight() {
        return this.optionsHolder.getQualityWeight();
    }

    public List<QueryOptions.QueryValues> getValues() {
        return this.optionsHolder.getQueryValues();
    }

    public QueryOptions.QueryValues getValues(String valuesName) {
        for (QueryOptions.QueryValues values : this.getValues()) {
            if (!values.getName().equals(valuesName)) continue;
            return values;
        }
        return null;
    }

    public List<QueryOptions.QueryTuples> getTuples() {
        return this.optionsHolder.getQueryTuples();
    }

    public QueryOptions.QueryTuples getTuples(String tuplesName) {
        for (QueryOptions.QueryTuples values : this.getTuples()) {
            if (!values.getName().equals(tuplesName)) continue;
            return values;
        }
        return null;
    }

    public Boolean getReturnAggregates() {
        return this.returnWithDefault(this.optionsHolder.getReturnAggregates(), false);
    }

    public Boolean getReturnConstraints() {
        return this.returnWithDefault(this.optionsHolder.getReturnConstraints(), false);
    }

    public Boolean getReturnFacets() {
        return this.returnWithDefault(this.optionsHolder.getReturnFacets(), true);
    }

    public Boolean getReturnFrequencies() {
        return this.returnWithDefault(this.optionsHolder.getReturnFrequencies(), true);
    }

    public Boolean getReturnMetrics() {
        return this.returnWithDefault(this.optionsHolder.getReturnMetrics(), true);
    }

    public Boolean getReturnPlan() {
        return this.returnWithDefault(this.optionsHolder.getReturnPlan(), false);
    }

    public Boolean getReturnQtext() {
        return this.returnWithDefault(this.optionsHolder.getReturnQtext(), false);
    }

    public Boolean getReturnQuery() {
        return this.returnWithDefault(this.optionsHolder.getReturnQuery(), false);
    }

    public Boolean getReturnResults() {
        return this.returnWithDefault(this.optionsHolder.getReturnResults(), true);
    }

    public Boolean getReturnSimilar() {
        return this.returnWithDefault(this.optionsHolder.getReturnSimilar(), false);
    }

    public Boolean getReturnValues() {
        return this.returnWithDefault(this.optionsHolder.getReturnValues(), true);
    }

    public NamespaceContext getSearchableExpressionNamespaceContext() {
        return this.optionsHolder.getSearchableExpressionNamespaceContext();
    }

    public String getSearchableExpression() {
        return this.optionsHolder.getSearchableExpression();
    }

    public List<String> getSearchOptions() {
        return this.optionsHolder.getSearchOptions();
    }

    public List<QueryOptions.QuerySortOrder> getSortOrders() {
        return this.optionsHolder.getSortOrders();
    }

    public List<QueryOptions.QuerySuggestionSource> getSuggestionSources() {
        return this.optionsHolder.getSuggestionSources();
    }

    public QueryOptions.QueryTerm getTerm() {
        return this.optionsHolder.getTerm();
    }

    public QueryOptions.QueryTransformResults getTransformResults() {
        return this.optionsHolder.getTransformResults();
    }

    public void setAdditionalQuery(Element ctsQuery) {
        this.optionsHolder.setAdditionalQuery(ctsQuery);
    }

    public void setConcurrencyLevel(Integer concurrencyLevel) {
        this.optionsHolder.setConcurrencyLevel(concurrencyLevel);
    }

    public void setDebug(Boolean debug) {
        this.optionsHolder.setDebug(debug);
    }

    public void setDefaultSuggestionSource(QueryOptions.QueryDefaultSuggestionSource defaultSuggestionSource) {
        this.optionsHolder.setDefaultSuggestionSource(defaultSuggestionSource);
    }

    public void setForests(List<Long> forests) {
        this.optionsHolder.setForests(forests);
    }

    @Override
    public void setFormat(Format format) {
        if (format != Format.XML) {
            throw new IllegalArgumentException("QueryOptionsHandle supports the XML format only");
        }
    }

    public void setFragmentScope(QueryOptions.FragmentScope fragmentScope) {
        this.optionsHolder.setFragmentScope(fragmentScope);
    }

    public void setGrammar(QueryOptions.QueryGrammar grammar) {
        this.optionsHolder.setGrammar(grammar);
    }

    public QueryOptionsHandle withGrammar(QueryOptions.QueryGrammar grammar) {
        this.optionsHolder.setGrammar(grammar);
        return this;
    }

    public void setOperators(List<QueryOptions.QueryOperator> operatorOptions) {
        this.optionsHolder.setOperators(operatorOptions);
    }

    public void setPageLength(Long pageLength) {
        this.optionsHolder.setPageLength(pageLength);
    }

    public QueryOptionsHandle withOperators(QueryOptions.QueryOperator ... queryOperator) {
        this.optionsHolder.setOperators(Arrays.asList(queryOperator));
        return this;
    }

    public void setTuples(List<QueryOptions.QueryTuples> tuples) {
        this.optionsHolder.setQueryTuples(tuples);
    }

    public QueryOptionsHandle withTuples(QueryOptions.QueryTuples ... tuples) {
        this.optionsHolder.setQueryTuples(Arrays.asList(tuples));
        return this;
    }

    public void setValues(List<QueryOptions.QueryValues> values) {
        this.optionsHolder.setQueryValues(values);
    }

    public QueryOptionsHandle withValues(QueryOptions.QueryValues ... values) {
        this.optionsHolder.setQueryValues(Arrays.asList(values));
        return this;
    }

    public void setQualityWeight(Double qualityWeight) {
        this.optionsHolder.setQualityWeight(qualityWeight);
    }

    public void setReturnAggregates(Boolean returnAggregates) {
        this.optionsHolder.setReturnAggregates(returnAggregates);
    }

    public void setReturnConstraints(Boolean returnConstraints) {
        this.optionsHolder.setReturnConstraints(returnConstraints);
    }

    public void setReturnFacets(Boolean returnFacets) {
        this.optionsHolder.setReturnFacets(returnFacets);
    }

    public void setReturnFrequencies(Boolean returnFrequencies) {
        this.optionsHolder.setReturnFrequencies(returnFrequencies);
    }

    public void setReturnMetrics(Boolean returnMetrics) {
        this.optionsHolder.setReturnMetrics(returnMetrics);
    }

    public void setReturnQuery(Boolean returnQuery) {
        this.optionsHolder.setReturnQuery(returnQuery);
    }

    public void setReturnPlan(Boolean returnPlan) {
        this.optionsHolder.setReturnPlan(returnPlan);
    }

    public void setReturnQtext(Boolean returnQtext) {
        this.optionsHolder.setReturnQtext(returnQtext);
    }

    public void setReturnResults(Boolean returnResults) {
        this.optionsHolder.setReturnResults(returnResults);
    }

    public void setReturnSimilar(Boolean returnSimilar) {
        this.optionsHolder.setReturnSimilar(returnSimilar);
    }

    public void setReturnValues(Boolean returnValues) {
        this.optionsHolder.setReturnValues(returnValues);
    }

    public void setSearchableExpression(String searchableExpression) {
        EditableNamespaceContext context = this.optionsHolder.getSearchableExpressionNamespaceContext();
        QueryOptions.ExpressionNamespaceBindings bindings = new QueryOptions.ExpressionNamespaceBindings();
        for (String prefix : context.getAllPrefixes()) {
            if ("".equals(prefix)) continue;
            bindings.addBinding(prefix, context.getNamespaceURI(prefix));
        }
        QueryOptions.ExpressionNamespaceBinding[] bindingsArray = bindings.toArray();
        this.optionsHolder.setSearchableExpression(new QueryOptions.QuerySearchableExpression(searchableExpression, bindingsArray));
    }

    public void setSearchableExpressionNamespaceContext(EditableNamespaceContext context) {
        this.optionsHolder.setSearchableExpressionNamespaceContext(context);
        String expr = this.optionsHolder.getSearchableExpression();
        if (expr != null) {
            this.setSearchableExpression(expr);
        }
    }

    public void setSearchOptions(List<String> searchOptions) {
        this.optionsHolder.setSearchOptions(searchOptions);
    }

    public void setSortOrders(List<QueryOptions.QuerySortOrder> sortOrders) {
        this.optionsHolder.setSortOrders(sortOrders);
    }

    public void setSuggestionSources(List<QueryOptions.QuerySuggestionSource> suggestionSources) {
        this.optionsHolder.setSuggestionSources(suggestionSources);
    }

    public QueryOptionsHandle withAdditionalQuery(QueryOptions.QueryAdditionalQuery additionalQuery) {
        this.setAdditionalQuery(additionalQuery.getValue());
        return this;
    }

    public QueryOptionsHandle withSearchableExpression(QueryOptions.QuerySearchableExpression searchableExpression) {
        this.optionsHolder.setSearchableExpression(searchableExpression);
        return this;
    }

    public QueryOptionsHandle withSortOrders(QueryOptions.QuerySortOrder ... sortOrders) {
        this.optionsHolder.setSortOrders(Arrays.asList(sortOrders));
        return this;
    }

    public void setTerm(QueryOptions.QueryTerm termConfig) {
        this.optionsHolder.setTerm(termConfig);
    }

    public void setTransformResults(QueryOptions.QueryTransformResults transformResults) {
        this.optionsHolder.setTransformResults(transformResults);
    }

    public QueryOptionsHandle withTerm(QueryOptions.QueryTerm term) {
        this.optionsHolder.setTerm(term);
        return this;
    }

    public QueryOptionsHandle withTransformResults(QueryOptions.QueryTransformResults transformResults) {
        this.optionsHolder.setTransformResults(transformResults);
        return this;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JAXBElement jaxbElement = new JAXBElement(new QName("http://marklogic.com/appservices/search", "options"), QueryOptions.class, (Object)this.optionsHolder);
        try {
            logger.debug("Begin write of QueryOptionsHandle");
            this.optionsHolder.patchBindings();
            this.marshaller.marshal((Object)jaxbElement, (OutputStream)baos);
            QueryOptionsTransformInjectNS itransform = new QueryOptionsTransformInjectNS();
            String xml = baos.toString();
            ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes("utf-8"));
            InputSource source = new InputSource(in);
            SAXParser parser = pfactory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            itransform.setParent(reader);
            Transformer transformer = tfactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "no");
            StreamResult result = new StreamResult(out);
            SAXSource saxSource = new SAXSource(itransform, source);
            transformer.transform(saxSource, result);
            logger.debug("End write of QueryOptionsHandle");
        }
        catch (JAXBException e) {
            throw new MarkLogicBindingException((Exception)((Object)e));
        }
        catch (ParserConfigurationException e) {
            throw new MarkLogicBindingException(e);
        }
        catch (TransformerConfigurationException e) {
            throw new MarkLogicBindingException(e);
        }
        catch (TransformerException e) {
            throw new MarkLogicBindingException(e);
        }
        catch (SAXException e) {
            throw new MarkLogicBindingException(e);
        }
    }

    private Boolean returnWithDefault(Boolean returnValue, Boolean defaultValue) {
        if (returnValue == null) {
            return defaultValue;
        }
        return returnValue;
    }

    @Override
    public void fromBuffer(byte[] buffer) {
        this.receiveContent(new ByteArrayInputStream(buffer));
    }

    @Override
    public byte[] toBuffer() {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            this.write(buffer);
            return buffer.toByteArray();
        }
        catch (IOException e) {
            throw new MarkLogicIOException(e);
        }
    }

    public String toString() {
        try {
            return new String(this.toBuffer(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new MarkLogicIOException(e);
        }
    }

    @Override
    protected Class<InputStream> receiveAs() {
        return InputStream.class;
    }

    @Override
    protected void receiveContent(InputStream content) {
        try {
            SAXParser parser = pfactory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            Transformer transformer = tfactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "no");
            QueryOptionsTransformExtractNS transform = new QueryOptionsTransformExtractNS();
            transform.setParent(reader);
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            InputSource source = new InputSource(content);
            SAXSource saxSource = new SAXSource(transform, source);
            transformer.transform(saxSource, result);
            String xmlResult = sw.toString();
            ByteArrayInputStream in = new ByteArrayInputStream(xmlResult.getBytes("UTF-8"));
            this.optionsHolder = (QueryOptions)this.unmarshaller.unmarshal((InputStream)in);
        }
        catch (JAXBException e) {
            throw new MarkLogicBindingException((Exception)((Object)e));
        }
        catch (ParserConfigurationException e) {
            throw new MarkLogicBindingException(e);
        }
        catch (TransformerConfigurationException e) {
            throw new MarkLogicBindingException(e);
        }
        catch (TransformerException e) {
            throw new MarkLogicBindingException(e);
        }
        catch (SAXException e) {
            throw new MarkLogicBindingException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new MarkLogicBindingException(e);
        }
        finally {
            try {
                content.close();
            }
            catch (IOException e) {}
        }
    }

    @Override
    protected OutputStreamSender sendContent() {
        return this;
    }

    public QueryOptions.QueryOperator getOperator(String name) {
        for (QueryOptions.QueryOperator operator : this.optionsHolder.getQueryOperators()) {
            if (!operator.getName().equals(name)) continue;
            return operator;
        }
        return null;
    }

    public QueryOptions.QueryExtractMetadata getExtractMetadata() {
        return this.optionsHolder.getExtractMetadata();
    }

    public void setExtractMetadata(QueryOptions.QueryExtractMetadata extractMetadata) {
        this.optionsHolder.setExtractMetadata(extractMetadata);
    }

    public QueryOptionsHandle withExtractMetadata(QueryOptions.QueryExtractMetadata extractMetadata) {
        this.optionsHolder.setExtractMetadata(extractMetadata);
        return this;
    }

    public void setConstraints(List<QueryOptions.QueryConstraint> constraints) {
        this.optionsHolder.setConstraints(constraints);
    }

    public QueryOptionsHandle withConstraints(QueryOptions.QueryConstraint ... constraints) {
        this.optionsHolder.setConstraints(Arrays.asList(constraints));
        return this;
    }

    public QueryOptionsHandle withConfiguration(QueryOptionsConfiguration configuration) {
        this.optionsHolder.setConcurrencyLevel(configuration.getConcurrencyLevel());
        this.optionsHolder.setDebug(configuration.getDebug());
        this.optionsHolder.setForests(configuration.getForests());
        this.optionsHolder.setFragmentScope(configuration.getFragmentScope());
        this.optionsHolder.setPageLength(configuration.getPageLength());
        this.optionsHolder.setQualityWeight(configuration.getQualityWeight());
        this.optionsHolder.setReturnAggregates(configuration.getReturnAggregates());
        this.optionsHolder.setReturnConstraints(configuration.getReturnConstraints());
        this.optionsHolder.setReturnFacets(configuration.getReturnFacets());
        this.optionsHolder.setReturnFrequencies(configuration.getReturnFrequencies());
        this.optionsHolder.setReturnMetrics(configuration.getReturnMetrics());
        this.optionsHolder.setReturnPlan(configuration.getReturnPlan());
        this.optionsHolder.setReturnQtext(configuration.getReturnQtext());
        this.optionsHolder.setReturnQuery(configuration.getReturnQuery());
        this.optionsHolder.setReturnResults(configuration.getReturnResults());
        this.optionsHolder.setReturnSimilar(configuration.getReturnSimilar());
        this.optionsHolder.setReturnValues(configuration.getReturnValues());
        this.optionsHolder.setSearchOptions(configuration.getSearchOptions());
        return this;
    }

    static {
        pfactory.setValidating(false);
        pfactory.setNamespaceAware(true);
    }
}

