/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.Transaction;
import com.marklogic.client.extensions.ResourceServices;
import com.marklogic.client.impl.AbstractLoggingManager;
import com.marklogic.client.impl.RESTServices;
import com.marklogic.client.io.marker.AbstractReadHandle;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import com.marklogic.client.util.RequestLogger;
import com.marklogic.client.util.RequestParameters;

class ResourceServicesImpl
extends AbstractLoggingManager
implements ResourceServices {
    private String resourceName;
    private RESTServices services;

    ResourceServicesImpl(RESTServices services, String resourceName) {
        this.services = services;
        this.resourceName = resourceName;
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    private String getResourcePath() {
        return "resources/" + this.getResourceName();
    }

    @Override
    public <R extends AbstractReadHandle> R get(RequestParameters params, R output) {
        return this.get(params, null, output);
    }

    @Override
    public <R extends AbstractReadHandle> R get(RequestParameters params, Transaction transaction, R output) {
        return this.services.getResource(this.requestLogger, this.getResourcePath(), this.prepareParams(params, transaction), output);
    }

    @Override
    public ResourceServices.ServiceResultIterator get(RequestParameters params, String ... outputMimetypes) {
        return this.get(params, (Transaction)null, outputMimetypes);
    }

    @Override
    public ResourceServices.ServiceResultIterator get(RequestParameters params, Transaction transaction, String ... outputMimetypes) {
        return this.services.getIteratedResource(this.requestLogger, this.getResourcePath(), this.prepareParams(params, transaction), outputMimetypes);
    }

    @Override
    public <R extends AbstractReadHandle> R put(RequestParameters params, AbstractWriteHandle input, R output) {
        return this.put(params, input, null, output);
    }

    @Override
    public <R extends AbstractReadHandle> R put(RequestParameters params, AbstractWriteHandle input, Transaction transaction, R output) {
        return this.services.putResource(this.requestLogger, this.getResourcePath(), this.prepareParams(params, transaction), input, output);
    }

    @Override
    public <R extends AbstractReadHandle, W extends AbstractWriteHandle> R put(RequestParameters params, W[] input, R output) {
        return (R)this.put(params, (AbstractWriteHandle[])input, null, output);
    }

    @Override
    public <R extends AbstractReadHandle, W extends AbstractWriteHandle> R put(RequestParameters params, W[] input, Transaction transaction, R output) {
        return (R)this.services.putResource(this.requestLogger, this.getResourcePath(), this.prepareParams(params, transaction), (AbstractWriteHandle[])input, output);
    }

    @Override
    public <R extends AbstractReadHandle> R post(RequestParameters params, AbstractWriteHandle input, R output) {
        return this.post(params, input, null, output);
    }

    @Override
    public <R extends AbstractReadHandle> R post(RequestParameters params, AbstractWriteHandle input, Transaction transaction, R output) {
        return this.services.postResource(this.requestLogger, this.getResourcePath(), this.prepareParams(params, transaction), input, output);
    }

    @Override
    public ResourceServices.ServiceResultIterator post(RequestParameters params, AbstractWriteHandle input, String ... outputMimetypes) {
        return this.post(params, input, (Transaction)null, outputMimetypes);
    }

    @Override
    public ResourceServices.ServiceResultIterator post(RequestParameters params, AbstractWriteHandle input, Transaction transaction, String ... outputMimetypes) {
        return this.services.postIteratedResource(this.requestLogger, this.getResourcePath(), this.prepareParams(params, transaction), input, outputMimetypes);
    }

    @Override
    public <R extends AbstractReadHandle, W extends AbstractWriteHandle> R post(RequestParameters params, W[] input, R output) {
        return (R)this.post(params, (AbstractWriteHandle[])input, null, output);
    }

    @Override
    public <R extends AbstractReadHandle, W extends AbstractWriteHandle> R post(RequestParameters params, W[] input, Transaction transaction, R output) {
        return (R)this.services.postResource(this.requestLogger, this.getResourcePath(), this.prepareParams(params, transaction), (AbstractWriteHandle[])input, output);
    }

    @Override
    public <W extends AbstractWriteHandle> ResourceServices.ServiceResultIterator post(RequestParameters params, W[] input, String ... outputMimetypes) {
        return this.post(params, (AbstractWriteHandle[])input, null, outputMimetypes);
    }

    @Override
    public <W extends AbstractWriteHandle> ResourceServices.ServiceResultIterator post(RequestParameters params, W[] input, Transaction transaction, String ... outputMimetypes) {
        return this.services.postIteratedResource(this.requestLogger, this.getResourcePath(), this.prepareParams(params, transaction), (AbstractWriteHandle[])input, outputMimetypes);
    }

    @Override
    public <R extends AbstractReadHandle> R delete(RequestParameters params, R output) {
        return this.delete(params, null, output);
    }

    @Override
    public <R extends AbstractReadHandle> R delete(RequestParameters params, Transaction transaction, R output) {
        return this.services.deleteResource(this.requestLogger, this.getResourcePath(), this.prepareParams(params, transaction), output);
    }

    @Override
    public RequestLogger getRequestLogger() {
        return this.requestLogger;
    }

    private RequestParameters prepareParams(RequestParameters params, Transaction transaction) {
        if (params == null && transaction == null) {
            return null;
        }
        if (transaction == null) {
            return params.copy("rs");
        }
        RequestParameters requestParams = params != null ? params.copy("rs") : new RequestParameters();
        requestParams.add("txid", transaction.getTransactionId());
        return requestParams;
    }
}

