/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.extra.xom;

import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.OutputStreamSender;
import com.marklogic.client.io.marker.BufferableHandle;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.ContentHandleFactory;
import com.marklogic.client.io.marker.StructureReadHandle;
import com.marklogic.client.io.marker.StructureWriteHandle;
import com.marklogic.client.io.marker.XMLReadHandle;
import com.marklogic.client.io.marker.XMLWriteHandle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.ParsingException;
import nu.xom.Serializer;
import nu.xom.ValidityException;

public class XOMHandle
extends BaseHandle<InputStream, OutputStreamSender>
implements OutputStreamSender,
BufferableHandle,
ContentHandle<Document>,
XMLReadHandle,
XMLWriteHandle,
StructureReadHandle,
StructureWriteHandle {
    private Document content;
    private Builder builder;

    public static ContentHandleFactory newFactory() {
        return new ContentHandleFactory(){

            @Override
            public Class<?>[] getHandledClasses() {
                return new Class[]{Document.class};
            }

            @Override
            public boolean isHandled(Class<?> type) {
                return Document.class.isAssignableFrom(type);
            }

            @Override
            public <C> ContentHandle<C> newHandle(Class<C> type) {
                XOMHandle handle = this.isHandled(type) ? new XOMHandle() : null;
                return handle;
            }
        };
    }

    public XOMHandle() {
        super.setFormat(Format.XML);
        this.setResendable(true);
    }

    public XOMHandle(Document content) {
        this();
        this.set(content);
    }

    public Builder getBuilder() {
        if (this.builder == null) {
            this.builder = this.makeBuilder();
        }
        return this.builder;
    }

    public void setBuilder(Builder builder) {
        this.builder = builder;
    }

    protected Builder makeBuilder() {
        return new Builder(false);
    }

    @Override
    public Document get() {
        return this.content;
    }

    @Override
    public void set(Document content) {
        this.content = content;
    }

    public XOMHandle with(Document content) {
        this.set(content);
        return this;
    }

    @Override
    public void setFormat(Format format) {
        if (format != Format.XML) {
            throw new IllegalArgumentException("XOMHandle supports the XML format only");
        }
    }

    @Override
    public void fromBuffer(byte[] buffer) {
        if (buffer == null || buffer.length == 0) {
            this.content = null;
        } else {
            this.receiveContent(new ByteArrayInputStream(buffer));
        }
    }

    @Override
    public byte[] toBuffer() {
        try {
            if (this.content == null) {
                return null;
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            this.write(buffer);
            return buffer.toByteArray();
        }
        catch (IOException e) {
            throw new MarkLogicIOException(e);
        }
    }

    public String toString() {
        try {
            return new String(this.toBuffer(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new MarkLogicIOException(e);
        }
    }

    @Override
    protected Class<InputStream> receiveAs() {
        return InputStream.class;
    }

    @Override
    protected void receiveContent(InputStream content) {
        if (content == null) {
            return;
        }
        try {
            this.content = this.getBuilder().build((Reader)new InputStreamReader(content, "UTF-8"));
        }
        catch (ValidityException e) {
            throw new MarkLogicIOException(e);
        }
        catch (ParsingException e) {
            throw new MarkLogicIOException(e);
        }
        catch (IOException e) {
            throw new MarkLogicIOException(e);
        }
        finally {
            try {
                content.close();
            }
            catch (IOException e) {}
        }
    }

    @Override
    protected OutputStreamSender sendContent() {
        if (this.content == null) {
            throw new IllegalStateException("No document to write");
        }
        return this;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        this.makeSerializer(out).write(this.content);
    }

    protected Serializer makeSerializer(OutputStream out) throws UnsupportedEncodingException {
        return new Serializer(out, "UTF-8");
    }
}

