/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.client.FailedRequestException;
import com.marklogic.client.ForbiddenUserException;
import com.marklogic.client.ResourceNotFoundException;
import com.marklogic.client.Transaction;
import com.marklogic.client.bitemporal.TemporalDocumentManager;
import com.marklogic.client.document.DocumentDescriptor;
import com.marklogic.client.document.DocumentManager;
import com.marklogic.client.document.DocumentMetadataPatchBuilder;
import com.marklogic.client.document.DocumentPage;
import com.marklogic.client.document.DocumentUriTemplate;
import com.marklogic.client.document.DocumentWriteSet;
import com.marklogic.client.document.ServerTransform;
import com.marklogic.client.impl.AbstractLoggingManager;
import com.marklogic.client.impl.DocumentDescriptorImpl;
import com.marklogic.client.impl.DocumentMetadataPatchBuilderImpl;
import com.marklogic.client.impl.DocumentUriTemplateImpl;
import com.marklogic.client.impl.DocumentWriteSetImpl;
import com.marklogic.client.impl.HandleAccessor;
import com.marklogic.client.impl.HandleImplementation;
import com.marklogic.client.impl.RESTServices;
import com.marklogic.client.impl.Utilities;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.SearchHandle;
import com.marklogic.client.io.marker.AbstractReadHandle;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.DocumentMetadataReadHandle;
import com.marklogic.client.io.marker.DocumentMetadataWriteHandle;
import com.marklogic.client.io.marker.DocumentPatchHandle;
import com.marklogic.client.io.marker.SearchReadHandle;
import com.marklogic.client.query.QueryDefinition;
import com.marklogic.client.query.QueryManager;
import com.marklogic.client.util.RequestParameters;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class DocumentManagerImpl<R extends AbstractReadHandle, W extends AbstractWriteHandle>
extends AbstractLoggingManager
implements DocumentManager<R, W>,
TemporalDocumentManager<R, W> {
    private static final long DEFAULT_PAGE_LENGTH = 50L;
    private static final Logger logger = LoggerFactory.getLogger(DocumentManagerImpl.class);
    private boolean isProcessedMetadataModified = false;
    private final Set<DocumentManager.Metadata> processedMetadata = new HashSet<DocumentManager.Metadata>(){

        @Override
        public boolean add(DocumentManager.Metadata e) {
            DocumentManagerImpl.this.isProcessedMetadataModified = true;
            return super.add(e);
        }

        @Override
        public boolean addAll(Collection<? extends DocumentManager.Metadata> c) {
            DocumentManagerImpl.this.isProcessedMetadataModified = true;
            return super.addAll(c);
        }
    };
    private RESTServices services;
    private Format contentFormat;
    private DatabaseClientFactory.HandleFactoryRegistry handleRegistry;
    private ServerTransform readTransform;
    private ServerTransform writeTransform;
    private String forestName;
    private long pageLength;
    private QueryManager.QueryView searchView;
    private Format nonDocumentFormat;

    DocumentManagerImpl(RESTServices services, Format contentFormat) {
        this.processedMetadata.add(DocumentManager.Metadata.ALL);
        this.isProcessedMetadataModified = false;
        this.pageLength = 50L;
        this.searchView = QueryManager.QueryView.RESULTS;
        this.nonDocumentFormat = null;
        this.services = services;
        this.contentFormat = contentFormat;
    }

    RESTServices getServices() {
        return this.services;
    }

    void setServices(RESTServices services) {
        this.services = services;
    }

    DatabaseClientFactory.HandleFactoryRegistry getHandleRegistry() {
        return this.handleRegistry;
    }

    void setHandleRegistry(DatabaseClientFactory.HandleFactoryRegistry handleRegistry) {
        this.handleRegistry = handleRegistry;
    }

    @Override
    public Format getContentFormat() {
        return this.contentFormat;
    }

    @Override
    public void setMetadataCategories(Set<DocumentManager.Metadata> categories) {
        this.clearMetadataCategories();
        this.processedMetadata.addAll(categories);
    }

    @Override
    public void setMetadataCategories(DocumentManager.Metadata ... categories) {
        this.clearMetadataCategories();
        for (DocumentManager.Metadata category : categories) {
            this.processedMetadata.add(category);
        }
    }

    @Override
    public Set<DocumentManager.Metadata> getMetadataCategories() {
        return this.processedMetadata;
    }

    @Override
    public void clearMetadataCategories() {
        this.processedMetadata.clear();
    }

    @Override
    public DocumentDescriptor exists(String uri) throws ForbiddenUserException, FailedRequestException {
        return this.exists(uri, null);
    }

    @Override
    public DocumentDescriptor exists(String uri, Transaction transaction) throws ForbiddenUserException, FailedRequestException {
        return this.services.head(this.requestLogger, uri, transaction);
    }

    @Override
    public <T> T readAs(String uri, Class<T> as) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        return this.readAs(uri, null, as, null);
    }

    @Override
    public <T> T readAs(String uri, Class<T> as, ServerTransform transform) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        return this.readAs(uri, null, as, transform);
    }

    @Override
    public <T> T readAs(String uri, DocumentMetadataReadHandle metadataHandle, Class<T> as) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        return this.readAs(uri, metadataHandle, as, null);
    }

    @Override
    public <T> T readAs(String uri, DocumentMetadataReadHandle metadataHandle, Class<T> as, ServerTransform transform) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        ContentHandle<T> handle = this.getHandleRegistry().makeHandle(as);
        if (null == this.read(uri, metadataHandle, this.castAbstractReadHandle(as, handle), transform)) {
            return null;
        }
        return handle.get();
    }

    R castAbstractReadHandle(Class<?> as, AbstractReadHandle handle) {
        try {
            AbstractReadHandle readHandle = handle;
            return (R)readHandle;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Handle " + handle.getClass().getName() + " cannot be used in the context to read " + as.getName());
        }
    }

    @Override
    public <T extends R> T read(String uri, T contentHandle) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        return this.read(uri, null, contentHandle, null, null);
    }

    @Override
    public <T extends R> T read(String uri, T contentHandle, ServerTransform transform) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        return this.read(uri, null, contentHandle, transform, null);
    }

    @Override
    public <T extends R> T read(String uri, DocumentMetadataReadHandle metadataHandle, T contentHandle) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        return this.read(uri, metadataHandle, contentHandle, null, null);
    }

    @Override
    public <T extends R> T read(String uri, DocumentMetadataReadHandle metadataHandle, T contentHandle, ServerTransform transform) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        return this.read(uri, metadataHandle, contentHandle, transform, null);
    }

    @Override
    public <T extends R> T read(String uri, T contentHandle, Transaction transaction) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        return this.read(uri, null, contentHandle, null, transaction);
    }

    @Override
    public <T extends R> T read(String uri, T contentHandle, ServerTransform transform, Transaction transaction) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        return this.read(uri, null, contentHandle, transform, transaction);
    }

    @Override
    public <T extends R> T read(String uri, DocumentMetadataReadHandle metadataHandle, T contentHandle, Transaction transaction) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        return this.read(uri, metadataHandle, contentHandle, null, transaction);
    }

    @Override
    public <T extends R> T read(String uri, DocumentMetadataReadHandle metadataHandle, T contentHandle, ServerTransform transform, Transaction transaction) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        return this.read(new DocumentDescriptorImpl(uri, true), metadataHandle, contentHandle, transform, transaction, null, this.getReadParams());
    }

    @Override
    public <T extends R> T read(DocumentDescriptor desc, T contentHandle) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        return this.read(desc, null, contentHandle, null, null);
    }

    @Override
    public <T extends R> T read(DocumentDescriptor desc, T contentHandle, ServerTransform transform) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        return this.read(desc, null, contentHandle, transform, null);
    }

    @Override
    public <T extends R> T read(DocumentDescriptor desc, DocumentMetadataReadHandle metadataHandle, T contentHandle) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        return this.read(desc, metadataHandle, contentHandle, null, null);
    }

    @Override
    public <T extends R> T read(DocumentDescriptor desc, DocumentMetadataReadHandle metadataHandle, T contentHandle, ServerTransform transform) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        return this.read(desc, metadataHandle, contentHandle, transform, null);
    }

    @Override
    public <T extends R> T read(DocumentDescriptor desc, T contentHandle, Transaction transaction) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        return this.read(desc, null, contentHandle, null, transaction);
    }

    @Override
    public <T extends R> T read(DocumentDescriptor desc, T contentHandle, ServerTransform transform, Transaction transaction) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        return this.read(desc, null, contentHandle, transform, transaction);
    }

    @Override
    public <T extends R> T read(DocumentDescriptor desc, DocumentMetadataReadHandle metadataHandle, T contentHandle, Transaction transaction) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        return this.read(desc, metadataHandle, contentHandle, null, transaction);
    }

    @Override
    public <T extends R> T read(DocumentDescriptor desc, DocumentMetadataReadHandle metadataHandle, T contentHandle, ServerTransform transform, Transaction transaction) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        return this.read(desc, metadataHandle, contentHandle, transform, transaction, null, this.getReadParams());
    }

    public <T extends R> T read(DocumentDescriptor desc, DocumentMetadataReadHandle metadataHandle, T contentHandle, ServerTransform transform, Transaction transaction, String temporalCollection, RequestParameters extraParams) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        HandleImplementation metadataBase;
        Format metadataFormat;
        if (desc == null) {
            throw new IllegalArgumentException("Attempt to call read with null DocumentDescriptor");
        }
        if (logger.isInfoEnabled()) {
            logger.info("Reading metadata and content for {}", (Object)desc.getUri());
        }
        if (metadataHandle != null && ((metadataFormat = (metadataBase = HandleAccessor.checkHandle(metadataHandle, "metadata")).getFormat()) == null || metadataFormat != Format.JSON && metadataFormat != Format.XML)) {
            if (logger.isWarnEnabled()) {
                logger.warn("Unsupported metadata format {}, using XML", (Object)metadataFormat.name());
            }
            metadataBase.setFormat(Format.XML);
        }
        this.checkContentFormat(contentHandle);
        extraParams = this.addTemporalParams(extraParams, temporalCollection, null);
        boolean wasModified = this.services.getDocument(this.requestLogger, desc, transaction, metadataHandle != null ? this.processedMetadata : null, this.mergeTransformParameters(transform != null ? transform : this.getReadTransform(), extraParams), metadataHandle, (AbstractReadHandle)contentHandle);
        return (T)(wasModified ? contentHandle : null);
    }

    @Override
    public DocumentPage read(String ... uris) {
        return this.read((ServerTransform)null, (Transaction)null, uris);
    }

    @Override
    public DocumentPage read(Transaction transaction, String ... uris) {
        return this.read(null, transaction, uris);
    }

    @Override
    public DocumentPage read(ServerTransform transform, String ... uris) {
        return this.read(transform, (Transaction)null, uris);
    }

    @Override
    public DocumentPage read(ServerTransform transform, Transaction transaction, String ... uris) {
        boolean withContent = true;
        return this.read(transform, transaction, withContent, null, uris);
    }

    public DocumentPage read(ServerTransform transform, Transaction transaction, boolean withContent, String temporalCollection, String[] uris) {
        if (uris == null || uris.length == 0) {
            throw new IllegalArgumentException("Attempt to call read with no uris");
        }
        if (logger.isInfoEnabled()) {
            logger.info("Reading metadata and content for multiple uris beginning with {}", (Object)uris[0]);
        }
        RequestParameters extraParams = this.addTemporalParams(new RequestParameters(), temporalCollection, null);
        return this.services.getBulkDocuments(this.requestLogger, transaction, this.isProcessedMetadataModified ? this.processedMetadata : null, this.nonDocumentFormat, this.mergeTransformParameters(transform != null ? transform : this.getReadTransform(), extraParams), withContent, uris);
    }

    @Override
    public DocumentPage readMetadata(String ... uris) {
        boolean withContent = false;
        return this.read(null, null, withContent, null, uris);
    }

    @Override
    public DocumentPage readMetadata(Transaction transaction, String ... uris) {
        boolean withContent = false;
        return this.read(null, transaction, withContent, null, uris);
    }

    @Override
    public DocumentPage search(QueryDefinition querydef, long start) {
        return this.search(querydef, start, null, null);
    }

    @Override
    public DocumentPage search(QueryDefinition querydef, long start, SearchReadHandle searchHandle) {
        return this.search(querydef, start, searchHandle, null);
    }

    @Override
    public DocumentPage search(QueryDefinition querydef, long start, Transaction transaction) {
        return this.search(querydef, start, null, transaction);
    }

    @Override
    public DocumentPage search(QueryDefinition querydef, long start, SearchReadHandle searchHandle, Transaction transaction) {
        if (searchHandle != null) {
            HandleImplementation searchBase = HandleAccessor.checkHandle(searchHandle, "search");
            if (searchHandle instanceof SearchHandle) {
                SearchHandle responseHandle = (SearchHandle)searchHandle;
                responseHandle.setHandleRegistry(this.getHandleRegistry());
                responseHandle.setQueryCriteria(querydef);
            }
            if (this.nonDocumentFormat != null && this.nonDocumentFormat != searchBase.getFormat()) {
                throw new UnsupportedOperationException("The format supported by your handle:[" + (Object)((Object)searchBase.getFormat()) + "] does not match the non-document format:[" + (Object)((Object)this.nonDocumentFormat) + "]");
            }
        }
        String tid = transaction == null ? null : transaction.getTransactionId();
        Set<DocumentManager.Metadata> metadata = this.isProcessedMetadataModified ? this.processedMetadata : null;
        return this.services.getBulkDocuments(this.requestLogger, querydef, start, this.getPageLength(), transaction, searchHandle, this.searchView, metadata, this.nonDocumentFormat, null);
    }

    @Override
    public long getPageLength() {
        return this.pageLength;
    }

    @Override
    public void setPageLength(long length) {
        this.pageLength = length;
    }

    @Override
    public QueryManager.QueryView getSearchView() {
        return this.searchView;
    }

    @Override
    public void setSearchView(QueryManager.QueryView view) {
        this.searchView = view;
    }

    @Override
    public Format getNonDocumentFormat() {
        return this.nonDocumentFormat;
    }

    @Override
    public void setNonDocumentFormat(Format nonDocumentFormat) {
        if (nonDocumentFormat != Format.XML && nonDocumentFormat != Format.JSON) {
            throw new UnsupportedOperationException("Only XML and JSON are valid response formats.  You specified:[" + (Object)((Object)nonDocumentFormat) + "]");
        }
        this.nonDocumentFormat = nonDocumentFormat;
    }

    @Override
    public DocumentWriteSet newWriteSet() {
        return new DocumentWriteSetImpl();
    }

    @Override
    public void write(DocumentWriteSet writeSet) {
        this.write(writeSet, null, null);
    }

    @Override
    public void write(DocumentWriteSet writeSet, ServerTransform transform) {
        this.write(writeSet, transform, null);
    }

    @Override
    public void write(DocumentWriteSet writeSet, Transaction transaction) {
        this.write(writeSet, null, transaction);
    }

    @Override
    public void write(DocumentWriteSet writeSet, ServerTransform transform, Transaction transaction) {
        Format defaultFormat = this.contentFormat;
        this.services.postBulkDocuments(this.requestLogger, writeSet, transform != null ? transform : this.getWriteTransform(), transaction, defaultFormat, null);
    }

    @Override
    public void writeAs(String uri, Object content) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        this.writeAs(uri, null, content, null);
    }

    @Override
    public void writeAs(String uri, Object content, ServerTransform transform) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        this.writeAs(uri, null, content, transform);
    }

    @Override
    public void writeAs(String uri, DocumentMetadataWriteHandle metadataHandle, Object content) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        this.writeAs(uri, metadataHandle, content, null);
    }

    @Override
    public void writeAs(String uri, DocumentMetadataWriteHandle metadataHandle, Object content, ServerTransform transform) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        if (content == null) {
            throw new IllegalArgumentException("no content to write");
        }
        Class<?> as = content.getClass();
        W writeHandle = null;
        if (AbstractWriteHandle.class.isAssignableFrom(as)) {
            AbstractWriteHandle handle = (AbstractWriteHandle)content;
            writeHandle = this.castAbstractWriteHandle(null, handle);
        } else {
            ContentHandle<?> handle = this.getHandleRegistry().makeHandle(as);
            Utilities.setHandleContent(handle, content);
            writeHandle = this.castAbstractWriteHandle(as, handle);
        }
        this.write(uri, metadataHandle, writeHandle, transform);
    }

    W castAbstractWriteHandle(Class<?> as, AbstractWriteHandle handle) {
        try {
            AbstractWriteHandle writeHandle = handle;
            return (W)writeHandle;
        }
        catch (ClassCastException e) {
            if (as == null) {
                throw new IllegalArgumentException("Handle " + handle.getClass().getName() + " cannot be used in the context for writing");
            }
            throw new IllegalArgumentException("Handle " + handle.getClass().getName() + " cannot be used in the context to write " + as.getName());
        }
    }

    @Override
    public void write(String uri, W contentHandle) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        this.write(uri, null, contentHandle, null, null, null, null);
    }

    @Override
    public void write(String uri, W contentHandle, ServerTransform transform) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        this.write(uri, null, contentHandle, transform, null, null, null);
    }

    @Override
    public void write(String uri, DocumentMetadataWriteHandle metadata, W contentHandle) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        this.write(uri, metadata, contentHandle, null, null, null, null);
    }

    @Override
    public void write(String uri, DocumentMetadataWriteHandle metadata, W contentHandle, ServerTransform transform) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        this.write(uri, metadata, contentHandle, transform, null, null, null);
    }

    @Override
    public void write(String uri, W contentHandle, Transaction transaction) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        this.write(uri, null, contentHandle, null, transaction, null, null);
    }

    @Override
    public void write(String uri, W contentHandle, ServerTransform transform, Transaction transaction) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        this.write(uri, null, contentHandle, transform, transaction, null, null);
    }

    @Override
    public void write(String uri, DocumentMetadataWriteHandle metadataHandle, W contentHandle, Transaction transaction) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        this.write(uri, metadataHandle, contentHandle, null, transaction, null, null);
    }

    @Override
    public void write(String uri, DocumentMetadataWriteHandle metadataHandle, W contentHandle, ServerTransform transform, Transaction transaction) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        this.write(uri, metadataHandle, contentHandle, transform, transaction, null, null);
    }

    @Override
    public void write(String uri, DocumentMetadataWriteHandle metadataHandle, W contentHandle, ServerTransform transform, Transaction transaction, String temporalCollection) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        this.write(uri, metadataHandle, contentHandle, transform, transaction, temporalCollection, null);
    }

    @Override
    public void write(String uri, DocumentMetadataWriteHandle metadataHandle, W contentHandle, ServerTransform transform, Transaction transaction, String temporalCollection, Calendar systemTime) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        this.write(new DocumentDescriptorImpl(uri, true), metadataHandle, contentHandle, transform, transaction, temporalCollection, systemTime, this.getWriteParams());
    }

    public void write(String uri, DocumentMetadataWriteHandle metadataHandle, W contentHandle, ServerTransform transform, Transaction transaction, String temporalCollection, Calendar systemTime, RequestParameters extraParams) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        this.write(new DocumentDescriptorImpl(uri, true), metadataHandle, contentHandle, transform, transaction, temporalCollection, systemTime, extraParams);
    }

    @Override
    public void write(DocumentDescriptor desc, W contentHandle) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        this.write(desc, null, contentHandle, null, null, null, null);
    }

    @Override
    public void write(DocumentDescriptor desc, W contentHandle, ServerTransform transform) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        this.write(desc, null, contentHandle, transform, null, null, null);
    }

    @Override
    public void write(DocumentDescriptor desc, DocumentMetadataWriteHandle metadata, W contentHandle) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        this.write(desc, metadata, contentHandle, null, null, null, null);
    }

    @Override
    public void write(DocumentDescriptor desc, DocumentMetadataWriteHandle metadata, W contentHandle, ServerTransform transform) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        this.write(desc, metadata, contentHandle, transform, null, null, null);
    }

    @Override
    public void write(DocumentDescriptor desc, W contentHandle, Transaction transaction) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        this.write(desc, null, contentHandle, null, transaction, null, null);
    }

    @Override
    public void write(DocumentDescriptor desc, W contentHandle, ServerTransform transform, Transaction transaction) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        this.write(desc, null, contentHandle, transform, transaction, null, null);
    }

    @Override
    public void write(DocumentDescriptor desc, DocumentMetadataWriteHandle metadataHandle, W contentHandle, Transaction transaction) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        this.write(desc, metadataHandle, contentHandle, null, transaction, null, null);
    }

    @Override
    public void write(DocumentDescriptor desc, DocumentMetadataWriteHandle metadataHandle, W contentHandle, ServerTransform transform, Transaction transaction) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        this.write(desc, metadataHandle, contentHandle, transform, transaction, null, null);
    }

    @Override
    public void write(DocumentDescriptor desc, DocumentMetadataWriteHandle metadataHandle, W contentHandle, ServerTransform transform, Transaction transaction, String temporalCollection) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        this.write(desc, metadataHandle, contentHandle, transform, transaction, temporalCollection, null);
    }

    @Override
    public void write(DocumentDescriptor desc, DocumentMetadataWriteHandle metadataHandle, W contentHandle, ServerTransform transform, Transaction transaction, String temporalCollection, Calendar systemTime) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        this.write(desc, metadataHandle, contentHandle, transform, transaction, temporalCollection, null, this.getWriteParams());
    }

    public void write(DocumentDescriptor desc, DocumentMetadataWriteHandle metadataHandle, W contentHandle, ServerTransform transform, Transaction transaction, String temporalCollection, Calendar systemTime, RequestParameters extraParams) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        HandleImplementation metadataBase;
        Format metadataFormat;
        if (desc == null) {
            throw new IllegalArgumentException("Writing document with null identifier");
        }
        if (logger.isInfoEnabled()) {
            logger.info("Writing content for {}", (Object)desc.getUri());
        }
        if (metadataHandle != null && ((metadataFormat = (metadataBase = HandleAccessor.checkHandle(metadataHandle, "metadata")).getFormat()) == null || metadataFormat != Format.JSON && metadataFormat != Format.XML)) {
            if (logger.isWarnEnabled()) {
                logger.warn("Unsupported metadata format {}, using XML", (Object)metadataFormat.name());
            }
            metadataBase.setFormat(Format.XML);
        }
        this.checkContentFormat(contentHandle);
        extraParams = this.addTemporalParams(extraParams, temporalCollection, systemTime);
        this.services.putDocument(this.requestLogger, desc, transaction, metadataHandle != null ? this.processedMetadata : null, this.mergeTransformParameters(transform != null ? transform : this.getWriteTransform(), extraParams), metadataHandle, (AbstractWriteHandle)contentHandle);
    }

    @Override
    public void delete(String uri) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        this.delete(uri, (Transaction)null);
    }

    @Override
    public void delete(String uri, Transaction transaction) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        this.delete(new DocumentDescriptorImpl(uri, true), transaction);
    }

    @Override
    public void delete(String ... uris) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        this.services.delete(this.requestLogger, null, uris);
    }

    @Override
    public void delete(Transaction transaction, String ... uris) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        this.services.delete(this.requestLogger, transaction, uris);
    }

    @Override
    public void delete(DocumentDescriptor desc) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        this.delete(desc, null, null);
    }

    @Override
    public void delete(DocumentDescriptor desc, Transaction transaction) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        this.delete(desc, transaction, null);
    }

    @Override
    public void delete(String uri, Transaction transaction, String temporalCollection) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        this.delete(new DocumentDescriptorImpl(uri, true), transaction, temporalCollection);
    }

    @Override
    public void delete(String uri, Transaction transaction, String temporalCollection, Calendar systemTime) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        this.delete(new DocumentDescriptorImpl(uri, true), transaction, temporalCollection, systemTime);
    }

    @Override
    public void delete(DocumentDescriptor desc, Transaction transaction, String temporalCollection) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        this.delete(desc, transaction, temporalCollection, null);
    }

    @Override
    public void delete(DocumentDescriptor desc, Transaction transaction, String temporalCollection, Calendar systemTime) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        if (desc == null) {
            throw new IllegalArgumentException("Deleting document with null identifier");
        }
        if (logger.isInfoEnabled()) {
            logger.info("Deleting {}", (Object)desc.getUri());
        }
        RequestParameters extraParams = this.addTemporalParams(new RequestParameters(), temporalCollection, systemTime);
        this.services.deleteDocument(this.requestLogger, desc, transaction, null, extraParams);
    }

    @Override
    public DocumentDescriptor createAs(DocumentUriTemplate template, Object content) throws ForbiddenUserException, FailedRequestException {
        return this.createAs(template, null, content, null);
    }

    @Override
    public DocumentDescriptor createAs(DocumentUriTemplate template, Object content, ServerTransform transform) throws ForbiddenUserException, FailedRequestException {
        return this.createAs(template, null, content, transform);
    }

    @Override
    public DocumentDescriptor createAs(DocumentUriTemplate template, DocumentMetadataWriteHandle metadataHandle, Object content) throws ForbiddenUserException, FailedRequestException {
        return this.createAs(template, metadataHandle, content, null);
    }

    @Override
    public DocumentDescriptor createAs(DocumentUriTemplate template, DocumentMetadataWriteHandle metadataHandle, Object content, ServerTransform transform) throws ForbiddenUserException, FailedRequestException {
        Class<?> as = content.getClass();
        W writeHandle = null;
        if (AbstractWriteHandle.class.isAssignableFrom(as)) {
            AbstractWriteHandle handle = (AbstractWriteHandle)content;
            writeHandle = this.castAbstractWriteHandle(null, handle);
        } else {
            ContentHandle<?> handle = this.getHandleRegistry().makeHandle(as);
            Utilities.setHandleContent(handle, content);
            writeHandle = this.castAbstractWriteHandle(as, handle);
        }
        return this.create(template, metadataHandle, writeHandle, transform);
    }

    @Override
    public DocumentDescriptor create(DocumentUriTemplate template, W contentHandle) throws ForbiddenUserException, FailedRequestException {
        return this.create(template, null, contentHandle, null, null, null, null);
    }

    @Override
    public DocumentDescriptor create(DocumentUriTemplate template, W contentHandle, ServerTransform transform) throws ForbiddenUserException, FailedRequestException {
        return this.create(template, null, contentHandle, transform, null, null, null);
    }

    @Override
    public DocumentDescriptor create(DocumentUriTemplate template, W contentHandle, Transaction transaction) throws ForbiddenUserException, FailedRequestException {
        return this.create(template, null, contentHandle, null, transaction, null, null);
    }

    @Override
    public DocumentDescriptor create(DocumentUriTemplate template, W contentHandle, ServerTransform transform, Transaction transaction) throws ForbiddenUserException, FailedRequestException {
        return this.create(template, null, contentHandle, transform, transaction, null, null);
    }

    @Override
    public DocumentDescriptor create(DocumentUriTemplate template, DocumentMetadataWriteHandle metadataHandle, W contentHandle) throws ForbiddenUserException, FailedRequestException {
        return this.create(template, metadataHandle, contentHandle, null, null, null, null);
    }

    @Override
    public DocumentDescriptor create(DocumentUriTemplate template, DocumentMetadataWriteHandle metadataHandle, W contentHandle, ServerTransform transform) throws ForbiddenUserException, FailedRequestException {
        return this.create(template, metadataHandle, contentHandle, transform, null, null, null);
    }

    @Override
    public DocumentDescriptor create(DocumentUriTemplate template, DocumentMetadataWriteHandle metadataHandle, W contentHandle, Transaction transaction) throws ForbiddenUserException, FailedRequestException {
        return this.create(template, metadataHandle, contentHandle, null, transaction, null, null);
    }

    @Override
    public DocumentDescriptor create(DocumentUriTemplate template, DocumentMetadataWriteHandle metadataHandle, W contentHandle, ServerTransform transform, Transaction transaction) throws ForbiddenUserException, FailedRequestException {
        return this.create(template, metadataHandle, contentHandle, transform, transaction, null, null);
    }

    @Override
    public DocumentDescriptor create(DocumentUriTemplate template, DocumentMetadataWriteHandle metadataHandle, W contentHandle, ServerTransform transform, Transaction transaction, String temporalCollection) throws ForbiddenUserException, FailedRequestException {
        return this.create(template, metadataHandle, contentHandle, transform, transaction, temporalCollection, null);
    }

    @Override
    public DocumentDescriptor create(DocumentUriTemplate template, DocumentMetadataWriteHandle metadataHandle, W contentHandle, ServerTransform transform, Transaction transaction, String temporalCollection, Calendar systemTime) {
        return this.create(template, metadataHandle, contentHandle, transform, transaction, temporalCollection, null, this.getWriteParams());
    }

    public DocumentDescriptor create(DocumentUriTemplate template, DocumentMetadataWriteHandle metadataHandle, W contentHandle, ServerTransform transform, Transaction transaction, String temporalCollection, Calendar systemTime, RequestParameters extraParams) {
        HandleImplementation metadataBase;
        Format metadataFormat;
        if (logger.isInfoEnabled()) {
            logger.info("Creating content");
        }
        if (metadataHandle != null && ((metadataFormat = (metadataBase = HandleAccessor.checkHandle(metadataHandle, "metadata")).getFormat()) == null || metadataFormat != Format.JSON && metadataFormat != Format.XML)) {
            if (logger.isWarnEnabled()) {
                logger.warn("Unsupported metadata format {}, using XML", (Object)metadataFormat.name());
            }
            metadataBase.setFormat(Format.XML);
        }
        extraParams = this.addTemporalParams(extraParams, temporalCollection, systemTime);
        this.checkContentFormat(contentHandle);
        return this.services.postDocument(this.requestLogger, template, transaction, metadataHandle != null ? this.processedMetadata : null, this.mergeTransformParameters(transform != null ? transform : this.getWriteTransform(), extraParams), metadataHandle, (AbstractWriteHandle)contentHandle);
    }

    @Override
    public void patchAs(String uri, Object patch) throws ForbiddenUserException, FailedRequestException {
        if (patch == null) {
            throw new IllegalArgumentException("no patch to apply");
        }
        Class<?> as = patch.getClass();
        DocumentPatchHandle patchHandle = null;
        if (DocumentPatchHandle.class.isAssignableFrom(as)) {
            patchHandle = (DocumentPatchHandle)patch;
        } else {
            ContentHandle<?> handle = this.getHandleRegistry().makeHandle(as);
            if (!DocumentPatchHandle.class.isAssignableFrom(handle.getClass())) {
                throw new IllegalArgumentException("Handle " + handle.getClass().getName() + " cannot be used to apply patch as " + as.getName());
            }
            Utilities.setHandleContent(handle, patch);
            patchHandle = (DocumentPatchHandle)((Object)handle);
        }
        this.patch(uri, patchHandle);
    }

    @Override
    public void patch(String uri, DocumentPatchHandle patch) throws ForbiddenUserException, FailedRequestException {
        this.patch(uri, patch, null);
    }

    @Override
    public void patch(String uri, DocumentPatchHandle patch, Transaction transaction) throws ForbiddenUserException, FailedRequestException {
        this.patch(new DocumentDescriptorImpl(uri, true), patch, transaction);
    }

    @Override
    public void patch(DocumentDescriptor desc, DocumentPatchHandle patch) throws ForbiddenUserException, FailedRequestException {
        this.patch(desc, patch, null);
    }

    @Override
    public void patch(DocumentDescriptor desc, DocumentPatchHandle patch, Transaction transaction) throws ForbiddenUserException, FailedRequestException {
        if (logger.isInfoEnabled()) {
            logger.info("Patching document");
        }
        DocumentMetadataPatchBuilderImpl.DocumentPatchHandleImpl builtPatch = patch instanceof DocumentMetadataPatchBuilderImpl.DocumentPatchHandleImpl ? (DocumentMetadataPatchBuilderImpl.DocumentPatchHandleImpl)patch : null;
        this.services.patchDocument(this.requestLogger, desc, transaction, builtPatch != null ? builtPatch.getMetadata() : this.processedMetadata, builtPatch != null ? builtPatch.isOnContent() : true, patch);
    }

    @Override
    public <T extends DocumentMetadataReadHandle> T readMetadata(String uri, T metadataHandle) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        return this.readMetadata(uri, metadataHandle, null);
    }

    @Override
    public <T extends DocumentMetadataReadHandle> T readMetadata(String uri, T metadataHandle, Transaction transaction) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        this.read(uri, (DocumentMetadataReadHandle)metadataHandle, (T)null, transaction);
        return metadataHandle;
    }

    @Override
    public void writeMetadata(String uri, DocumentMetadataWriteHandle metadataHandle) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        this.writeMetadata(uri, metadataHandle, null);
    }

    @Override
    public void writeMetadata(String uri, DocumentMetadataWriteHandle metadataHandle, Transaction transaction) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        this.write(uri, metadataHandle, (AbstractWriteHandle)null, transaction);
    }

    @Override
    public void writeDefaultMetadata(String uri) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        this.writeDefaultMetadata(uri, null);
    }

    @Override
    public void writeDefaultMetadata(String uri, Transaction transaction) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        if (uri == null) {
            throw new IllegalArgumentException("Resetting document metadata with null identifier");
        }
        if (logger.isInfoEnabled()) {
            logger.info("Resetting metadata for {}", (Object)uri);
        }
        this.services.deleteDocument(this.requestLogger, new DocumentDescriptorImpl(uri, true), transaction, this.processedMetadata, this.getWriteParams());
    }

    @Override
    public ServerTransform getReadTransform() {
        return this.readTransform;
    }

    @Override
    public void setReadTransform(ServerTransform transform) {
        this.readTransform = transform;
    }

    @Override
    public ServerTransform getWriteTransform() {
        return this.writeTransform;
    }

    @Override
    public void setWriteTransform(ServerTransform transform) {
        this.writeTransform = transform;
    }

    @Override
    public String getForestName() {
        return this.forestName;
    }

    @Override
    public void setForestName(String forestName) {
        this.forestName = forestName;
    }

    @Override
    public DocumentDescriptor newDescriptor(String uri) {
        return new DocumentDescriptorImpl(uri, false);
    }

    @Override
    public DocumentUriTemplate newDocumentUriTemplate(String extension) {
        return new DocumentUriTemplateImpl(extension);
    }

    @Override
    public DocumentMetadataPatchBuilder newPatchBuilder(Format pathFormat) {
        return new DocumentMetadataPatchBuilderImpl(pathFormat);
    }

    private void checkContentFormat(Object contentHandle) {
        this.checkContentFormat(HandleAccessor.checkHandle(contentHandle, "content"));
    }

    private void checkContentFormat(HandleImplementation contentBase) {
        Format currFormat;
        if (contentBase == null) {
            return;
        }
        if (this.contentFormat != null && this.contentFormat != Format.UNKNOWN && (currFormat = contentBase.getFormat()) != this.contentFormat) {
            contentBase.setFormat(this.contentFormat);
            if (currFormat != Format.UNKNOWN) {
                contentBase.setMimetype(this.contentFormat.getDefaultMimetype());
            }
        }
    }

    protected RequestParameters mergeTransformParameters(ServerTransform transform, RequestParameters extraParams) {
        if (transform == null) {
            return extraParams;
        }
        if (extraParams == null) {
            extraParams = new RequestParameters();
        }
        transform.merge(extraParams);
        return extraParams;
    }

    protected RequestParameters getReadParams() {
        return null;
    }

    protected RequestParameters getWriteParams() {
        return null;
    }

    protected RequestParameters addTemporalParams(RequestParameters params, String temporalCollection, Calendar systemTime) {
        if (params == null) {
            params = new RequestParameters();
        }
        if (temporalCollection != null) {
            params.add("temporal-collection", temporalCollection);
        }
        if (systemTime != null) {
            String formattedSystemTime = DatatypeConverter.printDateTime((Calendar)systemTime);
            params.add("system-time", formattedSystemTime);
        }
        return params;
    }
}

