/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.document.DocumentMetadataPatchBuilder;
import com.marklogic.client.document.DocumentPatchBuilder;
import com.marklogic.client.impl.DocumentMetadataPatchBuilderImpl;
import com.marklogic.client.impl.JSONStringWriter;
import com.marklogic.client.io.Format;
import javax.xml.stream.XMLStreamWriter;

class DocumentPatchBuilderImpl
extends DocumentMetadataPatchBuilderImpl
implements DocumentPatchBuilder {
    DocumentPatchBuilderImpl(Format format) {
        super(format);
    }

    @Override
    public DocumentPatchBuilder delete(String selectPath) {
        return this.delete(selectPath, null);
    }

    @Override
    public DocumentPatchBuilder delete(String selectPath, DocumentMetadataPatchBuilder.Cardinality cardinality) {
        this.onContent();
        this.operations.add(new ContentDeleteOperation(selectPath, cardinality));
        return this;
    }

    @Override
    public DocumentPatchBuilder insertFragment(String contextPath, DocumentPatchBuilder.Position position, Object fragment) {
        return this.insertFragment(contextPath, position, null, fragment);
    }

    @Override
    public DocumentPatchBuilder insertFragment(String contextPath, DocumentPatchBuilder.Position position, DocumentMetadataPatchBuilder.Cardinality cardinality, Object fragment) {
        this.onContent();
        this.operations.add(new ContentInsertOperation(contextPath, position, cardinality, fragment));
        return this;
    }

    @Override
    public DocumentPatchBuilder replaceValue(String selectPath, Object value) {
        return this.replaceValue(selectPath, null, value);
    }

    @Override
    public DocumentPatchBuilder replaceValue(String selectPath, DocumentMetadataPatchBuilder.Cardinality cardinality, Object value) {
        this.onContent();
        this.operations.add(new ContentReplaceOperation(selectPath, cardinality, false, value));
        return this;
    }

    @Override
    public DocumentPatchBuilder replaceFragment(String selectPath, Object fragment) {
        return this.replaceFragment(selectPath, null, fragment);
    }

    @Override
    public DocumentPatchBuilder replaceFragment(String selectPath, DocumentMetadataPatchBuilder.Cardinality cardinality, Object fragment) {
        this.onContent();
        this.operations.add(new ContentReplaceOperation(selectPath, cardinality, true, fragment));
        return this;
    }

    @Override
    public DocumentPatchBuilder replaceInsertFragment(String selectPath, String contextPath, DocumentPatchBuilder.Position position, Object fragment) {
        return this.replaceInsertFragment(selectPath, contextPath, position, null, fragment);
    }

    @Override
    public DocumentPatchBuilder replaceInsertFragment(String selectPath, String contextPath, DocumentPatchBuilder.Position position, DocumentMetadataPatchBuilder.Cardinality cardinality, Object fragment) {
        this.onContent();
        this.operations.add(new ContentReplaceInsertOperation(selectPath, contextPath, position, cardinality, fragment));
        return this;
    }

    @Override
    public DocumentPatchBuilder replaceApply(String selectPath, DocumentMetadataPatchBuilder.Call call) {
        return this.replaceApply(selectPath, null, call);
    }

    @Override
    public DocumentPatchBuilder replaceApply(String selectPath, DocumentMetadataPatchBuilder.Cardinality cardinality, DocumentMetadataPatchBuilder.Call call) {
        if (!DocumentMetadataPatchBuilderImpl.CallImpl.class.isAssignableFrom(call.getClass())) {
            throw new IllegalArgumentException("Cannot use external call implementation");
        }
        this.onContent();
        this.operations.add(new ContentReplaceApplyOperation(selectPath, cardinality, (DocumentMetadataPatchBuilderImpl.CallImpl)call));
        return this;
    }

    private void onContent() {
        if (!this.onContent) {
            this.onContent = true;
        }
    }

    @Override
    public DocumentPatchBuilder pathLanguage(DocumentPatchBuilder.PathLanguage pathLang) {
        this.pathLang = pathLang;
        return this;
    }

    static class ContentReplaceApplyOperation
    extends DocumentMetadataPatchBuilderImpl.PatchOperation {
        String selectPath;
        DocumentMetadataPatchBuilder.Cardinality cardinality;
        DocumentMetadataPatchBuilderImpl.CallImpl call;

        ContentReplaceApplyOperation(String selectPath, DocumentMetadataPatchBuilder.Cardinality cardinality, DocumentMetadataPatchBuilderImpl.CallImpl call) {
            this.selectPath = selectPath;
            this.cardinality = cardinality;
            this.call = call;
        }

        @Override
        public void write(JSONStringWriter serializer) {
            this.writeReplaceApply(serializer, this.selectPath, this.cardinality, this.call);
        }

        @Override
        public void write(DocumentMetadataPatchBuilderImpl.XMLOutputSerializer out) throws Exception {
            this.writeReplaceApply(out, this.selectPath, this.cardinality, this.call);
        }
    }

    static class ContentReplaceInsertOperation
    extends DocumentMetadataPatchBuilderImpl.PatchOperation {
        String selectPath;
        String contextPath;
        DocumentPatchBuilder.Position position;
        DocumentMetadataPatchBuilder.Cardinality cardinality;
        String fragment;

        ContentReplaceInsertOperation(String selectPath, String contextPath, DocumentPatchBuilder.Position position, DocumentMetadataPatchBuilder.Cardinality cardinality, Object fragment) {
            this.selectPath = selectPath;
            this.contextPath = contextPath;
            this.position = position;
            this.cardinality = cardinality;
            this.fragment = fragment instanceof String ? (String)fragment : fragment.toString();
        }

        @Override
        public void write(JSONStringWriter serializer) {
            this.writeStartReplaceInsert(serializer, this.selectPath, this.contextPath, this.position.toString(), this.cardinality);
            serializer.writeStartEntry("content");
            serializer.writeFragment(this.fragment);
            serializer.writeEndObject();
            serializer.writeEndObject();
        }

        @Override
        public void write(DocumentMetadataPatchBuilderImpl.XMLOutputSerializer out) throws Exception {
            XMLStreamWriter serializer = out.getSerializer();
            this.writeStartReplaceInsert(out, this.selectPath, this.contextPath, this.position.toString(), this.cardinality);
            serializer.writeCharacters("");
            out.getWriter().write(this.fragment);
            serializer.writeEndElement();
        }
    }

    static class ContentReplaceOperation
    extends DocumentMetadataPatchBuilderImpl.PatchOperation {
        String selectPath;
        DocumentMetadataPatchBuilder.Cardinality cardinality;
        boolean isFragment = true;
        Object input;
        String inputAsString;

        ContentReplaceOperation(String selectPath, DocumentMetadataPatchBuilder.Cardinality cardinality, boolean isFragment, Object input) {
            this.selectPath = selectPath;
            this.cardinality = cardinality;
            this.isFragment = isFragment;
            this.input = input;
            this.inputAsString = null;
            if (input != null) {
                this.inputAsString = input instanceof String ? (String)input : input.toString();
            }
        }

        @Override
        public void write(JSONStringWriter serializer) {
            this.writeStartReplace(serializer, this.selectPath, this.cardinality);
            serializer.writeStartEntry("content");
            if (this.isFragment) {
                serializer.writeFragment(this.inputAsString);
            } else if (this.input instanceof Boolean) {
                serializer.writeBooleanValue(this.input);
            } else if (this.input instanceof Number) {
                serializer.writeNumberValue(this.input);
            } else {
                serializer.writeStringValue(this.input);
            }
            serializer.writeEndObject();
            serializer.writeEndObject();
        }

        @Override
        public void write(DocumentMetadataPatchBuilderImpl.XMLOutputSerializer out) throws Exception {
            XMLStreamWriter serializer = out.getSerializer();
            this.writeStartReplace(out, this.selectPath, this.cardinality);
            if (this.isFragment) {
                serializer.writeCharacters("");
                out.getWriter().write(this.inputAsString);
            } else {
                serializer.writeCharacters(this.inputAsString);
            }
            serializer.writeEndElement();
        }
    }

    static class ContentInsertOperation
    extends DocumentMetadataPatchBuilderImpl.PatchOperation {
        String contextPath;
        DocumentPatchBuilder.Position position;
        DocumentMetadataPatchBuilder.Cardinality cardinality;
        String fragment;

        ContentInsertOperation(String contextPath, DocumentPatchBuilder.Position position, DocumentMetadataPatchBuilder.Cardinality cardinality, Object fragment) {
            this.contextPath = contextPath;
            this.position = position;
            this.cardinality = cardinality;
            this.fragment = fragment instanceof String ? (String)fragment : fragment.toString();
        }

        @Override
        public void write(JSONStringWriter serializer) {
            this.writeStartInsert(serializer, this.contextPath, this.position.toString(), this.cardinality);
            serializer.writeStartEntry("content");
            serializer.writeFragment(this.fragment);
            serializer.writeEndObject();
            serializer.writeEndObject();
        }

        @Override
        public void write(DocumentMetadataPatchBuilderImpl.XMLOutputSerializer out) throws Exception {
            XMLStreamWriter serializer = out.getSerializer();
            this.writeStartInsert(out, this.contextPath, this.position.toString(), this.cardinality);
            serializer.writeCharacters("");
            out.getWriter().write(this.fragment);
            serializer.writeEndElement();
        }
    }

    static class ContentDeleteOperation
    extends DocumentMetadataPatchBuilderImpl.PatchOperation {
        String selectPath;
        DocumentMetadataPatchBuilder.Cardinality cardinality;

        ContentDeleteOperation(String selectPath, DocumentMetadataPatchBuilder.Cardinality cardinality) {
            this.selectPath = selectPath;
            this.cardinality = cardinality;
        }

        @Override
        public void write(JSONStringWriter serializer) {
            this.writeDelete(serializer, this.selectPath, this.cardinality);
        }

        @Override
        public void write(DocumentMetadataPatchBuilderImpl.XMLOutputSerializer out) throws Exception {
            this.writeDelete(out, this.selectPath, this.cardinality);
        }
    }
}

