/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.MarkLogicInternalException;
import com.marklogic.client.extra.httpclient.HttpClientConfigurator;
import com.marklogic.client.impl.DatabaseClientImpl;
import com.marklogic.client.impl.HandleFactoryRegistryImpl;
import com.marklogic.client.impl.JerseyServices;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.ContentHandleFactory;
import java.io.Serializable;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseClientFactory.class);
    private static ClientConfigurator<?> clientConfigurator;
    private static HandleFactoryRegistry handleRegistry;

    private DatabaseClientFactory() {
    }

    public static DatabaseClient newClient(String host, int port) {
        return DatabaseClientFactory.newClient(host, port, null, null, null, null, null, null);
    }

    public static DatabaseClient newClient(String host, int port, String database) {
        return DatabaseClientFactory.newClient(host, port, database, null, null, null, null, null);
    }

    public static DatabaseClient newClient(String host, int port, String user, String password, Authentication type) {
        return DatabaseClientFactory.newClient(host, port, null, user, password, type, null, null);
    }

    public static DatabaseClient newClient(String host, int port, String database, String user, String password, Authentication type) {
        return DatabaseClientFactory.newClient(host, port, database, user, password, type, null, null);
    }

    public static DatabaseClient newClient(String host, int port, String user, String password, Authentication type, SSLContext context) {
        return DatabaseClientFactory.newClient(host, port, null, user, password, type, context, SSLHostnameVerifier.COMMON);
    }

    public static DatabaseClient newClient(String host, int port, String database, String user, String password, Authentication type, SSLContext context) {
        return DatabaseClientFactory.newClient(host, port, database, user, password, type, context, SSLHostnameVerifier.COMMON);
    }

    public static DatabaseClient newClient(String host, int port, String user, String password, Authentication type, SSLContext context, SSLHostnameVerifier verifier) {
        DatabaseClientImpl client = DatabaseClientFactory.newClientImpl(host, port, null, user, password, type, context, verifier);
        client.setHandleRegistry(DatabaseClientFactory.getHandleRegistry().copy());
        return client;
    }

    public static DatabaseClient newClient(String host, int port, String database, String user, String password, Authentication type, SSLContext context, SSLHostnameVerifier verifier) {
        DatabaseClientImpl client = DatabaseClientFactory.newClientImpl(host, port, database, user, password, type, context, verifier);
        client.setHandleRegistry(DatabaseClientFactory.getHandleRegistry().copy());
        return client;
    }

    private static DatabaseClientImpl newClientImpl(String host, int port, String database, String user, String password, Authentication type, SSLContext context, SSLHostnameVerifier verifier) {
        logger.debug("Creating new database client for server at " + host + ":" + port);
        JerseyServices services = new JerseyServices();
        services.connect(host, port, database, user, password, type, context, verifier);
        if (clientConfigurator != null) {
            ((HttpClientConfigurator)clientConfigurator).configure(services.getClientImplementation());
        }
        return new DatabaseClientImpl(services, host, port, database, user, password, type, context, verifier);
    }

    public static HandleFactoryRegistry getHandleRegistry() {
        return handleRegistry;
    }

    public static void clearHandleRegistry() {
        handleRegistry = new HandleFactoryRegistryImpl();
    }

    public static void registerDefaultHandles() {
        HandleFactoryRegistryImpl.registerDefaults(DatabaseClientFactory.getHandleRegistry());
    }

    public static void addConfigurator(ClientConfigurator<?> configurator) {
        if (!HttpClientConfigurator.class.isInstance(configurator)) {
            throw new IllegalArgumentException("Configurator must implement HttpClientConfigurator");
        }
        clientConfigurator = configurator;
    }

    static {
        handleRegistry = HandleFactoryRegistryImpl.newDefault();
    }

    public static class Bean
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String host;
        private int port;
        private String database;
        private String user;
        private String password;
        private Authentication authentication;
        private HandleFactoryRegistry handleRegistry = HandleFactoryRegistryImpl.newDefault();
        private transient SSLContext context;
        private transient SSLHostnameVerifier verifier;

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public Authentication getAuthentication() {
            return this.authentication;
        }

        public void setAuthentication(Authentication authentication) {
            this.authentication = authentication;
        }

        public void setAuthenticationValue(String authentication) {
            this.authentication = Authentication.valueOfUncased(authentication);
        }

        public SSLContext getContext() {
            return this.context;
        }

        public void setContext(SSLContext context) {
            this.context = context;
        }

        public SSLHostnameVerifier getVerifier() {
            return this.verifier;
        }

        public void setVerifier(SSLHostnameVerifier verifier) {
            this.verifier = verifier;
        }

        public HandleFactoryRegistry getHandleRegistry() {
            return this.handleRegistry;
        }

        public void clearHandleRegistry() {
            this.handleRegistry = new HandleFactoryRegistryImpl();
        }

        public void registerDefaultHandles() {
            HandleFactoryRegistryImpl.registerDefaults(this.getHandleRegistry());
        }

        public DatabaseClient newClient() {
            DatabaseClientImpl client = DatabaseClientFactory.newClientImpl(this.host, this.port, this.database, this.user, this.password, this.authentication, this.context, this.verifier);
            client.setHandleRegistry(this.getHandleRegistry().copy());
            return client;
        }
    }

    public static interface ClientConfigurator<T> {
        public void configure(T var1);
    }

    public static interface HandleFactoryRegistry {
        public void register(ContentHandleFactory var1);

        public void register(ContentHandleFactory var1, Class<?> ... var2);

        public boolean isRegistered(Class<?> var1);

        public Set<Class<?>> listRegistered();

        public <C> ContentHandle<C> makeHandle(Class<C> var1);

        public void unregister(Class<?> ... var1);

        public HandleFactoryRegistry copy();
    }

    public static interface SSLHostnameVerifier {
        public static final Builtin ANY = new Builtin("ANY");
        public static final Builtin COMMON = new Builtin("COMMON");
        public static final Builtin STRICT = new Builtin("STRICT");

        public void verify(String var1, String[] var2, String[] var3) throws SSLException;

        public static class Builtin
        implements SSLHostnameVerifier {
            private String name;

            private Builtin(String name) {
                this.name = name;
            }

            @Override
            public void verify(String hostname, String[] cns, String[] subjectAlts) throws SSLException {
                throw new MarkLogicInternalException("SSLHostnameVerifier.Builtin called directly instead of passed as parameter");
            }

            public String getName() {
                return this.name;
            }
        }
    }

    public static enum Authentication {
        BASIC,
        DIGEST;


        public static Authentication valueOfUncased(String name) {
            return Authentication.valueOf(name.toUpperCase());
        }
    }
}

