/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.apache.http.client.methods;

import com.mathworks.apache.http.Header;
import com.mathworks.apache.http.HeaderElement;
import com.mathworks.apache.http.HeaderIterator;
import com.mathworks.apache.http.HttpResponse;
import com.mathworks.apache.http.annotation.NotThreadSafe;
import com.mathworks.apache.http.client.methods.HttpRequestBase;
import com.mathworks.apache.http.util.Args;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;

@NotThreadSafe
public class HttpOptions
extends HttpRequestBase {
    public static final String METHOD_NAME = "OPTIONS";

    public HttpOptions() {
    }

    public HttpOptions(URI uri) {
        this.setURI(uri);
    }

    public HttpOptions(String uri) {
        this.setURI(URI.create(uri));
    }

    @Override
    public String getMethod() {
        return METHOD_NAME;
    }

    public Set<String> getAllowedMethods(HttpResponse response) {
        Args.notNull(response, "HTTP response");
        HeaderIterator it = response.headerIterator("Allow");
        HashSet<String> methods = new HashSet<String>();
        while (it.hasNext()) {
            HeaderElement[] elements;
            Header header = it.nextHeader();
            for (HeaderElement element : elements = header.getElements()) {
                methods.add(element.getName());
            }
        }
        return methods;
    }
}

