/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.apache.http.client.protocol;

import com.mathworks.apache.http.Header;
import com.mathworks.apache.http.HeaderElement;
import com.mathworks.apache.http.HttpEntity;
import com.mathworks.apache.http.HttpException;
import com.mathworks.apache.http.HttpResponse;
import com.mathworks.apache.http.HttpResponseInterceptor;
import com.mathworks.apache.http.annotation.Immutable;
import com.mathworks.apache.http.client.config.RequestConfig;
import com.mathworks.apache.http.client.entity.DecompressingEntity;
import com.mathworks.apache.http.client.entity.DeflateInputStream;
import com.mathworks.apache.http.client.entity.InputStreamFactory;
import com.mathworks.apache.http.client.protocol.HttpClientContext;
import com.mathworks.apache.http.config.Lookup;
import com.mathworks.apache.http.config.RegistryBuilder;
import com.mathworks.apache.http.protocol.HttpContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.zip.GZIPInputStream;

@Immutable
public class ResponseContentEncoding
implements HttpResponseInterceptor {
    public static final String UNCOMPRESSED = "http.client.response.uncompressed";
    private static final InputStreamFactory GZIP = new InputStreamFactory(){

        @Override
        public InputStream create(InputStream instream) throws IOException {
            return new GZIPInputStream(instream);
        }
    };
    private static final InputStreamFactory DEFLATE = new InputStreamFactory(){

        @Override
        public InputStream create(InputStream instream) throws IOException {
            return new DeflateInputStream(instream);
        }
    };
    private final Lookup<InputStreamFactory> decoderRegistry;

    public ResponseContentEncoding(Lookup<InputStreamFactory> decoderRegistry) {
        this.decoderRegistry = decoderRegistry != null ? decoderRegistry : RegistryBuilder.create().register("gzip", GZIP).register("x-gzip", GZIP).register("deflate", DEFLATE).build();
    }

    public ResponseContentEncoding() {
        this(null);
    }

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Header ceheader;
        HttpEntity entity = response.getEntity();
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RequestConfig requestConfig = clientContext.getRequestConfig();
        if (requestConfig.isDecompressionEnabled() && entity != null && entity.getContentLength() != 0L && (ceheader = entity.getContentEncoding()) != null) {
            HeaderElement[] codecs;
            for (HeaderElement codec : codecs = ceheader.getElements()) {
                String codecname = codec.getName().toLowerCase(Locale.ROOT);
                InputStreamFactory decoderFactory = this.decoderRegistry.lookup(codecname);
                if (decoderFactory != null) {
                    response.setEntity(new DecompressingEntity(response.getEntity(), decoderFactory));
                    response.removeHeaders("Content-Length");
                    response.removeHeaders("Content-Encoding");
                    response.removeHeaders("Content-MD5");
                    continue;
                }
                if ("identity".equals(codecname)) continue;
                throw new HttpException("Unsupported Content-Coding: " + codec.getName());
            }
        }
    }
}

