/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.apache.http.nio.client.methods;

import com.mathworks.apache.http.HttpEntity;
import com.mathworks.apache.http.entity.ContentType;
import com.mathworks.apache.http.nio.ContentDecoder;
import com.mathworks.apache.http.nio.IOControl;
import com.mathworks.apache.http.nio.protocol.AbstractAsyncResponseConsumer;
import com.mathworks.apache.http.util.Asserts;
import java.io.IOException;
import java.nio.ByteBuffer;

public abstract class AsyncByteConsumer<T>
extends AbstractAsyncResponseConsumer<T> {
    private final ByteBuffer bbuf;

    public AsyncByteConsumer(int bufSize) {
        this.bbuf = ByteBuffer.allocate(bufSize);
    }

    public AsyncByteConsumer() {
        this(8192);
    }

    protected abstract void onByteReceived(ByteBuffer var1, IOControl var2) throws IOException;

    @Override
    protected final void onEntityEnclosed(HttpEntity entity, ContentType contentType) throws IOException {
    }

    @Override
    protected final void onContentReceived(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        Asserts.notNull(this.bbuf, "Byte buffer");
        int bytesRead = decoder.read(this.bbuf);
        if (bytesRead <= 0) {
            return;
        }
        this.bbuf.flip();
        this.onByteReceived(this.bbuf, ioctrl);
        this.bbuf.clear();
    }

    @Override
    protected void releaseResources() {
    }
}

