/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.apache.http.nio.entity;

import com.mathworks.apache.http.annotation.NotThreadSafe;
import com.mathworks.apache.http.nio.util.ContentOutputBuffer;
import com.mathworks.apache.http.util.Args;
import java.io.IOException;
import java.io.OutputStream;

@NotThreadSafe
public class ContentOutputStream
extends OutputStream {
    private final ContentOutputBuffer buffer;

    public ContentOutputStream(ContentOutputBuffer buffer) {
        Args.notNull(buffer, "Output buffer");
        this.buffer = buffer;
    }

    @Override
    public void close() throws IOException {
        this.buffer.writeCompleted();
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.buffer.write(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (b == null) {
            return;
        }
        this.buffer.write(b, 0, b.length);
    }

    @Override
    public void write(int b) throws IOException {
        this.buffer.write(b);
    }
}

