/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client;

import com.mathworks.mps.client.MATLABStackFrame;
import com.mathworks.mps.client.MWHttpClient;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;

public class MATLABException
extends Exception {
    private final String message;
    private final String identifier;
    private final List<MATLABStackFrame> matlabStack;
    private final Logger LOG = MWHttpClient.loggerFactory.getLogger(this.getClass());

    public MATLABException(String message, String identifier, List<MATLABStackFrame> stackList) {
        if (stackList == null) {
            IllegalArgumentException newex = new IllegalArgumentException("Invalid MATLAB stack value : null");
            this.LOG.error("{}", (Throwable)newex);
            throw newex;
        }
        this.message = message;
        this.identifier = identifier;
        this.matlabStack = Collections.unmodifiableList(new ArrayList<MATLABStackFrame>(stackList));
        this.LOG.error("MATLABException - identifier: {} - message: {}", (Object)identifier, (Object)message);
    }

    public List<MATLABStackFrame> getMATLABStackTrace() {
        return this.matlabStack;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public String getMATLABIdentifier() {
        return this.identifier;
    }

    public void printMATLABStackTrace() {
        this.printMATLABStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printMATLABStackTrace(PrintStream s) {
        PrintStream printStream = s;
        synchronized (printStream) {
            this.printMATLABStackTrace(new PrintWriter(s, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printMATLABStackTrace(PrintWriter s) {
        PrintWriter printWriter = s;
        synchronized (printWriter) {
            s.println(this);
            if (this.matlabStack.isEmpty()) {
                s.println("<EMPTY MATLAB STACK>");
            } else {
                for (MATLABStackFrame f : this.matlabStack) {
                    s.println(f);
                }
            }
        }
    }
}

