/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client;

import com.mathworks.mps.client.MWHttpClient;
import java.io.IOException;
import org.slf4j.Logger;

public class MWHttpException
extends IOException {
    private final int responseCode;
    private final String responseMessage;
    private final Logger LOG = MWHttpClient.loggerFactory.getLogger(this.getClass());

    public MWHttpException(int responseCode, String message) {
        if (responseCode < 400) {
            IllegalArgumentException newex = new IllegalArgumentException("Invalid HTTP response code");
            this.LOG.error("{}", (Throwable)newex);
            throw newex;
        }
        if (message.length() == 0) {
            IllegalArgumentException newex = new IllegalArgumentException("Invalid HTTP response message");
            this.LOG.error("{}", (Throwable)newex);
            throw newex;
        }
        this.responseCode = responseCode;
        this.responseMessage = message;
        this.LOG.error("MWHttpException - error code: {} - message: {}", (Object)responseCode, (Object)message);
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    @Override
    public String getMessage() {
        return "Failed HTTP request; Response Status: " + this.responseCode + ", Response Message: " + this.responseMessage;
    }
}

