/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal;

import com.mathworks.apache.http.HttpHost;
import com.mathworks.apache.http.HttpResponse;
import com.mathworks.apache.http.client.methods.CloseableHttpResponse;
import com.mathworks.apache.http.client.methods.HttpDelete;
import com.mathworks.apache.http.client.methods.HttpGet;
import com.mathworks.apache.http.client.methods.HttpPost;
import com.mathworks.apache.http.client.methods.HttpUriRequest;
import com.mathworks.apache.http.client.protocol.HttpClientContext;
import com.mathworks.apache.http.client.utils.URIBuilder;
import com.mathworks.apache.http.concurrent.FutureCallback;
import com.mathworks.apache.http.config.Registry;
import com.mathworks.apache.http.config.RegistryBuilder;
import com.mathworks.apache.http.conn.ssl.DefaultHostnameVerifier;
import com.mathworks.apache.http.entity.ByteArrayEntity;
import com.mathworks.apache.http.impl.client.CloseableHttpClient;
import com.mathworks.apache.http.impl.client.HttpClients;
import com.mathworks.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import com.mathworks.apache.http.impl.nio.client.HttpAsyncClients;
import com.mathworks.apache.http.impl.nio.conn.ManagedNHttpClientConnectionFactory;
import com.mathworks.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import com.mathworks.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import com.mathworks.apache.http.impl.nio.reactor.IOReactorConfig;
import com.mathworks.apache.http.nio.client.HttpAsyncClient;
import com.mathworks.apache.http.nio.conn.ManagedNHttpClientConnection;
import com.mathworks.apache.http.nio.conn.NHttpConnectionFactory;
import com.mathworks.apache.http.nio.conn.NoopIOSessionStrategy;
import com.mathworks.apache.http.nio.conn.SchemeIOSessionStrategy;
import com.mathworks.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import com.mathworks.apache.http.nio.reactor.ConnectingIOReactor;
import com.mathworks.apache.http.nio.reactor.IOSession;
import com.mathworks.google.protobuf.CodedInputStream;
import com.mathworks.google.protobuf.ExtensionRegistryLite;
import com.mathworks.mps.client.MWHttpClient;
import com.mathworks.mps.client.MWHttpClientConfig;
import com.mathworks.mps.client.MWSSLConfig;
import com.mathworks.mps.client.internal.AbstractHttpClient;
import com.mathworks.mps.client.internal.HTTPErrorInfo;
import com.mathworks.mps.client.internal.MATLABParams;
import com.mathworks.mps.client.internal.MATLABRequestCreated;
import com.mathworks.mps.client.internal.MATLABRequestInfo;
import com.mathworks.mps.client.internal.MATLABRequestNotification;
import com.mathworks.mps.client.internal.MATLABResult;
import com.mathworks.mps.client.internal.MWClientUsageLock;
import com.mathworks.mps.client.internal.MWInvocationHandlerUtils;
import com.mathworks.mps.client.internal.MWSSLContext;
import com.mathworks.mps.client.internal.async.CancelledMWRequestState;
import com.mathworks.mps.client.internal.async.HttpResponseCallback;
import com.mathworks.mps.client.internal.async.InQueueMWRequestState;
import com.mathworks.mps.client.internal.async.InstanceInfo;
import com.mathworks.mps.client.internal.async.MWRequestImpl;
import com.mathworks.mps.client.internal.async.MWRequestInfo;
import com.mathworks.mps.client.internal.async.OnErrorCallback;
import com.mathworks.mps.client.internal.async.ProcessingMWRequestState;
import com.mathworks.mps.client.internal.async.RequestNotificationsCallback;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.slf4j.Logger;

public class ApacheHttpClient
extends AbstractHttpClient {
    private final CloseableHttpAsyncClient httpClientAsync;
    private final CloseableHttpClient httpClient;
    private final int responseSizeLimit;
    private final MWHttpClient mwClient;
    private MWClientUsageLock clientUsageLock;
    private Thread backupGETThread;
    private final Logger LOG;
    private final Object lock = new Object();
    public ConcurrentHashMap<UUID, InstanceInfo> instances = new ConcurrentHashMap();
    public ConcurrentHashMap<String, ConcurrentHashMap<String, MWRequestImpl>> requestsCreated = new ConcurrentHashMap();
    public ConcurrentHashMap<String, MATLABRequestInfo.MATLAB_Request_Info> pendingNotifications = new ConcurrentHashMap();
    public ConcurrentHashMap<UUID, MWRequestImpl> pendingRequests = new ConcurrentHashMap();

    public ApacheHttpClient(MWHttpClientConfig clientConfig, final MWSSLConfig sslConfig, MWHttpClient mwClient) {
        super(clientConfig.getResponseSizeLimit());
        this.LOG = MWHttpClient.loggerFactory.getLogger(this.getClass());
        this.responseSizeLimit = clientConfig.getResponseSizeLimit();
        this.mwClient = mwClient;
        try {
            SSLContext sslContext = sslConfig.getSSLContext() == null ? MWSSLContext.getDefault() : sslConfig.getSSLContext();
            HostnameVerifier hostnameVerifier = sslConfig.getHostnameVerifier();
            SSLIOSessionStrategy sslsf = new SSLIOSessionStrategy(sslContext, hostnameVerifier){

                @Override
                protected void verifySession(HttpHost host, IOSession iosession, SSLSession sslsession) throws SSLException {
                    ApacheHttpClient.this.verifySSLSession(iosession, sslsession, sslConfig);
                }
            };
            Registry<SchemeIOSessionStrategy> sessionStrategyRegistry = RegistryBuilder.create().register("http", NoopIOSessionStrategy.INSTANCE).register("https", (NoopIOSessionStrategy)((Object)sslsf)).build();
            IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setConnectTimeout((int)clientConfig.getTimeOutMs()).setSoTimeout((int)clientConfig.getTimeOutMs()).setTcpNoDelay(false).build();
            DefaultConnectingIOReactor ioReactor = new DefaultConnectingIOReactor(ioReactorConfig);
            ManagedNHttpClientConnectionFactory connFactory = new ManagedNHttpClientConnectionFactory();
            PoolingNHttpClientConnectionManager connManager = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)ioReactor, (NHttpConnectionFactory<ManagedNHttpClientConnection>)connFactory, sessionStrategyRegistry);
            connManager.setDefaultMaxPerRoute(clientConfig.getMaxConnectionsPerAddress());
            this.httpClientAsync = HttpAsyncClients.custom().setUserAgent(ApacheHttpClient.class.getName()).setConnectionManager(connManager).setSSLContext(sslContext).setSSLHostnameVerifier(hostnameVerifier).setSSLStrategy(sslsf).build();
            this.httpClientAsync.start();
            this.httpClient = HttpClients.custom().setUserAgent(ApacheHttpClient.class.getName()).setSslcontext(sslContext).setSSLHostnameVerifier(hostnameVerifier).build();
        }
        catch (Exception ex) {
            throw new RuntimeException("Trouble initializing MWHttpClient", ex);
        }
    }

    private void verifySSLSession(IOSession iosession, SSLSession sslsession, MWSSLConfig sslConfig) throws SSLException {
        block3: {
            InetSocketAddress address = (InetSocketAddress)iosession.getRemoteAddress();
            try {
                Certificate[] certs = sslsession.getPeerCertificates();
                if (certs.length <= 0 || !(certs[0] instanceof X509Certificate)) {
                    throw new SSLPeerUnverifiedException("No X509 certificate provided by the peer");
                }
                X509Certificate x509 = (X509Certificate)certs[0];
                DefaultHostnameVerifier defaultHostnameVerifier = new DefaultHostnameVerifier();
                defaultHostnameVerifier.verify(address.getHostName(), x509);
            }
            catch (SSLException ex) {
                HostnameVerifier hostnameVerifier = sslConfig.getHostnameVerifier();
                if (hostnameVerifier != null && hostnameVerifier.verify(address.getHostName(), sslsession)) break block3;
                throw ex;
            }
        }
        MWInvocationHandlerUtils.throwIfServerIsNotAuthorized(sslsession.getPeerCertificates(), sslConfig);
    }

    public HttpAsyncClient getHttpClientAsync() {
        return this.httpClientAsync;
    }

    public int getResponseSizeLimit() {
        return this.responseSizeLimit;
    }

    public MWHttpClient getMWClient() {
        return this.mwClient;
    }

    public MWClientUsageLock getClientUsageLock() {
        return this.clientUsageLock;
    }

    public void setClientUsageLock(MWClientUsageLock clientUsageLock) {
        this.clientUsageLock = clientUsageLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void executePost(HttpPost postReq, MATLABParams.MATLAB_Params mlParams, HttpClientContext context, HttpResponseCallback<T> callback) {
        postReq.addHeader("Content-Type", "application/x-google-protobuf");
        if (mlParams != null) {
            postReq.setEntity(new ByteArrayEntity(mlParams.toByteArray()));
        }
        try {
            this.LOG.info("MATLAB execution request: {}", (Object)postReq);
            try (CloseableHttpResponse postResponse = this.httpClient.execute((HttpUriRequest)postReq, context);){
                callback.completed(postResponse);
            }
        }
        catch (Exception ex) {
            callback.failed(ex);
        }
    }

    public <T> void executePostCancel(HttpPost postReq, MATLABParams.MATLAB_Params mlParams, HttpClientContext context, HttpResponseCallback<T> callback) {
        this.LOG.trace("Execute POST cancel - {}", (Object)postReq);
        this.LOG.trace("HTTP context - {}", (Object)context);
        postReq.addHeader("Content-Type", "application/x-google-protobuf");
        if (mlParams != null) {
            postReq.setEntity(new ByteArrayEntity(mlParams.toByteArray()));
        }
        this.httpClientAsync.execute(postReq, context, callback);
    }

    public void executeGet(HttpGet getReq, HttpClientContext context, FutureCallback<HttpResponse> callback) {
        this.clientUsageLock.usageEnter(null);
        this.httpClientAsync.execute(getReq, context, callback);
    }

    public Future<HttpResponse> executeGetSync(URI uri, HttpClientContext context) throws URISyntaxException {
        HttpGet getReq = new HttpGet(uri.toString());
        return this.httpClientAsync.execute(getReq, context, null);
    }

    public void executeDelete(String deleteUrl, HttpClientContext context) {
        HttpDelete deleteReq = new HttpDelete(deleteUrl);
        this.LOG.trace("Execute DELETE - {}", (Object)deleteReq);
        this.LOG.trace("HTTP context - {}", (Object)context);
        deleteReq.addHeader("Content-Type", "application/x-google-protobuf");
        this.httpClientAsync.execute(deleteReq, context, null);
    }

    public void executeGetForNotifications(InstanceInfo currentInstance) throws URISyntaxException {
        URI updatesSinceUri = this.buildGetUpdatesSinceUri(currentInstance);
        HttpGet getNotifications = new HttpGet(updatesSinceUri.toString());
        getNotifications.setHeader("X-MPS-Start-Time", currentInstance.getSessionId());
        currentInstance.httpGet = getNotifications;
        try {
            this.LOG.debug("Server state update request: {}", (Object)getNotifications);
            this.executeGet(getNotifications, currentInstance.getHttpContext(), currentInstance.getNotificationCallback());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        currentInstance.notificationRecent.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void updateRequest(String requestUrl, MATLABRequestInfo.MATLAB_Request_Info serverRequestInfo, String mpsSessionId) {
        try {
            MATLABRequestInfo.MATLAB_Request_Info.State state = serverRequestInfo.getState();
            MWRequestImpl request = this.requestsCreated.get(mpsSessionId).get(requestUrl);
            if (request == null) {
                this.pendingNotifications.put(requestUrl, serverRequestInfo);
                request = this.requestsCreated.get(mpsSessionId).get(requestUrl);
                if (request == null) {
                    return;
                }
                serverRequestInfo = this.pendingNotifications.remove(requestUrl);
                if (serverRequestInfo == null) {
                    return;
                }
            }
            String serverUri = request.getClientRequestInfo().getInstance().getServerUri();
            HttpClientContext context = request.getClientRequestInfo().getInstance().getHttpContext();
            MWRequestInfo clientRequestInfo = request.getClientRequestInfo();
            switch (state) {
                case READING_STATE: {
                    request.markCreated();
                    break;
                }
                case IN_QUEUE_STATE: {
                    request.updateStateAndNotify(new InQueueMWRequestState(serverRequestInfo.getLastModified(), new URL(serverUri + requestUrl), clientRequestInfo));
                    break;
                }
                case PROCESSING_STATE: {
                    request.updateStateAndNotify(new ProcessingMWRequestState(serverRequestInfo.getLastModified(), new URL(serverUri + requestUrl), clientRequestInfo));
                    break;
                }
                case READY_STATE: {
                    URI httpGetResponse = this.buildGetResultUri(serverUri, requestUrl);
                    HttpGet getResponse = new HttpGet(httpGetResponse.toString());
                    Object object = request.lock;
                    synchronized (object) {
                        if (request.httpGetResponse != null) {
                            break;
                        }
                        try {
                            this.LOG.debug("MATLAB result request: {}", (Object)getResponse);
                            this.executeGet(getResponse, context, new HttpResponseCallback(serverUri, request, this, context));
                        }
                        catch (IllegalStateException ex) {
                            break;
                        }
                        request.markReadingResponse(getResponse);
                        break;
                    }
                }
                case ERROR_STATE: {
                    URI httpGetError = this.buildGetResultUri(serverUri, requestUrl);
                    HttpGet getError = new HttpGet(httpGetError.toString());
                    Object object = request.lock;
                    synchronized (object) {
                        if (request.httpGetError != null) {
                            break;
                        }
                        try {
                            this.executeGet(getError, context, new OnErrorCallback(request, this));
                        }
                        catch (IllegalStateException e) {
                            break;
                        }
                        request.markReadingError(getError);
                        break;
                    }
                }
                case CANCELLED_STATE: {
                    request.updateStateAndNotify(new CancelledMWRequestState());
                    this.requestsCreated.remove(request.getClientRequestInfo().getRequestUrl());
                    break;
                }
                case DELETED_STATE: {
                    break;
                }
                case UNKNOWN_STATE: {
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void registerRequest(MWRequestImpl<T> request, UUID uuid, String serverUri, String mps_session_id, HttpClientContext context) throws URISyntaxException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.instances.containsKey(uuid)) {
                this.instances.put(uuid, new InstanceInfo(uuid, serverUri, -1, mps_session_id, context));
            }
            if (!this.requestsCreated.containsKey(mps_session_id)) {
                this.requestsCreated.put(mps_session_id, new ConcurrentHashMap());
            }
        }
        InstanceInfo currentInstance = this.instances.get(uuid);
        currentInstance.getWaitNotifier().cancel();
        MWRequestInfo<T> clientRequestInfo = request.getClientRequestInfo();
        clientRequestInfo.setInstance(currentInstance);
        this.requestsCreated.get(mps_session_id).put(clientRequestInfo.getRequestUrl(), request);
        this.LOG.debug("Request URI created by server: {}", (Object)request.getRequestURL());
        this.LOG.trace("Information of server processing the request: {}", (Object)currentInstance);
        Object object2 = currentInstance.lock;
        synchronized (object2) {
            if (!currentInstance.isNotificationRunning()) {
                RequestNotificationsCallback callback = new RequestNotificationsCallback(currentInstance, this);
                currentInstance.setNotificationRunningTrue(callback);
                this.executeGetForNotifications(currentInstance);
            }
        }
    }

    public URI buildGetResultUri(String serverUri, String requestUrl) throws URISyntaxException {
        URIBuilder builder = new URIBuilder(serverUri + requestUrl + "/result");
        builder.addParameter("format", "protobuf");
        return builder.build();
    }

    public URI buildGetUpdatesSinceUri(InstanceInfo instance) throws URISyntaxException {
        URIBuilder builder = new URIBuilder(instance.getLocation());
        builder.setPath(builder.getPath() + "requests");
        builder.addParameter("since", Long.toString(instance.getCurrentSeq() + 1L));
        builder.addParameter("format", "protobuf");
        builder.addParameter("clients", this.mwClient.getClientUUID().toString());
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MATLABResult.MATLAB_Result parseMATLABResult(HttpResponse response) throws IOException {
        try (InputStream iStream = response.getEntity().getContent();){
            CodedInputStream iStreamCoded = CodedInputStream.newInstance(iStream);
            iStreamCoded.setSizeLimit(this.responseSizeLimit);
            MATLABResult.MATLAB_Result mATLAB_Result = MATLABResult.MATLAB_Result.parseFrom(iStreamCoded, (ExtensionRegistryLite)MWInvocationHandlerUtils.extRegistry);
            return mATLAB_Result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MATLABRequestCreated.MATLAB_Request_Created parseMATLABRequest(HttpResponse response) throws IOException {
        try (InputStream iStream = response.getEntity().getContent();){
            CodedInputStream iStreamCoded = CodedInputStream.newInstance(iStream);
            iStreamCoded.setSizeLimit(this.responseSizeLimit);
            MATLABRequestCreated.MATLAB_Request_Created mATLAB_Request_Created = MATLABRequestCreated.MATLAB_Request_Created.parseFrom(iStreamCoded);
            return mATLAB_Request_Created;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MATLABRequestNotification.MATLAB_Request_Notification parseRequestNotification(HttpResponse response) throws IOException {
        try (InputStream iStream = response.getEntity().getContent();){
            CodedInputStream iStreamCoded = CodedInputStream.newInstance(iStream);
            iStreamCoded.setSizeLimit(this.responseSizeLimit);
            MATLABRequestNotification.MATLAB_Request_Notification mATLAB_Request_Notification = MATLABRequestNotification.MATLAB_Request_Notification.parseFrom(iStreamCoded);
            return mATLAB_Request_Notification;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPErrorInfo.HTTP_Error_Info parseHttpErrorInfo(HttpResponse response) throws IOException {
        try (InputStream iStream = response.getEntity().getContent();){
            CodedInputStream iStreamCoded = CodedInputStream.newInstance(iStream);
            iStreamCoded.setSizeLimit(this.responseSizeLimit);
            HTTPErrorInfo.HTTP_Error_Info hTTP_Error_Info = HTTPErrorInfo.HTTP_Error_Info.parseFrom(iStreamCoded);
            return hTTP_Error_Info;
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            super.close();
            try {
                new ShutdownApache().start();
            }
            catch (Exception ex) {
                throw new RuntimeException("Trouble closing MWHttpClient", ex);
            }
        }
    }

    private class ShutdownApache
    extends Thread {
        private ShutdownApache() {
        }

        @Override
        public void run() {
            try {
                ApacheHttpClient.this.httpClientAsync.close();
                ApacheHttpClient.this.httpClient.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

