/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.apache.http.impl.conn;

import com.mathworks.apache.http.HttpResponse;
import com.mathworks.apache.http.HttpResponseFactory;
import com.mathworks.apache.http.annotation.Immutable;
import com.mathworks.apache.http.config.MessageConstraints;
import com.mathworks.apache.http.impl.DefaultHttpResponseFactory;
import com.mathworks.apache.http.impl.conn.DefaultHttpResponseParser;
import com.mathworks.apache.http.io.HttpMessageParser;
import com.mathworks.apache.http.io.HttpMessageParserFactory;
import com.mathworks.apache.http.io.SessionInputBuffer;
import com.mathworks.apache.http.message.BasicLineParser;
import com.mathworks.apache.http.message.LineParser;

@Immutable
public class DefaultHttpResponseParserFactory
implements HttpMessageParserFactory<HttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final LineParser lineParser;
    private final HttpResponseFactory responseFactory;

    public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory responseFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParserFactory(HttpResponseFactory responseFactory) {
        this(null, responseFactory);
    }

    public DefaultHttpResponseParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpResponse> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpResponseParser(buffer, this.lineParser, this.responseFactory, constraints);
    }
}

