/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client;

import com.mathworks.mps.client.MWClient;
import com.mathworks.mps.client.MWDefaultMarshalingRules;
import com.mathworks.mps.client.MWHttpClientConfig;
import com.mathworks.mps.client.MWHttpClientDefaultConfig;
import com.mathworks.mps.client.MWInvokable;
import com.mathworks.mps.client.MWMarshalingRules;
import com.mathworks.mps.client.MWSSLConfig;
import com.mathworks.mps.client.MWSSLDefaultConfig;
import com.mathworks.mps.client.internal.ApacheFevalHandler;
import com.mathworks.mps.client.internal.ApacheHttpClient;
import com.mathworks.mps.client.internal.ComponentProxy;
import com.mathworks.mps.client.internal.IdentifyDispatcher;
import com.mathworks.mps.client.internal.InterfaceValidator;
import com.mathworks.mps.client.internal.MWClientInvocationHandler;
import com.mathworks.mps.client.internal.MWClientUsageLock;
import com.mathworks.mps.client.internal.MWFevalHandler;
import com.mathworks.mps.client.internal.MWLoggerFactory;
import com.mathworks.mps.client.internal.SunHttpClientFevalHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.UUID;
import org.slf4j.Logger;

public class MWHttpClient
implements MWClient {
    private final MWFevalHandler fevalHandler;
    private final MWHttpClientConfig clientConfig;
    private final MWSSLConfig sslConfig;
    private MWClientUsageLock clientUsagelock;
    private final UUID uuid;
    public static MWLoggerFactory loggerFactory;
    private Logger LOG;

    public MWHttpClient() {
        this(new MWHttpClientDefaultConfig(), new MWSSLDefaultConfig());
    }

    public MWHttpClient(MWHttpClientConfig config) {
        this(config, new MWSSLDefaultConfig());
    }

    public MWHttpClient(MWSSLConfig sslConfig) {
        this(new MWHttpClientDefaultConfig(), sslConfig);
    }

    public MWHttpClient(MWHttpClientConfig config, MWSSLConfig sslConfig) {
        loggerFactory = new MWLoggerFactory();
        this.LOG = loggerFactory.getLogger(this.getClass());
        this.validateMWHttpClientConfig(config);
        if (null == sslConfig) {
            throw new IllegalArgumentException("Invalid value for the MWSSLConfig configuration : null");
        }
        this.clientConfig = config;
        Object maxConnectionsPerAddress = this.clientConfig.getMaxConnectionsPerAddress();
        if (this.clientConfig.getMaxConnectionsPerAddress() < 0) {
            maxConnectionsPerAddress = "unlimited";
        }
        this.LOG.info("Client configuration - Maximum connections per address: {} ", maxConnectionsPerAddress);
        this.LOG.info("Client configuration - Server response timeout (ms): {}", (Object)this.clientConfig.getTimeOutMs());
        this.LOG.info("Client configuration - Is interruptible: {}", (Object)this.clientConfig.isInterruptible());
        this.LOG.info("Client configuration - Response size limit (bytes): {}", (Object)this.clientConfig.getResponseSizeLimit());
        this.LOG.info("Client configuration - Cookies enabled: {}", (Object)this.clientConfig.isCookieEnabled());
        this.LOG.info("Client configuration - Poll on update error (async): {}", (Object)this.clientConfig.pollOnUpdateErrorAsync());
        this.sslConfig = sslConfig;
        this.uuid = UUID.randomUUID();
        if (this.clientConfig.isInterruptible()) {
            ApacheHttpClient apacheClient = new ApacheHttpClient(this.clientConfig, sslConfig, this);
            this.fevalHandler = new ApacheFevalHandler(apacheClient);
            this.clientUsagelock = new MWClientUsageLock(this.fevalHandler);
            apacheClient.setClientUsageLock(this.clientUsagelock);
        } else {
            this.fevalHandler = new SunHttpClientFevalHandler(this.clientConfig, sslConfig);
            this.clientUsagelock = new MWClientUsageLock(this.fevalHandler);
        }
        this.LOG.info("Client initialized with UUID: {}", (Object)this.uuid);
    }

    public MWHttpClientConfig getConfig() {
        return this.clientConfig;
    }

    public MWSSLConfig getSSLConfig() {
        return this.sslConfig;
    }

    public UUID getClientUUID() {
        return this.uuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T createProxy(URL url, Class<T> mwComponent) {
        this.clientUsagelock.usageEnter("This instance of MWHttpClient is in the closed state.\nOnce closed, an instance of MWHttpClient cannot be used to create a proxy instance.\nYou will have to create a new instance of MWHttpClient.");
        try {
            InterfaceValidator.validateInterface(mwComponent);
            Object object = Proxy.newProxyInstance(mwComponent.getClassLoader(), new Class[]{mwComponent}, (InvocationHandler)new MWClientInvocationHandler(IdentifyDispatcher.buildMethodToDispatcherMap(url, mwComponent, this)));
            return (T)object;
        }
        finally {
            this.clientUsagelock.usageExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MWInvokable createComponentProxy(URL url, MWMarshalingRules marshalingRules) {
        this.clientUsagelock.usageEnter("This instance of MWHttpClient is in the closed state.\nOnce closed, an instance of MWHttpClient cannot be used to create a proxy instance.\nYou will have to create a new instance of MWHttpClient.");
        try {
            ComponentProxy componentProxy = new ComponentProxy(this.fevalHandler, url, marshalingRules, this.clientUsagelock, this);
            return componentProxy;
        }
        finally {
            this.clientUsagelock.usageExit();
        }
    }

    @Override
    public MWInvokable createComponentProxy(URL url) {
        this.clientUsagelock.usageEnter("This instance of MWHttpClient is in the closed state.\nOnce closed, an instance of MWHttpClient cannot be used to create a proxy instance.\nYou will have to create a new instance of MWHttpClient.");
        try {
            ComponentProxy componentProxy = new ComponentProxy(this.fevalHandler, url, new MWDefaultMarshalingRules(), this.clientUsagelock, this);
            return componentProxy;
        }
        finally {
            this.clientUsagelock.usageExit();
        }
    }

    @Override
    public void close() {
        this.LOG.info("Closing client - UUID: {}", (Object)this.uuid);
        this.clientUsagelock.attemptToClose();
    }

    private void validateMWHttpClientConfig(MWHttpClientConfig config) {
        if (null == config) {
            throw new IllegalArgumentException("Invalid value for the MWHttpClient configuration : null");
        }
        if (config.getTimeOutMs() <= 0L) {
            throw new IllegalArgumentException("Timeout for the MWHttpClient configuration must be greater than 0");
        }
        if (config.getMaxConnectionsPerAddress() <= 0 && config.isInterruptible()) {
            throw new IllegalArgumentException("Maximum number of connections per address for the MWHttpClient configuration must be greater than 0 for interruptible MWHttpClient configuration");
        }
        if (!config.isInterruptible() && config.getMaxConnectionsPerAddress() != -1) {
            throw new IllegalArgumentException("Currently, only interruptible MWHttpClient configuration supports maximum connections per address property.\nFor non-interruptible MWHttpClient configurations, please return -1 to indicate unsupported property.");
        }
    }

    @Override
    public String getID() {
        return this.uuid.toString();
    }
}

