/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class MWResourceClassLoader
extends ClassLoader {
    private final Map<String, byte[]> classDataCache = new HashMap<String, byte[]>();
    private final List<String> parentFirst = new ArrayList<String>();

    public MWResourceClassLoader(List<String> repo, ClassLoader parent) throws IOException {
        super(parent);
        if (repo == null) {
            return;
        }
        for (int i = 0; i < repo.size(); ++i) {
            String element = repo.get(i);
            if (element.startsWith("/")) {
                this.processJar(element);
                continue;
            }
            if (element.endsWith(".jar")) {
                int slashindex = element.lastIndexOf("/");
                if (slashindex > 0) {
                    element = element.substring(slashindex);
                }
                element = "/resources/" + element;
                this.processJar(element);
                continue;
            }
            if (element.startsWith("-")) {
                this.parentFirst.add(element.substring(1));
                continue;
            }
            this.processClass(element);
        }
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> result = null;
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            result = this.findLoadedClass(name);
            if (result != null) {
                return result;
            }
            if (this.parentFirst.contains(name) && (result = super.loadClass(name, resolve)) != null) {
                return result;
            }
            result = this.findClass(name);
            if (result != null) {
                return result;
            }
            result = super.loadClass(name, resolve);
            if (result != null) {
                return result;
            }
            throw new ClassNotFoundException(name);
        }
    }

    public Class findClass(String name) throws ClassNotFoundException {
        if (this.classDataCache.containsKey(name)) {
            byte[] classData = this.classDataCache.get(name);
            Class<?> result = this.defineClass(name, classData, 0, classData.length, this.getClass().getProtectionDomain());
            return result;
        }
        return null;
    }

    private String pathToClassName(String path) {
        String dirurl = path.replaceAll("/+", "/");
        if (dirurl.startsWith("/")) {
            return dirurl.substring(1, dirurl.lastIndexOf(".class")).replace("/", ".");
        }
        return dirurl.substring(0, dirurl.lastIndexOf(".class")).replace("/", ".");
    }

    private String classNameToDirURL(String className) {
        return "/" + className.replace(".", "/") + ".class";
    }

    private void processClass(String name) throws IOException {
        InputStream fstream = this.getClass().getResourceAsStream(this.classNameToDirURL(name));
        this.classDataCache.put(name, this.classToByteArray(fstream));
    }

    private void processJar(String name) throws IOException {
        JarInputStream streamJar = new JarInputStream(this.getClass().getResourceAsStream(name));
        this.prepareJarData(streamJar);
    }

    private void prepareJarData(JarInputStream streamJar) throws IOException {
        JarEntry elementJar;
        while ((elementJar = streamJar.getNextJarEntry()) != null) {
            if (!elementJar.getName().endsWith(".class")) continue;
            String className = this.pathToClassName(elementJar.getName());
            this.classDataCache.put(className, this.classToByteArray(streamJar));
        }
    }

    private byte[] classToByteArray(InputStream istream) throws IOException {
        int len;
        byte[] buff = new byte[4096];
        ByteArrayOutputStream streamOut = new ByteArrayOutputStream();
        while ((len = istream.read(buff)) > 0) {
            streamOut.write(buff, 0, len);
        }
        streamOut.close();
        return streamOut.toByteArray();
    }
}

