/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal;

import com.mathworks.mps.client.internal.MWStructInfo;
import com.mathworks.mps.client.internal.MWStructToBeanFactory;
import com.mathworks.mps.client.internal.MWStructToBeanFactoryConstructor;
import com.mathworks.mps.client.internal.MWStructToBeanFactorySetter;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MWStructToBeanFactoryMaker {
    private static Class constructorPropertiesClass;
    private static Method constructorPropertiesValue;

    public static List<MWStructToBeanFactory> createFactoryList(Class cls) {
        ArrayList<MWStructToBeanFactory> factoryList = new ArrayList<MWStructToBeanFactory>();
        HashMap<String, Class> beanTypeMap = new HashMap<String, Class>();
        HashMap<String, Method> beanSetterMap = new HashMap<String, Method>();
        if (MWStructToBeanFactoryMaker.isStructConvertibleUsingSetters(cls, beanTypeMap, beanSetterMap)) {
            List<String> fieldNames = Arrays.asList(beanSetterMap.keySet().toArray(new String[beanSetterMap.keySet().size()]));
            factoryList.add(new MWStructToBeanFactorySetter(cls, fieldNames, beanTypeMap, beanSetterMap));
        } else {
            List<Constructor> constrList = MWStructToBeanFactoryMaker.getConstructorsWithValidConstructorPropertiesAnnotation(cls);
            ArrayList<MWStructInfo> structInfoList = new ArrayList<MWStructInfo>();
            for (Constructor constructor : constrList) {
                Map<String, Class> map = MWStructToBeanFactoryMaker.getAnnotationNamesToConstrArgumentTypesMap(constructor);
                List<String> fieldNames = Arrays.asList(map.keySet().toArray(new String[map.keySet().size()]));
                MWStructInfo structInfo = new MWStructInfo(fieldNames);
                if (structInfoList.contains(structInfo)) {
                    throw new IllegalArgumentException("Found a Java type : " + cls.getName() + ", with more than one constructors with same values for ConstructorProperties annotation.\nThis is an error because this type can be used as a target type for a MATLAB structure and cause ambiguity\nwhile marshaling the output from MATLAB.");
                }
                structInfoList.add(structInfo);
                factoryList.add(new MWStructToBeanFactoryConstructor(cls, fieldNames, map, constructor));
            }
        }
        return factoryList;
    }

    private static boolean isStructConvertibleUsingSetters(Class userClass, Map<String, Class> beanTypeMap, Map<String, Method> beanSetterMap) {
        if (MWStructToBeanFactoryMaker.hasDefaultConstructor(userClass)) {
            try {
                BeanInfo bInfo = Introspector.getBeanInfo(userClass, Object.class);
                PropertyDescriptor[] pDesc = bInfo.getPropertyDescriptors();
                if (pDesc == null || pDesc.length == 0) {
                    return false;
                }
                for (PropertyDescriptor p : pDesc) {
                    String dispName = p.getDisplayName();
                    Method setter = p.getWriteMethod();
                    if (setter == null) continue;
                    beanSetterMap.put(dispName, setter);
                    beanTypeMap.put(dispName, p.getPropertyType());
                }
                return beanSetterMap.size() > 0;
            }
            catch (IntrospectionException ex) {
                return false;
            }
        }
        return false;
    }

    private static boolean hasDefaultConstructor(Class userClass) {
        try {
            userClass.getConstructor(new Class[0]);
            return true;
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
    }

    private static Map<String, Class> getAnnotationNamesToConstrArgumentTypesMap(Constructor constr) {
        HashMap<String, Class> map = new HashMap<String, Class>();
        String[] properties = MWStructToBeanFactoryMaker.getConstructorProperties(constr);
        Class<?>[] paramTypes = constr.getParameterTypes();
        for (int i = 0; i < properties.length; ++i) {
            map.put(properties[i], paramTypes[i]);
        }
        return map;
    }

    private static List<Constructor> getConstructorsWithValidConstructorPropertiesAnnotation(Class cls) {
        Constructor<?>[] constructors;
        ArrayList<Constructor> constrList = new ArrayList<Constructor>();
        for (Constructor<?> constructor : constructors = cls.getConstructors()) {
            String[] properties = MWStructToBeanFactoryMaker.getConstructorProperties(constructor);
            if (properties == null) continue;
            Class<?>[] paramTypes = constructor.getParameterTypes();
            if (properties.length <= 0 || paramTypes.length != properties.length) continue;
            constrList.add(constructor);
        }
        return constrList;
    }

    static String[] getConstructorProperties(Constructor constructor) {
        Object annotation;
        if (constructorPropertiesClass != null && (annotation = constructor.getAnnotation(constructorPropertiesClass)) != null) {
            try {
                String[] properties = (String[])constructorPropertiesValue.invoke(annotation, new Object[0]);
                return properties;
            }
            catch (InvocationTargetException t) {
                throw new RuntimeException(t.getCause());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return null;
    }

    static {
        try {
            constructorPropertiesClass = Class.forName("java.beans.ConstructorProperties");
            constructorPropertiesValue = constructorPropertiesClass.getMethod("value", new Class[0]);
        }
        catch (ClassNotFoundException c) {
            constructorPropertiesClass = null;
            constructorPropertiesValue = null;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

