/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.rest;

import com.mathworks.google.protobuf.CodedInputStream;
import com.mathworks.google.protobuf.ExtensionRegistry;
import com.mathworks.google.protobuf.ExtensionRegistryLite;
import com.mathworks.mps.client.MATLABException;
import com.mathworks.mps.client.internal.JavaDataExtractor;
import com.mathworks.mps.client.internal.MATLABArray;
import com.mathworks.mps.client.internal.MATLABError;
import com.mathworks.mps.client.internal.MATLABResult;
import com.mathworks.mps.client.internal.MWAttributesContainer;
import com.mathworks.mps.client.internal.MWInvocationHandlerUtils;
import com.mathworks.mps.client.rest.MATLABParams;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class MATLABResult<T> {
    private MWAttributesContainer mwAttributesContainer;
    private MATLABResult.MATLAB_Result mlResult;
    private int nargout;
    private boolean hasNargout;
    private Class targetType;

    public static MATLABResult newInstance(MATLABParams matlabParams, InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("Input stream is null");
        }
        if (matlabParams == null) {
            throw new IllegalArgumentException("MATLAB Params object is required");
        }
        MATLABResult matlabResult = new MATLABResult();
        CodedInputStream iStreamCoded = CodedInputStream.newInstance(inputStream);
        ExtensionRegistry extensionRegistry = ExtensionRegistry.newInstance();
        MATLABArray.registerAllExtensions(extensionRegistry);
        matlabResult.mwAttributesContainer = new MWAttributesContainer(matlabParams.getMwMarshalingRules());
        matlabResult.nargout = matlabParams.getNargout();
        matlabResult.targetType = matlabParams.getTargetType();
        matlabResult.hasNargout = matlabResult.nargout > 1;
        try {
            matlabResult.mlResult = MATLABResult.MATLAB_Result.parseFrom(iStreamCoded, (ExtensionRegistryLite)extensionRegistry);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to parse the input stream object. Please make sure that you are using right class to parse the object", e);
        }
        return matlabResult;
    }

    public static MATLABResult newInstance(MATLABParams matlabParams, byte[] byteArray) {
        if (byteArray == null) {
            throw new IllegalArgumentException("byte array is null");
        }
        if (matlabParams == null) {
            throw new IllegalArgumentException("MATLAB Params object is required");
        }
        MATLABResult matlabResult = new MATLABResult();
        matlabResult.mwAttributesContainer = new MWAttributesContainer(matlabParams.getMwMarshalingRules());
        matlabResult.nargout = matlabParams.getNargout();
        matlabResult.targetType = matlabParams.getTargetType();
        matlabResult.hasNargout = matlabResult.nargout > 1;
        try {
            matlabResult.mlResult = MATLABResult.MATLAB_Result.parseFrom(byteArray);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to parse the byte array. Please make sure that you are using right class to parse the byte array", e);
        }
        return matlabResult;
    }

    public <T> T getResult() throws MATLABException {
        if (!this.mlResult.hasError()) {
            if (this.mlResult.getLhsCount() != this.nargout) {
                throw new IllegalArgumentException("Incorrect number of outputs returned from MATLAB.\nMATLAB returned " + this.mlResult.getLhsCount() + " number of outputs,\nMethod ,, expected " + this.nargout + " number of outputs.");
            }
        } else {
            MATLABError.MATLAB_Error mlError = this.mlResult.getError();
            throw new MATLABException(mlError.getMessage(), mlError.getIdentifier(), MWInvocationHandlerUtils.convertToMATLABStackFrameList(mlError.getStackList()));
        }
        List<MATLABArray.MATLAB_Array> mlArrList = this.mlResult.getLhsList();
        if (mlArrList.size() == 0) {
            return null;
        }
        JavaDataExtractor dataExtractor = new JavaDataExtractor(this.mwAttributesContainer);
        Object[] result = new Object[mlArrList.size()];
        Class marshalAsTargetType = this.hasNargout ? Object.class : this.targetType;
        for (int i = 0; i < mlArrList.size(); ++i) {
            result[i] = dataExtractor.toJavaType(mlArrList.get(i), marshalAsTargetType);
        }
        return this.hasNargout ? this.targetType.cast(result) : this.targetType.cast(result[0]);
    }
}

