/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ArrayUtils {
    private static Map<String, String> classNameToCamelCase = new HashMap<String, String>();
    private static Map<Class, Class> boxedTypeToPrimitiveType = ArrayUtils.createBoxedToUnBoxedTypeMap();

    public static Class getArrayElementType(Object arr) {
        Class<?> cls;
        if (arr == null) {
            return null;
        }
        Class<?> clazz = cls = arr.getClass() == Class.class ? (Class<?>)arr : arr.getClass();
        while (cls.isArray()) {
            cls = cls.getComponentType();
        }
        return cls;
    }

    public static List<Integer> getDimsArray(Object obj) {
        if (obj == null) {
            return null;
        }
        if (!obj.getClass().isArray()) {
            throw new IllegalArgumentException("Input must be an array");
        }
        if (ArrayUtils.isOneDimArray(obj)) {
            return Arrays.asList(Array.getLength(obj));
        }
        Object[] a = (Object[])obj;
        if (a.length == 0) {
            return Arrays.asList(0);
        }
        List<Integer> subLens = ArrayUtils.getDimsArray(a[0]);
        ArrayList<Integer> lens = new ArrayList<Integer>(subLens.size() + 1);
        lens.add(0, a.length);
        lens.addAll(1, subLens);
        return lens;
    }

    public static List<Integer> getStrides(List<Integer> len) {
        if (len == null) {
            return null;
        }
        ArrayList<Integer> stride = new ArrayList<Integer>(len.size() + 1);
        stride.add(1);
        for (int n = 0; n < len.size(); ++n) {
            stride.add(n + 1, (Integer)stride.get(n) * len.get(n));
        }
        return stride;
    }

    public static boolean isOneDimArray(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj.getClass().isArray() && !obj.getClass().getComponentType().isArray();
    }

    public static String getCamelCasedClassName(Class cls) {
        if (cls == null) {
            return null;
        }
        String clsName = cls.getName();
        String camelCased = classNameToCamelCase.get(clsName);
        if (camelCased == null) {
            String[] parts = clsName.split("\\.");
            camelCased = "";
            for (String part : parts) {
                camelCased = camelCased + part.substring(0, 1).toUpperCase() + part.substring(1);
            }
            classNameToCamelCase.put(clsName, camelCased);
        }
        return camelCased;
    }

    public static Class unBoxIfBoxedType(Class inClass) {
        Class primClass = boxedTypeToPrimitiveType.get(inClass);
        return primClass == null ? inClass : primClass;
    }

    public static Map<Class, Class> createBoxedToUnBoxedTypeMap() {
        HashMap<Class, Class> boxedToPrimitive = new HashMap<Class, Class>();
        boxedToPrimitive.put(Boolean.class, Boolean.TYPE);
        boxedToPrimitive.put(Double.class, Double.TYPE);
        boxedToPrimitive.put(Integer.class, Integer.TYPE);
        boxedToPrimitive.put(Character.class, Character.TYPE);
        boxedToPrimitive.put(Float.class, Float.TYPE);
        boxedToPrimitive.put(Long.class, Long.TYPE);
        boxedToPrimitive.put(Byte.class, Byte.TYPE);
        boxedToPrimitive.put(Short.class, Short.TYPE);
        return boxedToPrimitive;
    }

    public static List<Integer> convertToIntegerList(int[] src) {
        if (src == null) {
            return null;
        }
        ArrayList<Integer> dst = new ArrayList<Integer>(src.length);
        for (int i : src) {
            dst.add(i);
        }
        return dst;
    }

    public static List<Short> convertToShortList(List<Integer> src) {
        ArrayList<Short> result = new ArrayList<Short>(src.size());
        for (Integer i : src) {
            result.add(i.shortValue());
        }
        return result;
    }

    public static <T> T[] convertToArray(List<?> list, Class<T> c) {
        Object[] result = (Object[])Array.newInstance(c, list.size());
        result = list.toArray(result);
        return result;
    }

    public static <T> Object toPrimitiveArray(Object[] array, Class<T> c) {
        Object result = Array.newInstance(c, array.length);
        for (int i = 0; i < array.length; ++i) {
            Array.set(result, i, array[i]);
        }
        return result;
    }

    public static int[] toIntArray(Long[] array) {
        int[] result = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i].intValue();
        }
        return result;
    }

    public static char[] toCharArray(Integer[] array) {
        char[] result = new char[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = (char)array[i].intValue();
        }
        return result;
    }

    public static Character[] toCharacterArray(Integer[] array) {
        Character[] result = new Character[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = Character.valueOf((char)array[i].intValue());
        }
        return result;
    }

    public static Byte[] toBoxedArray(byte[] src) {
        Byte[] result = new Byte[src.length];
        for (int i = 0; i < src.length; ++i) {
            result[i] = src[i];
        }
        return result;
    }

    public static boolean coerceDimsList(List<Long> dimsListIn, int numOutputDims) {
        if (numOutputDims < dimsListIn.size()) {
            return ArrayUtils.shrinkDimensionsList(dimsListIn, numOutputDims);
        }
        return ArrayUtils.expandDimensionsList(dimsListIn, numOutputDims);
    }

    private static boolean expandDimensionsList(List<Long> inputDims, int numOutputDims) {
        while (numOutputDims > inputDims.size()) {
            inputDims.add(1L);
        }
        return true;
    }

    private static boolean shrinkDimensionsList(List<Long> inputDims, int targetNumOutputDims) {
        while (targetNumOutputDims < inputDims.size()) {
            if (ArrayUtils.removeRightMostOne(inputDims) || ArrayUtils.removeLeftMostOne(inputDims)) continue;
            return false;
        }
        return true;
    }

    private static boolean removeRightMostOne(List<Long> dimsList) {
        int idx = dimsList.size() - 1;
        if (dimsList.get(idx) == 1L) {
            dimsList.remove(idx);
            return true;
        }
        return false;
    }

    private static boolean removeLeftMostOne(List<Long> dimsList) {
        boolean status = false;
        for (int i = 0; i < dimsList.size(); ++i) {
            if (dimsList.get(i) != 1L) continue;
            dimsList.remove(i);
            status = true;
            break;
        }
        return status;
    }

    public static int getNumberOfDimensions(Object input) {
        Class<?> inputClass = input.getClass() == Class.class ? (Class<?>)input : input.getClass();
        int dim = 0;
        while (inputClass.isArray()) {
            inputClass = inputClass.getComponentType();
            ++dim;
        }
        return dim;
    }
}

