/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal;

import com.mathworks.mps.client.MWHttpClient;
import com.mathworks.mps.client.internal.MWFevalHandler;
import org.slf4j.Logger;

public class MWClientUsageLock {
    private MWFevalHandler fevalHandler;
    private int counter = 0;
    private boolean attemptedToClose = false;
    private final Object usageLock = new Object();
    private final Logger LOG = MWHttpClient.loggerFactory.getLogger(this.getClass());

    public MWClientUsageLock(MWFevalHandler fevalHandler) {
        this.fevalHandler = fevalHandler;
    }

    public boolean wasAttemptedToClose() {
        return this.attemptedToClose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void usageEnter(String errorMessage) {
        Object object = this.usageLock;
        synchronized (object) {
            if (this.attemptedToClose) {
                throw new IllegalStateException(errorMessage);
            }
            ++this.counter;
            this.LOG.trace("Client usage lock - entry - counter: {}", this.counter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void usageExit() {
        Object object = this.usageLock;
        synchronized (object) {
            --this.counter;
            this.LOG.trace("Client usage lock - exit - counter: {}", this.counter);
            if (this.counter == 0 && this.attemptedToClose) {
                this.fevalHandler.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attemptToClose() {
        Object object = this.usageLock;
        synchronized (object) {
            this.LOG.trace("Client usage lock - attempt to close");
            if (!this.attemptedToClose) {
                this.attemptedToClose = true;
                if (this.counter == 0) {
                    this.fevalHandler.close();
                } else {
                    this.fevalHandler.abort();
                }
            }
        }
    }
}

