/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal;

import com.mathworks.mps.client.internal.MWStructToBeanFactory;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class MWStructToBeanFactorySetter
extends MWStructToBeanFactory {
    private final Map<String, Method> beanSetterMap;

    public MWStructToBeanFactorySetter(Class beanType, List<String> fieldNames, Map<String, Class> beanTypeMap, Map<String, Method> beanSetterMap) {
        super(beanType, fieldNames, beanTypeMap);
        this.beanSetterMap = Collections.unmodifiableMap(beanSetterMap);
    }

    @Override
    public Object newInstance(List<String> structFieldNames, Object ... args) {
        Object beanInst = null;
        try {
            beanInst = this.beanType.newInstance();
            for (int i = 0; i < structFieldNames.size(); ++i) {
                String propName = structFieldNames.get(i);
                Method setter = this.beanSetterMap.get(propName);
                setter.invoke(beanInst, args[i]);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("An error occurred while marshaling a MATLAB structure with fields : " + structFieldNames + ", into a Java type : " + this.beanType.getName(), ex);
        }
        return beanInst;
    }

    public Map<String, Method> getBeanSetterMap() {
        return this.beanSetterMap;
    }
}

