/*
 * Decompiled with CFR 0.152.
 */
package com.metaobjects.generator.direct;

import com.metaobjects.MetaData;
import com.metaobjects.loader.MetaDataLoader;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public abstract class BaseGenerationContext<T extends MetaData> {
    protected final MetaDataLoader loader;
    protected final Map<String, Object> properties = new HashMap<String, Object>();
    protected final Map<String, Object> cache = new HashMap<String, Object>();
    protected T currentItem;
    protected String currentPackage;
    protected String currentClassName;
    protected final Set<String> imports = new LinkedHashSet<String>();

    public BaseGenerationContext(MetaDataLoader loader) {
        this.loader = loader;
    }

    public BaseGenerationContext<T> setProperty(String key, Object value) {
        this.properties.put(key, value);
        return this;
    }

    public <V> V getProperty(String key, V defaultValue) {
        return (V)this.properties.getOrDefault(key, defaultValue);
    }

    public String getStringProperty(String key, String defaultValue) {
        return (String)this.properties.getOrDefault(key, defaultValue);
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        return (Boolean)this.properties.getOrDefault(key, defaultValue);
    }

    public MetaDataLoader getLoader() {
        return this.loader;
    }

    public BaseGenerationContext<T> setCurrentItem(T item) {
        this.currentItem = item;
        return this;
    }

    public T getCurrentItem() {
        return this.currentItem;
    }

    public BaseGenerationContext<T> setCurrentPackage(String packageName) {
        this.currentPackage = packageName;
        return this;
    }

    public String getCurrentPackage() {
        return this.currentPackage;
    }

    public BaseGenerationContext<T> setCurrentClassName(String className) {
        this.currentClassName = className;
        return this;
    }

    public String getCurrentClassName() {
        return this.currentClassName;
    }

    public BaseGenerationContext<T> addImport(String importName) {
        this.imports.add(importName);
        return this;
    }

    public Set<String> getImports() {
        return Collections.unmodifiableSet(this.imports);
    }

    public void clearImports() {
        this.imports.clear();
    }

    public BaseGenerationContext<T> putCache(String key, Object value) {
        this.cache.put(key, value);
        return this;
    }

    public <V> V getCache(String key) {
        return (V)this.cache.get(key);
    }

    public boolean hasCache(String key) {
        return this.cache.containsKey(key);
    }

    public abstract String getContextType();
}

