/*
 * Decompiled with CFR 0.152.
 */
package com.metaobjects.generator.direct;

import com.metaobjects.MetaData;
import com.metaobjects.generator.GeneratorException;
import com.metaobjects.generator.GeneratorIOException;
import com.metaobjects.generator.GeneratorIOWriter;
import com.metaobjects.generator.MetaDataFilters;
import com.metaobjects.generator.direct.DirectGeneratorBase;
import com.metaobjects.generator.util.GeneratorUtil;
import com.metaobjects.loader.MetaDataLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collection;

public abstract class MultiFileDirectGeneratorBase<M extends MetaData>
extends DirectGeneratorBase {
    public static String ARG_FINALOUTPUTDIR = "finalOutputDir";
    protected File outDir = null;
    protected File finalOutDir = null;

    @Override
    protected void parseArgs() {
        super.parseArgs();
        this.outDir = this.getOutputDir();
        this.finalOutDir = this.hasArg(ARG_FINALOUTPUTDIR) ? this.getFinalOutputDir() : this.outDir;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute(MetaDataLoader loader) {
        OutputStream out;
        String filename;
        block18: {
            filename = null;
            out = null;
            GeneratorIOWriter writer = null;
            this.parseArgs();
            try {
                this.outDir = this.getOutputDir();
                Collection<MetaData> metadata = GeneratorUtil.getFilteredMetaData(loader, this.getFilterClass(), this.getMetaDataFilters());
                for (MetaData md : metadata) {
                    String path;
                    filename = md.getName();
                    filename = path = this.getSingleOutputFilePath(md);
                    File fp = new File(this.outDir, path);
                    if (!fp.exists()) {
                        fp.mkdirs();
                    }
                    String fn = this.getSingleOutputFilename(md);
                    File f = new File(fp, fn);
                    filename = f.getPath();
                    f.createNewFile();
                    out = new FileOutputStream(f);
                    PrintWriter pw = new PrintWriter(new OutputStreamWriter(out));
                    writer = this.getSingleWriter(loader, md, pw);
                    ((GeneratorIOWriter)((Object)writer.withFilters(MetaDataFilters.create(this.getFilters())))).withFilename(fn);
                    this.writeSingleFile(md, writer);
                    writer.close();
                    writer = null;
                    pw = null;
                }
                if (this.hasArg(ARG_OUTPUTFILENAME)) {
                    filename = this.getOutputFilename();
                    File outf = new File(this.finalOutDir, this.getOutputFilename());
                    outf.createNewFile();
                    out = new FileOutputStream(outf);
                    writer = this.getFinalWriter(loader, out);
                    if (writer != null) {
                        ((GeneratorIOWriter)((Object)writer.withFilters(MetaDataFilters.create(this.getFilters())))).withFilename(this.getOutputFilename());
                        this.writeFinalFile(metadata, writer);
                    } else {
                        OutputStream out2 = out;
                        out = null;
                        out2.close();
                    }
                }
                if (writer == null) break block18;
            }
            catch (IOException e) {
                try {
                    throw new GeneratorException("Unable to write to file [" + filename + "]: " + String.valueOf(e), e);
                }
                catch (Throwable throwable) {
                    if (writer != null) {
                        try {
                            writer.close();
                            throw throwable;
                        }
                        catch (IOException e2) {
                            throw new GeneratorException("Unable to close file [" + filename + "]: " + String.valueOf(e2), e2);
                        }
                    }
                    if (out == null) throw throwable;
                    try {
                        out.close();
                        throw throwable;
                    }
                    catch (IOException e3) {
                        log.error("Error closing output stream for file [" + filename + "]: " + String.valueOf(e3), (Throwable)e3);
                    }
                    throw throwable;
                }
            }
            try {
                writer.close();
                return;
            }
            catch (IOException e) {
                throw new GeneratorException("Unable to close file [" + filename + "]: " + String.valueOf(e), e);
            }
        }
        if (out == null) return;
        try {
            out.close();
            return;
        }
        catch (IOException e) {
            log.error("Error closing output stream for file [" + filename + "]: " + String.valueOf(e), (Throwable)e);
            return;
        }
    }

    protected File getFinalOutputDir() {
        return this.getAndCreateDir(ARG_FINALOUTPUTDIR, this.getArg(ARG_FINALOUTPUTDIR, true));
    }

    protected abstract Class<M> getFilterClass();

    protected abstract <T extends GeneratorIOWriter> T getSingleWriter(MetaDataLoader var1, M var2, PrintWriter var3) throws GeneratorIOException;

    protected abstract <T extends GeneratorIOWriter> T getFinalWriter(MetaDataLoader var1, OutputStream var2) throws GeneratorIOException;

    protected abstract void writeSingleFile(M var1, GeneratorIOWriter<?> var2) throws GeneratorIOException;

    protected abstract void writeFinalFile(Collection<M> var1, GeneratorIOWriter<?> var2) throws GeneratorIOException;

    protected abstract String getSingleOutputFilePath(M var1);

    protected abstract String getSingleOutputFilename(M var1);
}

