/*
 * Decompiled with CFR 0.152.
 */
package com.metaobjects.generator.direct.metadata.ai;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.metaobjects.generator.GeneratorIOException;
import com.metaobjects.generator.direct.metadata.json.JsonDirectWriter;
import com.metaobjects.loader.MetaDataLoader;
import com.metaobjects.registry.ChildRequirement;
import com.metaobjects.registry.MetaDataRegistry;
import com.metaobjects.registry.TypeDefinition;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataAIDocumentationWriter
extends JsonDirectWriter<MetaDataAIDocumentationWriter> {
    private static final Logger log = LoggerFactory.getLogger(MetaDataAIDocumentationWriter.class);
    private String version = "6.1.0";
    private boolean includeInheritance = true;
    private boolean includeImplementationDetails = true;
    private boolean includeExtensionGuidance = true;
    private boolean includeCrossLanguageInfo = false;
    private MetaDataRegistry typeRegistry = MetaDataRegistry.getInstance();

    public MetaDataAIDocumentationWriter(MetaDataLoader loader, OutputStream out) throws GeneratorIOException {
        super(loader, out);
        log.info("Initialized AI documentation writer with {} registered types for comprehensive analysis", (Object)this.typeRegistry.getRegisteredTypes().size());
    }

    public MetaDataAIDocumentationWriter withVersion(String version) {
        this.version = version;
        return this;
    }

    public MetaDataAIDocumentationWriter withInheritance(boolean includeInheritance) {
        this.includeInheritance = includeInheritance;
        return this;
    }

    public MetaDataAIDocumentationWriter withImplementationDetails(boolean includeImplementationDetails) {
        this.includeImplementationDetails = includeImplementationDetails;
        return this;
    }

    public MetaDataAIDocumentationWriter withExtensionGuidance(boolean includeExtensionGuidance) {
        this.includeExtensionGuidance = includeExtensionGuidance;
        return this;
    }

    public MetaDataAIDocumentationWriter withCrossLanguageInfo(boolean includeCrossLanguageInfo) {
        this.includeCrossLanguageInfo = includeCrossLanguageInfo;
        return this;
    }

    @Override
    public String toString() {
        return "MetaDataAIDocumentationWriter{version='" + this.version + "', registeredTypes=" + this.typeRegistry.getRegisteredTypes().size() + ", includeInheritance=" + this.includeInheritance + ", includeImplementation=" + this.includeImplementationDetails + "}";
    }

    @Override
    public void writeJson() throws GeneratorIOException {
        try {
            log.info("Generating AI-optimized documentation for {} types with inheritance analysis", (Object)this.typeRegistry.getRegisteredTypes().size());
            JsonObject documentation = this.generateAIDocumentation();
            this.setJsonObject(documentation);
            log.info("Generated AI documentation with {} inheritance relationships and {} extension points", (Object)this.countInheritanceRelationships(), (Object)this.countExtensionPoints());
        }
        catch (Exception e) {
            throw new GeneratorIOException(this, "Failed to generate AI documentation", e);
        }
    }

    private JsonObject generateAIDocumentation() {
        JsonObject doc = new JsonObject();
        doc.add("documentationInfo", (JsonElement)this.createDocumentationInfo());
        if (this.includeInheritance) {
            doc.add("inheritanceHierarchy", (JsonElement)this.generateInheritanceHierarchy());
        }
        doc.add("typeCatalog", (JsonElement)this.generateTypeCatalog());
        if (this.includeExtensionGuidance) {
            doc.add("extensionGuidance", (JsonElement)this.generateExtensionGuidance());
        }
        if (this.includeImplementationDetails) {
            doc.add("implementationMapping", (JsonElement)this.generateImplementationMapping());
        }
        if (this.includeCrossLanguageInfo) {
            doc.add("crossLanguageSupport", (JsonElement)this.generateCrossLanguageSupport());
        }
        return doc;
    }

    private JsonObject createDocumentationInfo() {
        JsonObject info = new JsonObject();
        info.addProperty("version", this.version);
        info.addProperty("generatedFrom", "TypeDefinition Registry");
        info.addProperty("generationTimestamp", (Number)System.currentTimeMillis());
        info.addProperty("aiOptimized", Boolean.valueOf(true));
        info.addProperty("inheritanceSupport", Boolean.valueOf(this.includeInheritance));
        info.addProperty("totalTypes", (Number)this.typeRegistry.getRegisteredTypes().size());
        JsonObject stats = new JsonObject();
        Map<String, Integer> typesByPrimary = this.typeRegistry.getAllTypeDefinitions().stream().collect(Collectors.groupingBy(TypeDefinition::getType, Collectors.collectingAndThen(Collectors.counting(), Math::toIntExact)));
        for (Map.Entry<String, Integer> entry : typesByPrimary.entrySet()) {
            stats.addProperty(entry.getKey() + "Types", (Number)entry.getValue());
        }
        info.add("typeStatistics", (JsonElement)stats);
        info.addProperty("purpose", "AI-assisted metadata development, plugin creation, and cross-language implementation");
        return info;
    }

    private JsonObject generateInheritanceHierarchy() {
        JsonObject hierarchy = new JsonObject();
        Map<String, List<TypeDefinition>> inheritanceGroups = this.typeRegistry.getAllTypeDefinitions().stream().collect(Collectors.groupingBy(def -> def.hasParent() ? def.getParentQualifiedName() : "root"));
        for (Map.Entry<String, List<TypeDefinition>> entry : inheritanceGroups.entrySet()) {
            String parentKey = entry.getKey();
            List<TypeDefinition> children = entry.getValue();
            if ("root".equals(parentKey)) continue;
            JsonObject parentInfo = new JsonObject();
            TypeDefinition parentDef = this.typeRegistry.getTypeDefinition(parentKey.split("\\.")[0], parentKey.split("\\.")[1]);
            if (parentDef != null) {
                parentInfo.addProperty("isAbstract", Boolean.valueOf(true));
                parentInfo.addProperty("description", parentDef.getDescription());
                JsonArray childArray = new JsonArray();
                Set<String> childNames = children.stream().map(TypeDefinition::getQualifiedName).collect(Collectors.toSet());
                childNames.forEach(arg_0 -> ((JsonArray)childArray).add(arg_0));
                parentInfo.add("children", (JsonElement)childArray);
                JsonArray commonAttrs = new JsonArray();
                if (parentDef.getChildRequirements() != null) {
                    parentDef.getChildRequirements().stream().filter(req -> "attr".equals(req.getExpectedType())).map(ChildRequirement::getName).forEach(arg_0 -> ((JsonArray)commonAttrs).add(arg_0));
                }
                parentInfo.add("commonAttributes", (JsonElement)commonAttrs);
            }
            hierarchy.add(parentKey, (JsonElement)parentInfo);
        }
        return hierarchy;
    }

    private JsonObject generateTypeCatalog() {
        JsonObject catalog = new JsonObject();
        for (TypeDefinition typeDef : this.typeRegistry.getAllTypeDefinitions()) {
            JsonObject typeInfo = new JsonObject();
            typeInfo.addProperty("qualifiedName", typeDef.getQualifiedName());
            typeInfo.addProperty("implementationClass", typeDef.getImplementationClass().getName());
            typeInfo.addProperty("description", typeDef.getDescription());
            if (typeDef.hasParent()) {
                typeInfo.addProperty("inheritsFrom", typeDef.getParentQualifiedName());
                JsonObject attributeClassification = new JsonObject();
                JsonArray inherited = new JsonArray();
                Map inheritedReqs = typeDef.getInheritedChildRequirements();
                inheritedReqs.values().stream().filter(req -> "attr".equals(req.getExpectedType())).map(ChildRequirement::getName).forEach(arg_0 -> ((JsonArray)inherited).add(arg_0));
                attributeClassification.add("inherited", (JsonElement)inherited);
                JsonArray specific = new JsonArray();
                typeDef.getDirectChildRequirements().stream().filter(req -> "attr".equals(req.getExpectedType())).map(ChildRequirement::getName).forEach(arg_0 -> ((JsonArray)specific).add(arg_0));
                attributeClassification.add("specific", (JsonElement)specific);
                typeInfo.add("attributeClassification", (JsonElement)attributeClassification);
            }
            JsonArray childRequirements = new JsonArray();
            for (ChildRequirement req2 : typeDef.getChildRequirements()) {
                JsonObject reqInfo = new JsonObject();
                reqInfo.addProperty("name", req2.getName());
                reqInfo.addProperty("type", req2.getExpectedType());
                reqInfo.addProperty("subType", req2.getExpectedSubType());
                reqInfo.addProperty("required", Boolean.valueOf(req2.isRequired()));
                reqInfo.addProperty("description", req2.getDescription());
                childRequirements.add((JsonElement)reqInfo);
            }
            typeInfo.add("childRequirements", (JsonElement)childRequirements);
            typeInfo.addProperty("extensible", Boolean.valueOf(true));
            typeInfo.addProperty("pluginSupport", Boolean.valueOf(true));
            catalog.add(typeDef.getQualifiedName(), (JsonElement)typeInfo);
        }
        return catalog;
    }

    private JsonObject generateExtensionGuidance() {
        JsonObject guidance = new JsonObject();
        JsonObject patterns = new JsonObject();
        patterns.addProperty("newFieldType", "Extend MetaField base class, inherit common attributes");
        patterns.addProperty("newObjectType", "Extend MetaObject base class, define specific behavior");
        patterns.addProperty("customAttributes", "Use attr type with custom subTypes");
        patterns.addProperty("inheritance", "Use inheritsFrom() in TypeDefinitionBuilder for attribute inheritance");
        guidance.add("extensionPatterns", (JsonElement)patterns);
        JsonArray extensionPoints = new JsonArray();
        JsonObject fieldExtensions = new JsonObject();
        fieldExtensions.addProperty("baseType", "field");
        fieldExtensions.addProperty("description", "Create custom field types with validation and formatting");
        fieldExtensions.addProperty("example", "CurrencyField, EmailField, PhoneField");
        JsonArray fieldAttributes = new JsonArray();
        fieldAttributes.add("precision");
        fieldAttributes.add("format");
        fieldAttributes.add("validation");
        fieldExtensions.add("commonCustomAttributes", (JsonElement)fieldAttributes);
        extensionPoints.add((JsonElement)fieldExtensions);
        JsonObject objectExtensions = new JsonObject();
        objectExtensions.addProperty("baseType", "object");
        objectExtensions.addProperty("description", "Create domain-specific object types");
        objectExtensions.addProperty("example", "AuditableObject, VersionedObject, CacheableObject");
        JsonArray objectAttributes = new JsonArray();
        objectAttributes.add("auditing");
        objectAttributes.add("versioning");
        objectAttributes.add("caching");
        objectExtensions.add("commonCustomAttributes", (JsonElement)objectAttributes);
        extensionPoints.add((JsonElement)objectExtensions);
        guidance.add("extensionPoints", (JsonElement)extensionPoints);
        JsonObject registrationExample = new JsonObject();
        registrationExample.addProperty("pattern", "MetaDataRegistry.registerType()");
        registrationExample.addProperty("description", "Use fluent TypeDefinitionBuilder API");
        registrationExample.addProperty("example", "MetaDataRegistry.registerType(CurrencyField.class, def -> def.type(\"field\").subType(\"currency\").inheritsFromBaseField().optionalAttribute(\"precision\", \"int\"))");
        guidance.add("registrationExample", (JsonElement)registrationExample);
        return guidance;
    }

    private JsonObject generateImplementationMapping() {
        JsonObject mapping = new JsonObject();
        JsonObject classMapping = new JsonObject();
        for (TypeDefinition typeDef : this.typeRegistry.getAllTypeDefinitions()) {
            classMapping.addProperty(typeDef.getImplementationClass().getSimpleName(), typeDef.getQualifiedName());
        }
        mapping.add("classToTypeMapping", (JsonElement)classMapping);
        JsonObject packageInfo = new JsonObject();
        Map<String, List<TypeDefinition>> packageGroups = this.typeRegistry.getAllTypeDefinitions().stream().collect(Collectors.groupingBy(def -> def.getImplementationClass().getPackage().getName()));
        for (Map.Entry<String, List<TypeDefinition>> entry : packageGroups.entrySet()) {
            JsonArray types = new JsonArray();
            entry.getValue().stream().map(TypeDefinition::getQualifiedName).forEach(arg_0 -> ((JsonArray)types).add(arg_0));
            packageInfo.add(entry.getKey(), (JsonElement)types);
        }
        mapping.add("packageOrganization", (JsonElement)packageInfo);
        return mapping;
    }

    private JsonObject generateCrossLanguageSupport() {
        JsonObject crossLang = new JsonObject();
        crossLang.addProperty("stringBasedTypes", Boolean.valueOf(true));
        crossLang.addProperty("description", "Type system uses string identifiers for cross-language compatibility");
        JsonObject typeMappings = new JsonObject();
        JsonObject javaMapping = new JsonObject();
        javaMapping.addProperty("fieldString", "StringField.class");
        javaMapping.addProperty("fieldInt", "IntegerField.class");
        javaMapping.addProperty("objectPojo", "PojoMetaObject.class");
        typeMappings.add("java", (JsonElement)javaMapping);
        JsonObject csharpMapping = new JsonObject();
        csharpMapping.addProperty("fieldString", "StringField");
        csharpMapping.addProperty("fieldInt", "IntegerField");
        csharpMapping.addProperty("objectPojo", "PojoMetaObject");
        typeMappings.add("csharp", (JsonElement)csharpMapping);
        JsonObject tsMapping = new JsonObject();
        tsMapping.addProperty("fieldString", "StringFieldType");
        tsMapping.addProperty("fieldInt", "IntegerFieldType");
        tsMapping.addProperty("objectPojo", "PojoMetaObjectType");
        typeMappings.add("typescript", (JsonElement)tsMapping);
        crossLang.add("languageMappings", (JsonElement)typeMappings);
        return crossLang;
    }

    private int countInheritanceRelationships() {
        return (int)this.typeRegistry.getAllTypeDefinitions().stream().filter(def -> def.hasParent()).count();
    }

    private int countExtensionPoints() {
        return (int)this.typeRegistry.getAllTypeDefinitions().stream().filter(def -> "base".equals(def.getSubType())).count();
    }
}

