/*
 * Decompiled with CFR 0.152.
 */
package com.metaobjects.generator.direct.metadata.html;

import com.metaobjects.generator.GeneratorIOException;
import com.metaobjects.generator.GeneratorIOWriter;
import com.metaobjects.loader.MetaDataLoader;
import com.metaobjects.registry.ChildRequirement;
import com.metaobjects.registry.MetaDataRegistry;
import com.metaobjects.registry.TypeDefinition;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataHtmlDocumentationWriter
extends GeneratorIOWriter<MetaDataHtmlDocumentationWriter> {
    private static final Logger log = LoggerFactory.getLogger(MetaDataHtmlDocumentationWriter.class);
    private String version = "6.2.0";
    private String title = "MetaObjects Framework Documentation";
    private boolean includeInheritance = true;
    private boolean includeExamples = true;
    private boolean includeExtensionGuide = true;
    private MetaDataRegistry typeRegistry;
    private PrintWriter writer;
    private OutputStream out;

    public MetaDataHtmlDocumentationWriter(MetaDataLoader loader, OutputStream out) throws GeneratorIOException {
        super(loader);
        this.out = out;
        this.typeRegistry = MetaDataRegistry.getInstance();
        this.writer = new PrintWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
        log.info("Initialized HTML documentation writer for {} registered types", (Object)this.typeRegistry.getRegisteredTypes().size());
    }

    public MetaDataHtmlDocumentationWriter withVersion(String version) {
        this.version = version;
        return this;
    }

    public MetaDataHtmlDocumentationWriter withTitle(String title) {
        this.title = title;
        return this;
    }

    public MetaDataHtmlDocumentationWriter withInheritance(boolean includeInheritance) {
        this.includeInheritance = includeInheritance;
        return this;
    }

    public MetaDataHtmlDocumentationWriter withExamples(boolean includeExamples) {
        this.includeExamples = includeExamples;
        return this;
    }

    public MetaDataHtmlDocumentationWriter withExtensionGuide(boolean includeExtensionGuide) {
        this.includeExtensionGuide = includeExtensionGuide;
        return this;
    }

    public void writeHtml() throws GeneratorIOException {
        try {
            log.info("Generating professional HTML documentation for {} types", (Object)this.typeRegistry.getRegisteredTypes().size());
            this.generateHtmlDocument();
            this.writer.flush();
            log.info("Generated HTML documentation with {} types, {} inheritance relationships, {} extension points", new Object[]{this.typeRegistry.getRegisteredTypes().size(), this.countInheritanceRelationships(), this.countExtensionPoints()});
        }
        catch (Exception e) {
            throw new GeneratorIOException(this, "Failed to generate HTML documentation", e);
        }
    }

    @Override
    public void close() throws GeneratorIOException {
        try {
            if (this.writer != null) {
                this.writer.close();
            }
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException e) {
            throw new GeneratorIOException(this, "Error closing HTML documentation writer: " + String.valueOf(e), e);
        }
    }

    private void generateHtmlDocument() {
        this.writer.println("<!DOCTYPE html>");
        this.writer.println("<html lang=\"en\">");
        this.generateHtmlHead();
        this.writer.println("<body>");
        this.generateHeader();
        this.writer.println("<div class=\"container\">");
        this.generateSidebar();
        this.generateMainContent();
        this.writer.println("</div>");
        this.generateFooter();
        this.generateJavaScript();
        this.writer.println("</body>");
        this.writer.println("</html>");
    }

    private void generateHtmlHead() {
        this.writer.println("<head>");
        this.writer.println("    <meta charset=\"UTF-8\">");
        this.writer.println("    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">");
        this.writer.println("    <title>" + this.escapeHtml(this.title) + "</title>");
        this.writer.println("    <style>");
        this.generateCSS();
        this.writer.println("    </style>");
        this.writer.println("</head>");
    }

    private void generateCSS() {
        this.writer.println("        /* Modern Documentation Styling */");
        this.writer.println("        * { margin: 0; padding: 0; box-sizing: border-box; }");
        this.writer.println("        ");
        this.writer.println("        body {");
        this.writer.println("            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;");
        this.writer.println("            line-height: 1.6;");
        this.writer.println("            color: #333;");
        this.writer.println("            background-color: #f8f9fa;");
        this.writer.println("        }");
        this.writer.println("        ");
        this.writer.println("        .header {");
        this.writer.println("            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);");
        this.writer.println("            color: white;");
        this.writer.println("            padding: 2rem 0;");
        this.writer.println("            text-align: center;");
        this.writer.println("            box-shadow: 0 2px 4px rgba(0,0,0,0.1);");
        this.writer.println("        }");
        this.writer.println("        ");
        this.writer.println("        .header h1 { font-size: 2.5rem; font-weight: 300; margin-bottom: 0.5rem; }");
        this.writer.println("        .header .subtitle { font-size: 1.1rem; opacity: 0.9; }");
        this.writer.println("        .header .version { font-size: 0.9rem; opacity: 0.8; margin-top: 0.5rem; }");
        this.writer.println("        ");
        this.writer.println("        .container {");
        this.writer.println("            display: grid;");
        this.writer.println("            grid-template-columns: 300px 1fr;");
        this.writer.println("            min-height: calc(100vh - 200px);");
        this.writer.println("            max-width: 1400px;");
        this.writer.println("            margin: 0 auto;");
        this.writer.println("            gap: 2rem;");
        this.writer.println("            padding: 2rem;");
        this.writer.println("        }");
        this.writer.println("        ");
        this.writer.println("        .sidebar {");
        this.writer.println("            background: white;");
        this.writer.println("            border-radius: 8px;");
        this.writer.println("            box-shadow: 0 2px 12px rgba(0,0,0,0.1);");
        this.writer.println("            padding: 1.5rem;");
        this.writer.println("            height: fit-content;");
        this.writer.println("            position: sticky;");
        this.writer.println("            top: 2rem;");
        this.writer.println("        }");
        this.writer.println("        ");
        this.writer.println("        .sidebar h3 {");
        this.writer.println("            color: #667eea;");
        this.writer.println("            border-bottom: 2px solid #eee;");
        this.writer.println("            padding-bottom: 0.5rem;");
        this.writer.println("            margin-bottom: 1rem;");
        this.writer.println("        }");
        this.writer.println("        ");
        this.writer.println("        .sidebar ul { list-style: none; margin-bottom: 1.5rem; }");
        this.writer.println("        .sidebar li { margin-bottom: 0.5rem; }");
        this.writer.println("        .sidebar a {");
        this.writer.println("            color: #666;");
        this.writer.println("            text-decoration: none;");
        this.writer.println("            padding: 0.25rem 0.5rem;");
        this.writer.println("            border-radius: 4px;");
        this.writer.println("            transition: all 0.2s ease;");
        this.writer.println("            display: block;");
        this.writer.println("        }");
        this.writer.println("        .sidebar a:hover { background: #f0f4ff; color: #667eea; }");
        this.writer.println("        ");
        this.writer.println("        .main-content {");
        this.writer.println("            background: white;");
        this.writer.println("            border-radius: 8px;");
        this.writer.println("            box-shadow: 0 2px 12px rgba(0,0,0,0.1);");
        this.writer.println("            padding: 3rem;");
        this.writer.println("        }");
        this.writer.println("        ");
        this.writer.println("        .section {");
        this.writer.println("            margin-bottom: 3rem;");
        this.writer.println("            scroll-margin-top: 2rem;");
        this.writer.println("        }");
        this.writer.println("        ");
        this.writer.println("        .section h2 {");
        this.writer.println("            color: #333;");
        this.writer.println("            font-size: 2rem;");
        this.writer.println("            margin-bottom: 1rem;");
        this.writer.println("            border-bottom: 3px solid #667eea;");
        this.writer.println("            padding-bottom: 0.5rem;");
        this.writer.println("        }");
        this.writer.println("        ");
        this.writer.println("        .section h3 {");
        this.writer.println("            color: #555;");
        this.writer.println("            font-size: 1.4rem;");
        this.writer.println("            margin: 2rem 0 1rem 0;");
        this.writer.println("        }");
        this.writer.println("        ");
        this.writer.println("        .type-card {");
        this.writer.println("            border: 1px solid #e0e0e0;");
        this.writer.println("            border-radius: 8px;");
        this.writer.println("            padding: 1.5rem;");
        this.writer.println("            margin-bottom: 1.5rem;");
        this.writer.println("            background: #fafafa;");
        this.writer.println("            transition: box-shadow 0.2s ease;");
        this.writer.println("        }");
        this.writer.println("        ");
        this.writer.println("        .type-card:hover { box-shadow: 0 4px 12px rgba(0,0,0,0.1); }");
        this.writer.println("        ");
        this.writer.println("        .type-header {");
        this.writer.println("            display: flex;");
        this.writer.println("            align-items: center;");
        this.writer.println("            margin-bottom: 1rem;");
        this.writer.println("        }");
        this.writer.println("        ");
        this.writer.println("        .type-name {");
        this.writer.println("            font-size: 1.3rem;");
        this.writer.println("            font-weight: 600;");
        this.writer.println("            color: #333;");
        this.writer.println("            margin-right: 1rem;");
        this.writer.println("        }");
        this.writer.println("        ");
        this.writer.println("        .type-badge {");
        this.writer.println("            background: #667eea;");
        this.writer.println("            color: white;");
        this.writer.println("            padding: 0.2rem 0.6rem;");
        this.writer.println("            border-radius: 12px;");
        this.writer.println("            font-size: 0.8rem;");
        this.writer.println("            font-weight: 500;");
        this.writer.println("        }");
        this.writer.println("        ");
        this.writer.println("        .inheritance-chain {");
        this.writer.println("            background: #e8f2ff;");
        this.writer.println("            border-left: 4px solid #667eea;");
        this.writer.println("            padding: 1rem;");
        this.writer.println("            margin: 1rem 0;");
        this.writer.println("            border-radius: 0 4px 4px 0;");
        this.writer.println("        }");
        this.writer.println("        ");
        this.writer.println("        .attributes-grid {");
        this.writer.println("            display: grid;");
        this.writer.println("            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));");
        this.writer.println("            gap: 1rem;");
        this.writer.println("            margin: 1rem 0;");
        this.writer.println("        }");
        this.writer.println("        ");
        this.writer.println("        .attribute {");
        this.writer.println("            background: white;");
        this.writer.println("            border: 1px solid #ddd;");
        this.writer.println("            border-radius: 4px;");
        this.writer.println("            padding: 0.75rem;");
        this.writer.println("        }");
        this.writer.println("        ");
        this.writer.println("        .attribute-name { font-weight: 600; color: #667eea; }");
        this.writer.println("        .attribute-type { color: #666; font-size: 0.9rem; }");
        this.writer.println("        .attribute-required { color: #d73a49; font-weight: 600; }");
        this.writer.println("        .attribute-optional { color: #28a745; font-weight: 600; }");
        this.writer.println("        ");
        this.writer.println("        .code-block {");
        this.writer.println("            background: #f6f8fa;");
        this.writer.println("            border: 1px solid #e1e4e8;");
        this.writer.println("            border-radius: 6px;");
        this.writer.println("            padding: 1rem;");
        this.writer.println("            overflow-x: auto;");
        this.writer.println("            font-family: 'Monaco', 'Menlo', 'Ubuntu Mono', monospace;");
        this.writer.println("            font-size: 0.9rem;");
        this.writer.println("            line-height: 1.4;");
        this.writer.println("        }");
        this.writer.println("        ");
        this.writer.println("        .stats-grid {");
        this.writer.println("            display: grid;");
        this.writer.println("            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));");
        this.writer.println("            gap: 1rem;");
        this.writer.println("            margin: 2rem 0;");
        this.writer.println("        }");
        this.writer.println("        ");
        this.writer.println("        .stat-card {");
        this.writer.println("            background: white;");
        this.writer.println("            border: 1px solid #e0e0e0;");
        this.writer.println("            border-radius: 8px;");
        this.writer.println("            padding: 1.5rem;");
        this.writer.println("            text-align: center;");
        this.writer.println("        }");
        this.writer.println("        ");
        this.writer.println("        .stat-number {");
        this.writer.println("            font-size: 2rem;");
        this.writer.println("            font-weight: 600;");
        this.writer.println("            color: #667eea;");
        this.writer.println("        }");
        this.writer.println("        ");
        this.writer.println("        .stat-label { color: #666; margin-top: 0.5rem; }");
        this.writer.println("        ");
        this.writer.println("        .footer {");
        this.writer.println("            text-align: center;");
        this.writer.println("            padding: 2rem;");
        this.writer.println("            color: #666;");
        this.writer.println("            border-top: 1px solid #eee;");
        this.writer.println("            margin-top: 3rem;");
        this.writer.println("        }");
        this.writer.println("        ");
        this.writer.println("        /* Responsive Design */");
        this.writer.println("        @media (max-width: 1024px) {");
        this.writer.println("            .container {");
        this.writer.println("                grid-template-columns: 250px 1fr;");
        this.writer.println("                gap: 1rem;");
        this.writer.println("                padding: 1rem;");
        this.writer.println("            }");
        this.writer.println("        }");
        this.writer.println("        ");
        this.writer.println("        @media (max-width: 768px) {");
        this.writer.println("            .container {");
        this.writer.println("                grid-template-columns: 1fr;");
        this.writer.println("            }");
        this.writer.println("            .sidebar { position: static; }");
        this.writer.println("            .header h1 { font-size: 2rem; }");
        this.writer.println("            .main-content { padding: 2rem; }");
        this.writer.println("        }");
    }

    private void generateHeader() {
        this.writer.println("    <div class=\"header\">");
        this.writer.println("        <h1>" + this.escapeHtml(this.title) + "</h1>");
        this.writer.println("        <div class=\"subtitle\">Comprehensive Type System Documentation</div>");
        this.writer.println("        <div class=\"version\">Version " + this.escapeHtml(this.version) + " \u2022 Generated " + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm")) + "</div>");
        this.writer.println("    </div>");
    }

    private void generateSidebar() {
        this.writer.println("        <nav class=\"sidebar\">");
        this.writer.println("            <h3>Navigation</h3>");
        this.writer.println("            <ul>");
        this.writer.println("                <li><a href=\"#overview\">Framework Overview</a></li>");
        this.writer.println("                <li><a href=\"#statistics\">Type Statistics</a></li>");
        if (this.includeInheritance) {
            this.writer.println("                <li><a href=\"#inheritance\">Type Hierarchy</a></li>");
        }
        this.writer.println("                <li><a href=\"#types\">Type Definitions</a></li>");
        if (this.includeExtensionGuide) {
            this.writer.println("                <li><a href=\"#extensions\">Extension Guide</a></li>");
        }
        this.writer.println("            </ul>");
        Map<String, Integer> typesByCategory = this.typeRegistry.getAllTypeDefinitions().stream().collect(Collectors.groupingBy(TypeDefinition::getType, Collectors.collectingAndThen(Collectors.counting(), Math::toIntExact)));
        if (!typesByCategory.isEmpty()) {
            this.writer.println("            <h3>Type Categories</h3>");
            this.writer.println("            <ul>");
            for (Map.Entry<String, Integer> entry : typesByCategory.entrySet()) {
                String category = entry.getKey();
                int count = entry.getValue();
                this.writer.println("                <li><a href=\"#category-" + this.escapeHtml(category) + "\">" + this.capitalizeFirst(category) + " Types (" + count + ")</a></li>");
            }
            this.writer.println("            </ul>");
        }
        this.writer.println("        </nav>");
    }

    private void generateMainContent() {
        this.writer.println("        <main class=\"main-content\">");
        this.generateOverviewSection();
        this.generateStatisticsSection();
        if (this.includeInheritance) {
            this.generateInheritanceSection();
        }
        this.generateTypesSection();
        if (this.includeExtensionGuide) {
            this.generateExtensionGuideSection();
        }
        this.writer.println("        </main>");
    }

    private void generateOverviewSection() {
        this.writer.println("            <section id=\"overview\" class=\"section\">");
        this.writer.println("                <h2>Framework Overview</h2>");
        this.writer.println("                <p>The MetaObjects framework provides a sophisticated metadata-driven development platform with a comprehensive type system designed for extensibility and cross-language compatibility.</p>");
        this.writer.println("                <h3>Core Concepts</h3>");
        this.writer.println("                <ul>");
        this.writer.println("                    <li><strong>Read-Optimized Architecture:</strong> MetaData objects are loaded once during startup and optimized for heavy read access</li>");
        this.writer.println("                    <li><strong>Type Registration System:</strong> Service-based type registry with automatic discovery and inheritance support</li>");
        this.writer.println("                    <li><strong>Constraint System:</strong> Integrated validation and placement constraints for data integrity</li>");
        this.writer.println("                    <li><strong>Plugin Architecture:</strong> Extensible type system supporting custom field types, validators, and object behaviors</li>");
        this.writer.println("                    <li><strong>Cross-Language Support:</strong> String-based type identifiers enable implementation across Java, C#, and TypeScript</li>");
        this.writer.println("                </ul>");
        this.writer.println("                <h3>Architecture Patterns</h3>");
        this.writer.println("                <div class=\"code-block\">");
        this.writer.println("// MetaDataLoader operates like Java ClassLoader - load once, read many");
        this.writer.println("MetaDataLoader loader = new SimpleLoader(\"myApp\");");
        this.writer.println("loader.init(); // Heavy initialization, permanent in memory");
        this.writer.println("");
        this.writer.println("// Runtime access is O(1) cached lookup - no synchronization needed");
        this.writer.println("MetaObject userMeta = loader.getMetaObjectByName(\"User\");");
        this.writer.println("MetaField emailField = userMeta.getMetaField(\"email\");");
        this.writer.println("                </div>");
        this.writer.println("            </section>");
    }

    private void generateStatisticsSection() {
        this.writer.println("            <section id=\"statistics\" class=\"section\">");
        this.writer.println("                <h2>Type Registry Statistics</h2>");
        Map<String, Integer> typesByCategory = this.typeRegistry.getAllTypeDefinitions().stream().collect(Collectors.groupingBy(TypeDefinition::getType, Collectors.collectingAndThen(Collectors.counting(), Math::toIntExact)));
        int totalTypes = this.typeRegistry.getRegisteredTypes().size();
        int inheritanceRelationships = this.countInheritanceRelationships();
        int extensionPoints = this.countExtensionPoints();
        this.writer.println("                <div class=\"stats-grid\">");
        this.writer.println("                    <div class=\"stat-card\">");
        this.writer.println("                        <div class=\"stat-number\">" + totalTypes + "</div>");
        this.writer.println("                        <div class=\"stat-label\">Total Types</div>");
        this.writer.println("                    </div>");
        this.writer.println("                    <div class=\"stat-card\">");
        this.writer.println("                        <div class=\"stat-number\">" + inheritanceRelationships + "</div>");
        this.writer.println("                        <div class=\"stat-label\">Inheritance Relationships</div>");
        this.writer.println("                    </div>");
        this.writer.println("                    <div class=\"stat-card\">");
        this.writer.println("                        <div class=\"stat-number\">" + extensionPoints + "</div>");
        this.writer.println("                        <div class=\"stat-label\">Extension Points</div>");
        this.writer.println("                    </div>");
        this.writer.println("                    <div class=\"stat-card\">");
        this.writer.println("                        <div class=\"stat-number\">" + typesByCategory.size() + "</div>");
        this.writer.println("                        <div class=\"stat-label\">Type Categories</div>");
        this.writer.println("                    </div>");
        this.writer.println("                </div>");
        this.writer.println("                <h3>Type Distribution</h3>");
        this.writer.println("                <div class=\"attributes-grid\">");
        for (Map.Entry<String, Integer> entry : typesByCategory.entrySet()) {
            this.writer.println("                    <div class=\"attribute\">");
            this.writer.println("                        <div class=\"attribute-name\">" + this.capitalizeFirst(entry.getKey()) + " Types</div>");
            this.writer.println("                        <div class=\"attribute-type\">" + String.valueOf(entry.getValue()) + " registered implementations</div>");
            this.writer.println("                    </div>");
        }
        this.writer.println("                </div>");
        this.writer.println("            </section>");
    }

    private void generateInheritanceSection() {
        this.writer.println("            <section id=\"inheritance\" class=\"section\">");
        this.writer.println("                <h2>Type Inheritance Hierarchy</h2>");
        this.writer.println("                <p>The MetaObjects framework uses inheritance to reduce code duplication and provide extensible base types for plugin development.</p>");
        Map<String, List<TypeDefinition>> inheritanceGroups = this.typeRegistry.getAllTypeDefinitions().stream().collect(Collectors.groupingBy(def -> def.hasParent() ? def.getParentQualifiedName() : "root"));
        for (Map.Entry<String, List<TypeDefinition>> entry : inheritanceGroups.entrySet()) {
            TypeDefinition parentDef;
            String parentKey = entry.getKey();
            List<TypeDefinition> children = entry.getValue();
            if ("root".equals(parentKey)) continue;
            this.writer.println("                <h3>" + this.escapeHtml(parentKey) + "</h3>");
            this.writer.println("                <div class=\"inheritance-chain\">");
            String[] parts = parentKey.split("\\.");
            if (parts.length == 2 && (parentDef = this.typeRegistry.getTypeDefinition(parts[0], parts[1])) != null) {
                List inheritedAttrs;
                this.writer.println("                    <p><strong>Base Type:</strong> " + this.escapeHtml(parentDef.getDescription()) + "</p>");
                this.writer.println("                    <p><strong>Child Types:</strong></p>");
                this.writer.println("                    <ul>");
                for (TypeDefinition child : children) {
                    this.writer.println("                        <li><strong>" + this.escapeHtml(child.getQualifiedName()) + "</strong> - " + this.escapeHtml(child.getDescription()) + "</li>");
                }
                this.writer.println("                    </ul>");
                if (parentDef.getChildRequirements() != null && !parentDef.getChildRequirements().isEmpty() && !(inheritedAttrs = parentDef.getChildRequirements().stream().filter(req -> "attr".equals(req.getExpectedType())).collect(Collectors.toList())).isEmpty()) {
                    this.writer.println("                    <p><strong>Common Inherited Attributes:</strong></p>");
                    this.writer.println("                    <div class=\"attributes-grid\">");
                    for (ChildRequirement req2 : inheritedAttrs) {
                        this.writer.println("                        <div class=\"attribute\">");
                        this.writer.println("                            <div class=\"attribute-name\">" + this.escapeHtml(req2.getName()) + "</div>");
                        this.writer.println("                            <div class=\"attribute-type\">" + this.escapeHtml(req2.getExpectedSubType()) + "</div>");
                        if (req2.isRequired()) {
                            this.writer.println("                            <div class=\"attribute-required\">Required</div>");
                        } else {
                            this.writer.println("                            <div class=\"attribute-optional\">Optional</div>");
                        }
                        this.writer.println("                        </div>");
                    }
                    this.writer.println("                    </div>");
                }
            }
            this.writer.println("                </div>");
        }
        this.writer.println("            </section>");
    }

    private void generateTypesSection() {
        this.writer.println("            <section id=\"types\" class=\"section\">");
        this.writer.println("                <h2>Type Definitions</h2>");
        this.writer.println("                <p>Complete catalog of all registered MetaData types with detailed specifications.</p>");
        Map<String, List<TypeDefinition>> typesByCategory = this.typeRegistry.getAllTypeDefinitions().stream().collect(Collectors.groupingBy(TypeDefinition::getType));
        for (Map.Entry<String, List<TypeDefinition>> categoryEntry : typesByCategory.entrySet()) {
            String category = categoryEntry.getKey();
            List<TypeDefinition> typesInCategory = categoryEntry.getValue();
            this.writer.println("                <h3 id=\"category-" + this.escapeHtml(category) + "\">" + this.capitalizeFirst(category) + " Types</h3>");
            for (TypeDefinition typeDef : typesInCategory) {
                this.generateTypeCard(typeDef);
            }
        }
        this.writer.println("            </section>");
    }

    private void generateTypeCard(TypeDefinition typeDef) {
        this.writer.println("                <div class=\"type-card\">");
        this.writer.println("                    <div class=\"type-header\">");
        this.writer.println("                        <div class=\"type-name\">" + this.escapeHtml(typeDef.getQualifiedName()) + "</div>");
        this.writer.println("                        <div class=\"type-badge\">" + this.escapeHtml(typeDef.getImplementationClass().getSimpleName()) + "</div>");
        this.writer.println("                    </div>");
        this.writer.println("                    <p>" + this.escapeHtml(typeDef.getDescription()) + "</p>");
        if (typeDef.hasParent()) {
            this.writer.println("                    <div class=\"inheritance-chain\">");
            this.writer.println("                        <strong>Inherits from:</strong> " + this.escapeHtml(typeDef.getParentQualifiedName()));
            this.writer.println("                    </div>");
        }
        this.writer.println("                    <p><strong>Implementation:</strong> <code>" + this.escapeHtml(typeDef.getImplementationClass().getName()) + "</code></p>");
        if (typeDef.getChildRequirements() != null && !typeDef.getChildRequirements().isEmpty()) {
            this.writer.println("                    <h4>Attributes & Children</h4>");
            this.writer.println("                    <div class=\"attributes-grid\">");
            for (ChildRequirement req : typeDef.getChildRequirements()) {
                this.writer.println("                        <div class=\"attribute\">");
                this.writer.println("                            <div class=\"attribute-name\">" + this.escapeHtml(req.getName()) + "</div>");
                this.writer.println("                            <div class=\"attribute-type\">" + this.escapeHtml(req.getExpectedType() + "." + req.getExpectedSubType()) + "</div>");
                if (req.isRequired()) {
                    this.writer.println("                            <div class=\"attribute-required\">Required</div>");
                } else {
                    this.writer.println("                            <div class=\"attribute-optional\">Optional</div>");
                }
                if (req.getDescription() != null && !req.getDescription().isEmpty()) {
                    this.writer.println("                            <div class=\"attribute-type\">" + this.escapeHtml(req.getDescription()) + "</div>");
                }
                this.writer.println("                        </div>");
            }
            this.writer.println("                    </div>");
        }
        if (this.includeExamples) {
            this.generateTypeExample(typeDef);
        }
        this.writer.println("                </div>");
    }

    private void generateTypeExample(TypeDefinition typeDef) {
        this.writer.println("                    <h4>Usage Example</h4>");
        this.writer.println("                    <div class=\"code-block\">");
        String className = typeDef.getImplementationClass().getSimpleName();
        String type = typeDef.getType();
        String subType = typeDef.getSubType();
        if ("field".equals(type)) {
            this.writer.println("// JSON metadata definition");
            this.writer.println("{");
            this.writer.println("  \"field\": {");
            this.writer.println("    \"name\": \"" + subType + "Field\",");
            this.writer.println("    \"type\": \"" + subType + "\"");
            if ("string".equals(subType)) {
                this.writer.println("    \"@maxLength\": 255,");
                this.writer.println("    \"@required\": true");
            } else if ("int".equals(subType) || "long".equals(subType)) {
                this.writer.println("    \"@required\": true");
            }
            this.writer.println("  }");
            this.writer.println("}");
            this.writer.println("");
            this.writer.println("// Java API usage");
            this.writer.println(className + " field = new " + className + "(\"fieldName\");");
        } else if ("object".equals(type)) {
            this.writer.println("// JSON metadata definition");
            this.writer.println("{");
            this.writer.println("  \"object\": {");
            this.writer.println("    \"name\": \"Example" + this.capitalizeFirst(subType) + "\",");
            this.writer.println("    \"type\": \"" + subType + "\"");
            this.writer.println("  }");
            this.writer.println("}");
            this.writer.println("");
            this.writer.println("// Java API usage");
            this.writer.println(className + " obj = new " + className + "(\"ExampleObject\");");
        } else {
            this.writer.println("// Type registration example");
            this.writer.println("MetaDataRegistry.registerType(" + className + ".class, def -> def");
            this.writer.println("    .type(\"" + type + "\").subType(\"" + subType + "\")");
            if (typeDef.hasParent()) {
                this.writer.println("    .inheritsFrom(\"" + typeDef.getParentQualifiedName().replace(".", "\", \"") + "\")");
            }
            this.writer.println("    .description(\"" + this.escapeHtml(typeDef.getDescription()) + "\"));");
        }
        this.writer.println("                    </div>");
    }

    private void generateExtensionGuideSection() {
        this.writer.println("            <section id=\"extensions\" class=\"section\">");
        this.writer.println("                <h2>Extension & Plugin Development Guide</h2>");
        this.writer.println("                <p>The MetaObjects framework is designed for extensibility. This guide shows how to create custom types, attributes, and behaviors.</p>");
        this.writer.println("                <h3>Creating Custom Field Types</h3>");
        this.writer.println("                <div class=\"code-block\">");
        this.writer.println("@MetaDataType(type = \"field\", subType = \"currency\", description = \"Currency field with precision\")");
        this.writer.println("public class CurrencyField extends PrimitiveField&lt;BigDecimal&gt; {");
        this.writer.println("    ");
        this.writer.println("    static {");
        this.writer.println("        MetaDataRegistry.registerType(CurrencyField.class, def -> def");
        this.writer.println("            .type(TYPE_FIELD).subType(\"currency\")");
        this.writer.println("            .inheritsFrom(TYPE_FIELD, SUBTYPE_BASE)  // Inherits all field.base attributes");
        this.writer.println("            .optionalAttribute(\"precision\", \"int\")");
        this.writer.println("            .optionalAttribute(\"currencyCode\", \"string\")");
        this.writer.println("            .description(\"Currency field with precision and formatting\"));");
        this.writer.println("    }");
        this.writer.println("}");
        this.writer.println("                </div>");
        this.writer.println("                <h3>Creating Custom Object Types</h3>");
        this.writer.println("                <div class=\"code-block\">");
        this.writer.println("@MetaDataType(type = \"object\", subType = \"auditable\", description = \"Object with audit trails\")");
        this.writer.println("public class AuditableObject extends PojoMetaObject {");
        this.writer.println("    ");
        this.writer.println("    static {");
        this.writer.println("        MetaDataRegistry.registerType(AuditableObject.class, def -> def");
        this.writer.println("            .type(TYPE_OBJECT).subType(\"auditable\")");
        this.writer.println("            .inheritsFrom(TYPE_OBJECT, SUBTYPE_BASE)  // Inherits all object.base attributes");
        this.writer.println("            .requiredAttribute(\"auditEnabled\", \"boolean\")");
        this.writer.println("            .optionalAttribute(\"auditTable\", \"string\")");
        this.writer.println("            .description(\"Object type with automatic audit trail support\"));");
        this.writer.println("    }");
        this.writer.println("}");
        this.writer.println("                </div>");
        this.writer.println("                <h3>Extension Patterns</h3>");
        this.writer.println("                <div class=\"attributes-grid\">");
        this.writer.println("                    <div class=\"attribute\">");
        this.writer.println("                        <div class=\"attribute-name\">Inherit from Base Types</div>");
        this.writer.println("                        <div class=\"attribute-type\">Use .inheritsFrom() to get common attributes automatically</div>");
        this.writer.println("                    </div>");
        this.writer.println("                    <div class=\"attribute\">");
        this.writer.println("                        <div class=\"attribute-name\">Custom Attributes</div>");
        this.writer.println("                        <div class=\"attribute-type\">Add type-specific attributes via .requiredAttribute() or .optionalAttribute()</div>");
        this.writer.println("                    </div>");
        this.writer.println("                    <div class=\"attribute\">");
        this.writer.println("                        <div class=\"attribute-name\">Service Discovery</div>");
        this.writer.println("                        <div class=\"attribute-type\">Use META-INF/services for automatic registration</div>");
        this.writer.println("                    </div>");
        this.writer.println("                    <div class=\"attribute\">");
        this.writer.println("                        <div class=\"attribute-name\">Cross-Module Support</div>");
        this.writer.println("                        <div class=\"attribute-type\">String-based inheritance works across module boundaries</div>");
        this.writer.println("                    </div>");
        this.writer.println("                </div>");
        this.writer.println("                <h3>Available Extension Points</h3>");
        this.writer.println("                <ul>");
        List baseTypes = this.typeRegistry.getAllTypeDefinitions().stream().filter(def -> "base".equals(def.getSubType())).collect(Collectors.toList());
        for (TypeDefinition baseDef : baseTypes) {
            this.writer.println("                    <li><strong>" + this.escapeHtml(baseDef.getQualifiedName()) + ":</strong> " + this.escapeHtml(baseDef.getDescription()) + "</li>");
        }
        this.writer.println("                </ul>");
        this.writer.println("            </section>");
    }

    private void generateFooter() {
        this.writer.println("    <div class=\"footer\">");
        this.writer.println("        <p>Generated by MetaObjects Framework Documentation Generator v" + this.escapeHtml(this.version) + "</p>");
        this.writer.println("        <p>MetaObjects Framework - Metadata-Driven Development Platform</p>");
        this.writer.println("    </div>");
    }

    private void generateJavaScript() {
        this.writer.println("    <script>");
        this.writer.println("        // Smooth scrolling for navigation links");
        this.writer.println("        document.querySelectorAll('a[href^=\"#\"]').forEach(anchor => {");
        this.writer.println("            anchor.addEventListener('click', function (e) {");
        this.writer.println("                e.preventDefault();");
        this.writer.println("                const target = document.querySelector(this.getAttribute('href'));");
        this.writer.println("                if (target) {");
        this.writer.println("                    target.scrollIntoView({ behavior: 'smooth', block: 'start' });");
        this.writer.println("                }");
        this.writer.println("            });");
        this.writer.println("        });");
        this.writer.println("        ");
        this.writer.println("        // Highlight current section in navigation");
        this.writer.println("        const sections = document.querySelectorAll('section[id]');");
        this.writer.println("        const navLinks = document.querySelectorAll('.sidebar a[href^=\"#\"]');");
        this.writer.println("        ");
        this.writer.println("        function updateActiveNavigation() {");
        this.writer.println("            let current = '';");
        this.writer.println("            sections.forEach(section => {");
        this.writer.println("                const sectionTop = section.getBoundingClientRect().top;");
        this.writer.println("                if (sectionTop <= 100) current = section.getAttribute('id');");
        this.writer.println("            });");
        this.writer.println("            ");
        this.writer.println("            navLinks.forEach(link => {");
        this.writer.println("                link.style.backgroundColor = '';");
        this.writer.println("                link.style.color = '';");
        this.writer.println("                if (link.getAttribute('href') === '#' + current) {");
        this.writer.println("                    link.style.backgroundColor = '#f0f4ff';");
        this.writer.println("                    link.style.color = '#667eea';");
        this.writer.println("                }");
        this.writer.println("            });");
        this.writer.println("        }");
        this.writer.println("        ");
        this.writer.println("        window.addEventListener('scroll', updateActiveNavigation);");
        this.writer.println("        window.addEventListener('load', updateActiveNavigation);");
        this.writer.println("    </script>");
    }

    private String escapeHtml(String text) {
        if (text == null) {
            return "";
        }
        return text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&#39;");
    }

    private String capitalizeFirst(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        return Character.toUpperCase(text.charAt(0)) + text.substring(1);
    }

    private int countInheritanceRelationships() {
        return (int)this.typeRegistry.getAllTypeDefinitions().stream().filter(def -> def.hasParent()).count();
    }

    private int countExtensionPoints() {
        return (int)this.typeRegistry.getAllTypeDefinitions().stream().filter(def -> "base".equals(def.getSubType())).count();
    }

    @Override
    public String toString() {
        return "MetaDataHtmlDocumentationWriter{version='" + this.version + "', registeredTypes=" + this.typeRegistry.getRegisteredTypes().size() + ", includeInheritance=" + this.includeInheritance + ", includeExamples=" + this.includeExamples + "}";
    }
}

