/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework;

import com.metaring.framework.SysKB;
import com.metaring.framework.Tools;
import com.metaring.framework.type.DataRepresentation;
import com.metaring.framework.type.series.TextSeries;
import java.util.ArrayList;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.Resource;

public class Core {
    public static final SysKB SYSKB;
    public static final TextSeries ARGUMENTS;
    private static final ApplicationContext APPLICATION_CONTEXT;

    private static final SysKB getSystemKB() {
        DataRepresentation configuration = Core.load("metaring.config.json");
        if (configuration == null || configuration.isNull().booleanValue() || !configuration.hasProperties().booleanValue()) {
            throw new IllegalAccessError("Invalid System Main Configuration file location.");
        }
        return Tools.FACTORY_SYSKB.create(Core.load("metaring.config.default.json").merge(configuration, new DataRepresentation[]{Core.load("metaring.config.local.json")}));
    }

    private static final DataRepresentation load(String filename) {
        DataRepresentation dataRepresentation = Tools.FACTORY_DATA_REPRESENTATION.create();
        try {
            Resource[] resources = APPLICATION_CONTEXT.getResources("classpath*:" + filename);
            if (resources == null || resources.length == 0) {
                resources = APPLICATION_CONTEXT.getResources("classpath*:*/*/" + filename);
            }
            for (Resource resource : resources) {
                dataRepresentation.merge((DataRepresentation)Tools.FACTORY_SYSKB.load(resource.getURL().toString()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dataRepresentation;
    }

    static {
        APPLICATION_CONTEXT = new GenericApplicationContext();
        SYSKB = Core.getSystemKB();
        String[] texts = new String[]{};
        try {
            String arguments;
            String[] args;
            String commandLine = System.getProperty("sun.java.command");
            int mainClassNameEnd = commandLine.length();
            if (commandLine.contains(" ")) {
                mainClassNameEnd = commandLine.indexOf(" ");
            }
            if (commandLine.contains(" ") && (args = (arguments = commandLine.substring(mainClassNameEnd + 1)).split(" ")) != null && args.length > 0) {
                ArrayList<String> textList = new ArrayList<String>();
                for (String arg : args) {
                    textList.add(arg);
                }
                texts = new String[textList.size()];
                texts = textList.toArray(texts);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ARGUMENTS = Tools.FACTORY_TEXT_SERIES.create(texts);
    }
}

