/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework.exception;

import com.metaring.framework.Tools;
import com.metaring.framework.exception.CoreException;
import com.metaring.framework.type.series.TextSeries;
import java.util.List;

public abstract class ManagedException
extends CoreException {
    private static final long serialVersionUID = 5541088841619378587L;
    private String name = this.getClass().getSimpleName().replace("Exception", "");
    private TextSeries payload = null;

    public ManagedException() {
    }

    public ManagedException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
    }

    public ManagedException(String message, Throwable cause) {
        super(message, cause);
    }

    public ManagedException(String message) {
        super(message);
    }

    public ManagedException(Throwable cause) {
        super(cause);
    }

    public final String getName() {
        return this.name;
    }

    public final TextSeries getPayload() {
        return this.payload;
    }

    protected final void fillPayload(TextSeries textSeries) {
        this.payload = textSeries;
    }

    protected final void fillPayload(String ... texts) {
        if (texts == null || texts.length == 0) {
            return;
        }
        this.payload = Tools.FACTORY_TEXT_SERIES.create(texts);
    }

    protected final void fillPayload(List texts) {
        if (texts == null || texts.isEmpty()) {
            return;
        }
        if (texts.get(0) instanceof String) {
            this.fillPayload(texts.toArray(new String[texts.size()]));
        } else {
            String[] ts = new String[texts.size()];
            for (int i = 0; i < texts.size(); ++i) {
                ts[i] = texts.get(i).toString();
            }
            this.payload = Tools.FACTORY_TEXT_SERIES.create(ts);
        }
    }
}

