/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework.util;

import com.metaring.framework.util.CryptoUtil;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class Crypto {
    private final Cipher encrypter;
    private final Cipher decrypter;

    public Crypto(String algorythm, String key, String keyType, int maxKeyLength) {
        try {
            this.encrypter = Cipher.getInstance(algorythm);
            SecretKeySpec k = new SecretKeySpec(Crypto.prepareKey(key, maxKeyLength).getBytes(CryptoUtil.CHARSET_UTF_8), keyType);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(new byte[this.encrypter.getBlockSize()]);
            this.encrypter.init(1, (Key)k, ivParameterSpec);
            this.decrypter = Cipher.getInstance(algorythm);
            this.decrypter.init(2, (Key)k, ivParameterSpec);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("An error occurred while creating Crypto Cipher" + e);
        }
    }

    private static final String prepareKey(String key, int maxKeyLength) {
        try {
            if (key.length() >= maxKeyLength) {
                return key.substring(0, maxKeyLength);
            }
            while (key.length() < maxKeyLength) {
                key = key + "0";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return key;
    }

    public final String encrypt(String input) {
        try {
            return CryptoUtil.toBase64String(this.encrypter.doFinal(input.getBytes(CryptoUtil.CHARSET_UTF_8)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final String decrypt(String input) {
        try {
            return new String(this.decrypter.doFinal(CryptoUtil.fromBase64(input)), CryptoUtil.CHARSET_UTF_8);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

