/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework.util;

import com.metaring.framework.type.DataRepresentation;
import com.metaring.framework.util.StringUtil;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.calcite.linq4j.Linq4j;

public final class ObjectUtil {
    public static final <T> boolean isNullOrEmpty(T[] input) {
        return Objects.isNull(input) || input.length == 0;
    }

    public static final boolean isNullOrEmpty(Iterable<?> input) {
        return Objects.isNull(input) || Linq4j.asEnumerable(input).count() == 0;
    }

    public static final boolean isNullOrEmpty(Map<?, ?> input) {
        return Objects.isNull(input) || input.isEmpty();
    }

    public static final boolean isNullOrEmpty(DataRepresentation input) {
        return Objects.isNull(input) || input.isNullOrEmpty() != false;
    }

    public static final Properties toProperties(DataRepresentation rep) {
        return ObjectUtil.toProperties(rep, null, null);
    }

    private static final Properties toProperties(DataRepresentation initialData, Properties properties, String current) {
        Properties properties2 = properties = properties == null ? new Properties() : properties;
        if (ObjectUtil.isNullOrEmpty(initialData)) {
            return properties;
        }
        for (String currentProperty : initialData.getProperties()) {
            String propertyName = String.join((CharSequence)(StringUtil.isNullOrEmpty(current) ? "" : "."), StringUtil.isNullOrEmpty(current) ? "" : current, currentProperty);
            DataRepresentation dataRepresentation = initialData.get(currentProperty);
            if (dataRepresentation.hasProperties().booleanValue()) {
                ObjectUtil.toProperties(dataRepresentation, properties, propertyName);
                continue;
            }
            properties.put(propertyName, initialData.getText(currentProperty));
        }
        return properties;
    }
}

