/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework.util;

import com.metaring.framework.type.DataRepresentation;
import com.metaring.framework.util.DataRepresentationUtil;
import com.metaring.framework.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import org.apache.calcite.linq4j.Linq4j;

public final class ObjectUtil {
    public static final <T> boolean isNullOrEmpty(T[] input) {
        return Objects.isNull(input) || input.length == 0;
    }

    public static final boolean isNullOrEmpty(Iterable<?> input) {
        return Objects.isNull(input) || Linq4j.asEnumerable(input).count() == 0;
    }

    public static final boolean isNullOrEmpty(Map<?, ?> input) {
        return Objects.isNull(input) || input.isEmpty();
    }

    public static final boolean isNullOrEmpty(DataRepresentation input) {
        return Objects.isNull(input) || input.isNullOrEmpty() != false;
    }

    public static final Map<String, Object> toMap(DataRepresentation rep) {
        return ObjectUtil.toMap(rep, false);
    }

    public static final Map<String, Object> toMap(DataRepresentation rep, boolean preserveNativeType) {
        return ObjectUtil.toMap(rep, null, null, preserveNativeType ? DataRepresentationUtil::toNative : DataRepresentationUtil::toText);
    }

    private static final Map<String, Object> toMap(DataRepresentation initialData, Map<String, Object> map, String current, Function<DataRepresentation, Object> transformer) {
        HashMap<String, Object> hashMap = map = ObjectUtil.isNullOrEmpty(map) ? new HashMap<String, Object>() : map;
        if (ObjectUtil.isNullOrEmpty(initialData)) {
            return map;
        }
        if (!StringUtil.isNullOrEmpty(current)) {
            map.put(current, transformer.apply(initialData));
        }
        if (initialData.hasProperties().booleanValue()) {
            for (String currentProperty : initialData.getProperties()) {
                String propertyName = String.join((CharSequence)(StringUtil.isNullOrEmpty(current) ? "" : "."), StringUtil.isNullOrEmpty(current) ? "" : current, currentProperty);
                map = ObjectUtil.toMap(initialData.get(currentProperty), map, propertyName, transformer);
            }
        }
        if (initialData.hasLength().booleanValue()) {
            int i = 0;
            for (DataRepresentation item : initialData) {
                String propertyName = String.join((CharSequence)(StringUtil.isNullOrEmpty(current) ? "" : "."), StringUtil.isNullOrEmpty(current) ? "" : current, "." + i++);
                map = ObjectUtil.toMap(item, map, propertyName, transformer);
            }
        }
        return map;
    }

    public static final Properties toProperties(Map<?, ?> map) {
        if (ObjectUtil.isNullOrEmpty(map)) {
            return new Properties();
        }
        Properties properties = new Properties();
        for (Object key : map.keySet()) {
            properties.put(key, map.get(key));
        }
        return properties;
    }

    public static final Properties toProperties(DataRepresentation dataRep) {
        if (ObjectUtil.isNullOrEmpty(dataRep)) {
            return new Properties();
        }
        return ObjectUtil.toProperties(ObjectUtil.toMap(dataRep));
    }

    public static final Properties toProperties(DataRepresentation dataRep, boolean preserveNativeType) {
        if (ObjectUtil.isNullOrEmpty(dataRep)) {
            return new Properties();
        }
        return ObjectUtil.toProperties(ObjectUtil.toMap(dataRep, preserveNativeType));
    }
}

