/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.variables.StackFrameReference;
import com.microsoft.java.debug.core.adapter.variables.VariableProxy;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.microsoft.java.debug.core.protocol.Responses;
import com.microsoft.java.debug.core.protocol.Types;
import com.sun.jdi.ThreadReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class ScopesRequestHandler
implements IDebugRequestHandler {
    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.SCOPES);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext context) {
        Requests.ScopesArguments scopesArgs = (Requests.ScopesArguments)arguments;
        ArrayList<Types.Scope> scopes = new ArrayList<Types.Scope>();
        StackFrameReference stackFrameReference = (StackFrameReference)context.getRecyclableIdPool().getObjectById(scopesArgs.frameId);
        if (stackFrameReference == null) {
            response.body = new Responses.ScopesResponseBody(scopes);
            return CompletableFuture.completedFuture(response);
        }
        ThreadReference thread = stackFrameReference.getThread();
        VariableProxy localScope = new VariableProxy(thread, "Local", stackFrameReference);
        int localScopeId = context.getRecyclableIdPool().addObject(thread.uniqueID(), localScope);
        scopes.add(new Types.Scope(localScope.getScope(), localScopeId, false));
        response.body = new Responses.ScopesResponseBody(scopes);
        return CompletableFuture.completedFuture(response);
    }
}

