/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.formatter;

import com.microsoft.java.debug.core.adapter.formatter.IValueFormatter;
import com.microsoft.java.debug.core.adapter.formatter.ObjectFormatter;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StringReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class StringObjectFormatter
extends ObjectFormatter
implements IValueFormatter {
    public static final String MAX_STRING_LENGTH_OPTION = "max_string_length";
    private static final int DEFAULT_MAX_STRING_LENGTH = 0;
    private static final String QUOTE_STRING = "\"";

    public StringObjectFormatter() {
        super(null);
    }

    @Override
    public Map<String, Object> getDefaultOptions() {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put(MAX_STRING_LENGTH_OPTION, 0);
        return options;
    }

    @Override
    public String toString(Object value, Map<String, Object> options) {
        int maxLength = StringObjectFormatter.getMaxStringLength(options);
        return String.format("\"%s\" %s", maxLength > 0 ? StringUtils.abbreviate((String)((StringReference)value).value(), (int)maxLength) : ((StringReference)value).value(), StringObjectFormatter.getIdPostfix((ObjectReference)value, options));
    }

    @Override
    public boolean acceptType(Type type, Map<String, Object> options) {
        return type != null && (type.signature().charAt(0) == 's' || type.signature().equals("Ljava/lang/String;"));
    }

    @Override
    public Value valueOf(String value, Type type, Map<String, Object> options) {
        if (value == null || "null".equals(value)) {
            return null;
        }
        if (value.length() >= 2 && value.startsWith(QUOTE_STRING) && value.endsWith(QUOTE_STRING)) {
            return type.virtualMachine().mirrorOf(StringUtils.substring((String)value, (int)1, (int)-1));
        }
        return type.virtualMachine().mirrorOf(value);
    }

    private static int getMaxStringLength(Map<String, Object> options) {
        return options.containsKey(MAX_STRING_LENGTH_OPTION) ? (Integer)options.get(MAX_STRING_LENGTH_OPTION) : 0;
    }
}

