/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.LaunchMode;
import com.microsoft.java.debug.core.adapter.handler.ILaunchDelegate;
import com.microsoft.java.debug.core.adapter.handler.LaunchWithDebuggingDelegate;
import com.microsoft.java.debug.core.adapter.handler.LaunchWithoutDebuggingDelegate;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class LaunchRequestHandler
implements IDebugRequestHandler {
    protected static final Logger logger = Logger.getLogger("java-debug");
    protected static final long RUNINTERMINAL_TIMEOUT = 10000L;
    protected ILaunchDelegate activeLaunchHandler;

    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.LAUNCH);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext context) {
        Requests.LaunchArguments launchArguments = (Requests.LaunchArguments)arguments;
        this.activeLaunchHandler = launchArguments.noDebug ? new LaunchWithoutDebuggingDelegate() : new LaunchWithDebuggingDelegate();
        return this.handleLaunchCommand(arguments, response, context);
    }

    protected CompletableFuture<Messages.Response> handleLaunchCommand(Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext context) {
        Requests.LaunchArguments launchArguments = (Requests.LaunchArguments)arguments;
        if (StringUtils.isBlank((CharSequence)launchArguments.mainClass) || ArrayUtils.isEmpty((Object[])launchArguments.modulePaths) && ArrayUtils.isEmpty((Object[])launchArguments.classPaths)) {
            throw AdapterUtils.createCompletionException("Failed to launch debuggee VM. Missing mainClass or modulePaths/classPaths options in launch configuration.", ErrorCode.ARGUMENT_MISSING);
        }
        if (StringUtils.isBlank((CharSequence)launchArguments.encoding)) {
            context.setDebuggeeEncoding(StandardCharsets.UTF_8);
        } else {
            if (!Charset.isSupported(launchArguments.encoding)) {
                throw AdapterUtils.createCompletionException("Failed to launch debuggee VM. 'encoding' options in the launch configuration is not recognized.", ErrorCode.INVALID_ENCODING);
            }
            context.setDebuggeeEncoding(Charset.forName(launchArguments.encoding));
        }
        launchArguments.vmArgs = StringUtils.isBlank((CharSequence)launchArguments.vmArgs) ? String.format("-Dfile.encoding=%s", context.getDebuggeeEncoding().name()) : String.format("%s -Dfile.encoding=%s", launchArguments.vmArgs, context.getDebuggeeEncoding().name());
        context.setLaunchMode(launchArguments.noDebug ? LaunchMode.NO_DEBUG : LaunchMode.DEBUG);
        this.activeLaunchHandler.preLaunch(launchArguments, context);
        return this.launch(launchArguments, response, context).thenCompose(res -> {
            if (res.success) {
                this.activeLaunchHandler.postLaunch(launchArguments, context);
            }
            return CompletableFuture.completedFuture(res);
        });
    }

    protected static String[] constructLaunchCommands(Requests.LaunchArguments launchArguments, boolean serverMode, String address) {
        String slash = System.getProperty("file.separator");
        ArrayList<String> launchCmds = new ArrayList<String>();
        launchCmds.add(System.getProperty("java.home") + slash + "bin" + slash + "java");
        if (StringUtils.isNotEmpty((CharSequence)address)) {
            launchCmds.add(String.format("-agentlib:jdwp=transport=dt_socket,server=%s,suspend=y,address=%s", serverMode ? "y" : "n", address));
        }
        if (StringUtils.isNotBlank((CharSequence)launchArguments.vmArgs)) {
            launchCmds.addAll(LaunchRequestHandler.parseArguments(launchArguments.vmArgs));
        }
        if (ArrayUtils.isNotEmpty((Object[])launchArguments.modulePaths)) {
            launchCmds.add("--module-path");
            launchCmds.add(String.join((CharSequence)File.pathSeparator, launchArguments.modulePaths));
        }
        if (ArrayUtils.isNotEmpty((Object[])launchArguments.classPaths)) {
            launchCmds.add("-cp");
            launchCmds.add(String.join((CharSequence)File.pathSeparator, launchArguments.classPaths));
        }
        String[] mainClasses = launchArguments.mainClass.split("/");
        if (ArrayUtils.isNotEmpty((Object[])launchArguments.modulePaths) || mainClasses.length == 2) {
            launchCmds.add("-m");
        }
        launchCmds.add(launchArguments.mainClass);
        if (StringUtils.isNotBlank((CharSequence)launchArguments.args)) {
            launchCmds.addAll(LaunchRequestHandler.parseArguments(launchArguments.args));
        }
        return launchCmds.toArray(new String[0]);
    }

    protected CompletableFuture<Messages.Response> launch(Requests.LaunchArguments launchArguments, Messages.Response response, IDebugAdapterContext context) {
        logger.info("Trying to launch Java Program with options:\n" + String.format("main-class: %s\n", launchArguments.mainClass) + String.format("args: %s\n", launchArguments.args) + String.format("module-path: %s\n", StringUtils.join((Object[])launchArguments.modulePaths, (String)File.pathSeparator)) + String.format("class-path: %s\n", StringUtils.join((Object[])launchArguments.classPaths, (String)File.pathSeparator)) + String.format("vmArgs: %s", launchArguments.vmArgs));
        if (context.supportsRunInTerminalRequest() && (launchArguments.console == Requests.CONSOLE.integratedTerminal || launchArguments.console == Requests.CONSOLE.externalTerminal)) {
            return this.activeLaunchHandler.launchInTerminal(launchArguments, response, context);
        }
        return this.activeLaunchHandler.launchInternally(launchArguments, response, context);
    }

    protected static String[] constructEnvironmentVariables(Requests.LaunchArguments launchArguments) {
        String[] envVars = null;
        if (launchArguments.env != null && !launchArguments.env.isEmpty()) {
            HashMap<String, String> environment = new HashMap<String, String>(System.getenv());
            ArrayList<String> duplicated = new ArrayList<String>();
            for (Map.Entry<String, String> entry : launchArguments.env.entrySet()) {
                if (environment.containsKey(entry.getKey())) {
                    duplicated.add(entry.getKey());
                }
                environment.put(entry.getKey(), entry.getValue());
            }
            if (!duplicated.isEmpty()) {
                logger.warning(String.format("There are duplicated environment variables. The values specified in launch.json will be used. Here are the duplicated entries: %s.", String.join((CharSequence)",", duplicated)));
            }
            envVars = new String[environment.size()];
            int i = 0;
            for (Map.Entry entry : environment.entrySet()) {
                envVars[i++] = (String)entry.getKey() + "=" + (String)entry.getValue();
            }
        }
        return null;
    }

    protected static List<String> parseArguments(String cmdStr) {
        ArrayList<String> list = new ArrayList<String>();
        Matcher m = Pattern.compile("([^\"]\\S*|\".+?\")\\s*").matcher(cmdStr);
        while (m.find()) {
            String arg = m.group(1).replaceAll("^\"|\"$", "");
            list.add(arg);
        }
        return list;
    }

    public static String parseMainClassWithoutModuleName(String mainClass) {
        int index = mainClass.indexOf(47);
        return mainClass.substring(index + 1);
    }
}

